// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Config/hkProductFeatures.h>

/// Octree data-structure and related utilities.
struct HK_EXPORT_COMMON hkgpOctree
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, hkgpOctree);

    /// Node
    struct HK_EXPORT_COMMON Node
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, Node);

        HK_INLINE           Node() { m_children[0] = -1; }
        HK_INLINE hkBool    hasChildren() const { return m_children[0] != -1; }
        HK_INLINE hkBool    isLeaf() const { return m_children[0] == -1; }
        HK_INLINE int       operator[](int index) const { HK_ASSERT(0x24C87FF9, hasChildren() && index >= 0 && index <= 7, "Invalid index"); return m_children[index]; }
        HK_INLINE int&      operator[](int index) { HK_ASSERT(0x24C87FFA, index >= 0 && index <= 7, "Invalid index"); return m_children[index]; }

        int m_children[8];  ///< Children node indices.
    };

    /// Structure holding dual information during enumeration.
    struct HK_EXPORT_COMMON Dual
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, Dual);

        /// Type of feature.
        enum Type { INVALID = 0, VERTEX = 1, EDGE = 2, FACE = 4, VOLUME = 8 };

        /// Feature axis.
        enum Axis { NONE = -1, AXE_X = 0, AXE_Y = 1, AXE_Z = 2 };

        HK_INLINE           Dual() : m_type(INVALID), m_axis(NONE) {}
        HK_INLINE           Dual(int a) : m_type(VERTEX), m_axis(NONE) { m_nodes[0] = a; }
        HK_INLINE           Dual(Axis axis, int a,int b) : m_type(EDGE), m_axis(axis) { m_nodes[0] = a; m_nodes[1] = b; }
        HK_INLINE           Dual(Axis axis, int a,int b,int c,int d) : m_type(FACE), m_axis(axis) { m_nodes[0] = a; m_nodes[1] = b; m_nodes[2] = c; m_nodes[3] = d; }
        HK_INLINE           Dual(int a,int b,int c,int d,int e,int f,int g,int h) : m_type(VOLUME), m_axis(NONE) { m_nodes[0] = a; m_nodes[1] = b; m_nodes[2] = c; m_nodes[3] = d; m_nodes[4] = e; m_nodes[5] = f; m_nodes[6] = g; m_nodes[7] = h; }
        HK_INLINE int       operator[](int index) const { HK_ASSERT(0x297A8AE0, index < m_type, "Invalid index"); return m_nodes[index]; }
        HK_INLINE int&  operator[](int index) { HK_ASSERT(0x297A8AE0, index < m_type, "Invalid index"); return m_nodes[index]; }

        Type    m_type:16;  ///< Type of feature.
        Axis    m_axis:16;  ///< Feature axis.
        int     m_nodes[8]; ///< Node indices.
    };

    /// Wrapper that provides support for virtual boundaries.
    template <typename OCTREE>
    struct PrimalOctree
    {
        HK_INLINE           PrimalOctree(OCTREE& octree) : m_octree(octree) {}

        HK_INLINE int       getRoot() const { return m_octree.getRoot(); }
        HK_INLINE int       getChild(int node, int index) const { return m_octree.getChild(node,index); }
        HK_INLINE bool  hasChildren(int node) const { return m_octree.hasChildren(node); }
        HK_INLINE bool  isValid(int node) const { return m_octree.isValid(node); }
        HK_INLINE bool  processVolume(const int nodes[8]) const { return m_octree.processVolume(nodes); }
        HK_INLINE void  processTetrahedron(const int nodes[4]) const { m_octree.processTetrahedron(nodes); }

        OCTREE& m_octree;
    };

    // Utilities.

    /// Enumerate all valid volumes and tetrahedra of an octree dual.
    /// OCTREE must implement the following methods:
    /// - int getRoot() const , return the root of the octree.
    /// - int getChild(int node,int index) const, returns the child node at a given index (0-7).
    /// - bool hasChildren(int node) const, returns true if the node has children.
    /// - bool isValid(int node) const, returns true if the node is valid.
    /// - void processVolume(const int nodes[8]) const, called to process a volume.
    /// - void processTetrahedron(const int nodes[4]) const, called to process a tetrahedron (only called if processVolume() returns true).
    /// Note: a valid node index must be greater or equal to zero.
    template <typename OCTREE>
    static inline void  enumerateDual(OCTREE& octree);

    // Lookup tables.

    static const int    lut_tetras[6][4];
    static const int    lut_edges[12][2];
    static const int    lut_faces[6][4];
    static const int    lut_edge_volumes[3][8][2];
    static const int    lut_face_volumes[3][8][2];
    static const int    lut_tetra_triangles[4][3];
    static const int    lut_volume_triangles[12][3];
    static const int    lut_mc_directedEdges[12][2];
    static const int    lut_mc_activeEdges[256];
    static const signed char lut_mc_triangles[256][16];
};

#include <Common/Internal/GeometryProcessing/Octree/hkgpOctree.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
