// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY       : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkInt32 hkImageFilterWeights::getFirstSourceSampleIndex(hkUint32 dstSampleIndex) const
{
    hkSimdFloat32 dstSampleInSourceSpace = (hkSimdFloat32::fromInt32(dstSampleIndex) + hkSimdFloat32_Half) * m_destToSourceScale;

    return hkInt32(hkMath::floor((dstSampleInSourceSpace - m_widthInSourceSpace).getReal()));
}

hkImageFilterWeightsRange::hkImageFilterWeightsRange( hkArrayView<float> m_weights )
    : m_weights(m_weights)
    , m_currentWeightIndex(0)
{

}

hkImageFilterWeightsRange::hkImageFilterWeightsRange( const hkImageFilterWeightsRange& other )
    : m_weights(other.m_weights)
    , m_currentWeightIndex(other.m_currentWeightIndex)
{

}

hkSimdFloat32 hkImageFilterWeightsRange::front() const
{
    return hkSimdFloat32::fromFloat(m_weights[m_currentWeightIndex]);
}

void hkImageFilterWeightsRange::popFront()
{
    m_currentWeightIndex++;
    if (m_currentWeightIndex >= (hkUint32)m_weights.getSize())
    {
        m_currentWeightIndex = 0;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
