// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// this: #include <Common/ImageUtilities/Image/hkImageFormat.h>
#include <Common/Base/Container/BitField/hkBitField.h>

struct hkImageFormat
{
    enum Channel
    {
        R = 0,
        G,
        B,
        A,
        D,
        S,

        CHANNEL_COUNT
    };

    enum DataType
    {
        DATA_TYPE_FLOAT,
        DATA_TYPE_UNSIGNED,
        DATA_TYPE_SIGNED,
        DATA_TYPE_UNSIGNED_NORMALIZED,
        DATA_TYPE_SIGNED_NORMALIZED,
        DATA_TYPE_DEPTH_STENCIL,
        DATA_TYPE_GENERIC,
        DATA_TYPE_NONE,

        DATA_TYPE_COUNT
    };

    enum Enum
    {
        INVALID = 0,

        // Generic formats, will trigger selection of a more specific format
        RGBA,
        RGB,
        RG,
        RED,
        DEPTH,
        DEPTH_STENCIL,

        // "Color" formats
        R32_G32_B32_A32_FLOAT = 10,
        R32_G32_B32_A32_UNSIGNED,
        R32_G32_B32_A32_SIGNED,

        R32_G32_B32_FLOAT = 20,
        R32_G32_B32_UNSIGNED,
        R32_G32_B32_SIGNED,

        R32_G32_FLOAT = 30,
        R32_G32_UNSIGNED,
        R32_G32_SIGNED,

        R32_FLOAT = 40,
        R32_UNSIGNED,
        R32_SIGNED,

        R16_G16_B16_A16_FLOAT = 50,
        R16_G16_B16_A16_UNSIGNED,
        R16_G16_B16_A16_SIGNED,
        R16_G16_B16_A16_UNSIGNED_NORMALIZED,
        R16_G16_B16_A16_SIGNED_NORMALIZED,

        R16_G16_FLOAT = 60,
        R16_G16_UNSIGNED,
        R16_G16_SIGNED,
        R16_G16_UNSIGNED_NORMALIZED,
        R16_G16_SIGNED_NORMALIZED,

        R16_FLOAT = 70,
        R16_UNSIGNED,
        R16_SIGNED,
        R16_UNSIGNED_NORMALIZED,
        R16_SIGNED_NORMALIZED,

        R8_G8_B8_A8_UNSIGNED = 80,
        R8_G8_B8_A8_SIGNED,
        R8_G8_B8_A8_UNSIGNED_NORMALIZED,
        R8_G8_B8_A8_SIGNED_NORMALIZED,
        R8_G8_B8_A8_UNSIGNED_NORMALIZED_SRGB,
        R8_G8_B8_UNSIGNED_NORMALIZED,
        R8_G8_B8_UNSIGNED_NORMALIZED_SRGB,

        B8_G8_R8_A8_UNSIGNED_NORMALIZED = 90,
        B8_G8_R8_A8_UNSIGNED_NORMALIZED_SRGB,
        B8_G8_R8_X8_UNSIGNED_NORMALIZED,
        B8_G8_R8_X8_UNSIGNED_NORMALIZED_SRGB,
        B8_G8_R8_UNSIGNED_NORMALIZED,
        B8_G8_R8_UNSIGNED_NORMALIZED_SRGB,

        R8_G8_UNSIGNED = 100,
        R8_G8_SIGNED,
        R8_G8_UNSIGNED_NORMALIZED,
        R8_G8_SIGNED_NORMALIZED,

        R8_UNSIGNED = 110,
        R8_SIGNED,
        R8_UNSIGNED_NORMALIZED,
        R8_SIGNED_NORMALIZED,

        BC1_UNSIGNED_NORMALIZED = 120,
        BC1_UNSIGNED_NORMALIZED_SRGB,

        BC2_UNSIGNED_NORMALIZED = 130,
        BC2_UNSIGNED_NORMALIZED_SRGB,

        BC3_UNSIGNED_NORMALIZED = 140,
        BC3_UNSIGNED_NORMALIZED_SRGB,

        BC4_UNSIGNED_NORMALIZED = 150,
        BC4_SIGNED_NORMALIZED,

        BC5_UNSIGNED_NORMALIZED = 160,
        BC5_SIGNED_NORMALIZED,

        BC6_F16_UNSIGNED = 170,
        BC6_F16_SIGNED,

        BC7_UNSIGNED_NORMALIZED = 180,
        BC7_UNSIGNED_NORMALIZED_SRGB,

        B5_G6_R5_UNSIGNED_NORMALIZED = 190,
        B5_G5_R5_A1_UNSIGNED_NORMALIZED,
        B4_G4_R4_A4_UNSIGNED_NORMALIZED,

        R11_G11_B10_UNSIGNED_FLOAT = 200,
        R10_G10_B10_A2_UNSIGNED,
        R10_G10_B10_A2_UNSIGNED_NORMALIZED,


        // Depth/Stencil formats
        D32F = 210,
        D32F_S8_X24,
        D24_S8,
        D16,

        // Mobile compressed formats
        ETC1_RGB_4BPP = 220,

        PVRTC_RGBA_2BPP = 230,
        PVRTC_RGBA_4BPP,
        PVRTC_RGB_2BPP,
        PVRTC_RGB_4BPP,

        NV12 = 240,

        COUNT
    };

    static HK_EXPORT_COMMON const char* getName(Enum format);

    static HK_EXPORT_COMMON hkUint32 getBitsPerPixel(Enum format);   ///< Pixel size in bits.
    static HK_EXPORT_COMMON hkUint32 getBitsPerBlock(Enum format);   ///< Block size in bits.

    static HK_EXPORT_COMMON hkUint32 getNumChannels(Enum format);    ///< Number of channels (r, g, b, a, depth, stencil) supported by this format.

    static HK_EXPORT_COMMON hkUint32 getBitsPerChannel(Enum format, Channel c);  ///< Number of bits for each channel of the format.
    static HK_EXPORT_COMMON hkUint32 getChannelMask(Enum format, Channel c); ///< Bitmask of each channel of the format. This is not defined for some formats, and may return 0.

    static HK_EXPORT_COMMON hkUint32 getBlockWidth(Enum format);     ///< Block width of a compressed format. Defaults to 1 for uncompressed formats.
    static HK_EXPORT_COMMON hkUint32 getBlockHeight(Enum format);    ///< Block height of a compressed format. Defaults to 1 for uncompressed formats.
    static HK_EXPORT_COMMON hkUint32 getBlockDepth(Enum format);     ///< Block depth of a compressed format. Defaults to 1 for uncompressed formats.

    static HK_EXPORT_COMMON hkImageFormat::DataType getDataType(Enum format);        ///< Data type of a format.

    static HK_EXPORT_COMMON bool isGeneric(Enum format);

    static HK_EXPORT_COMMON bool isSrgbFormat(Enum format);
    static HK_EXPORT_COMMON Enum getSrgbFormat(Enum format); ///< Returns the equivalent sRGB format if one exists; otherwise returns format.
    static HK_EXPORT_COMMON Enum getLinearFormat(Enum format);   ///< Returns the equivalent linear format if format is sRGB.

    static HK_EXPORT_COMMON bool isDepthFormat(Enum format);     ///< Returns true if the format has a depth channel.
    static HK_EXPORT_COMMON bool isStencilFormat(Enum format);   ///< Returns true if the format has a stencil channel.
    static HK_EXPORT_COMMON bool isSameTypeGroup(Enum f1, Enum f2);      ///< Returns true if the formats are the same TYPELESS group.

    static HK_EXPORT_COMMON bool isCompressed(Enum format);      ///< Returns true if the format is compressed.

    static HK_EXPORT_COMMON hkUint32 getRowPitch(Enum format, hkUint32 width);                       ///< Computes the size in bytes of a row of blocks (compressed) or pixels (if uncompressed) of the given width.
    static HK_EXPORT_COMMON hkUint32 getDepthPitch(Enum format, hkUint32 width, hkUint32 height);    ///< Computes the size in bytes of a 2D slice of blocks (compressed) or pixels (if uncompressed) of the given width and height.

    static HK_EXPORT_COMMON hkImageFormat::Enum fromPixelMaskAndCount(hkUint32 redMask, hkUint32 greenMask, hkUint32 blueMask, hkUint32 alphaMask, hkUint32 bitsPerPixel); ///< Identifies a format by its bitmasks.
    static HK_EXPORT_COMMON hkImageFormat::Enum fromDxgiFormat(hkUint32 dxgiFormat);

    static HK_EXPORT_COMMON hkUint32 toDxgiFormat(Enum format);
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkImageFormat::Enum);

#include <Common/ImageUtilities/Image/hkImageFormat.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
