// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY       : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/Enumerable/hkEnumerableClass.h>

class hkImage;
class hkImageHeader;

/// Base class for readers/writers of different image file formats
///
/// The static helper functions allow to determine which reader/writer may handle a certain file.
class HK_EXPORT_COMMON hkImageFileFormat : public hkEnumerable<hkImageFileFormat>
{
public:
  /// Returns a reader for the given extension.
  static _Ret_maybenull_ hkImageFileFormat* getReader(_In_z_ const char* extension);

  /// Returns a writer for the given extension.
  static _Ret_maybenull_ hkImageFileFormat* getWriter(_In_z_ const char* extension);

  /// Collects all supported extensions for reading
  static void getAllReadableExtensions( hkArray<const char*>& extensions );

  /// Collects all supported extensions for writing
  static void getAllWriteableExtensions( hkArray<const char*>& extensions );

  /// Reads only header data from \a stream to \a header.
  /// \note This does not read the entire image data from \a stream. For that, see readImage().
  virtual hkResult readImageHeader(const hkIo::Detail::ReadBufferAdapter& stream, hkImageHeader& out_header) const = 0;

  /// Reads the data from the given stream and creates the image from it.
  virtual hkResult readImage(const hkIo::Detail::ReadBufferAdapter& stream, hkImage& image) const = 0;

  /// Writes the data to the given stream in this format.
  virtual hkResult writeImage(const hkIo::Detail::WriteBufferAdapter& stream, const hkImage& image) const = 0;

  /// Returns a list of all file formats that can be read
  virtual hkArrayView<const char* const> getReadableExtensions() const = 0;

  /// Returns a list of all file formats that can be written
  virtual hkArrayView<const char* const> getWriteableExtensions() const = 0;

  /// Should return true, if files with the given extension can be read.
  bool canReadFileType(_In_z_ const char* extension ) const;

  /// Should return true, if files with the given extension can be written.
  bool canWriteFileType(_In_z_ const char* extension ) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
