// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY       : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/ImageUtilities/hkImageUtilities.h>

#include <Common/ImageUtilities/FileFormats/hkImageFileFormat.h>

HK_ENUMERABLE_CLASS_IMPLEMENTATION(hkImageFileFormat);

_Ret_maybenull_ hkImageFileFormat* hkImageFileFormat::getReader( _In_z_ const char* extension )
{
    for (hkImageFileFormat* format = hkImageFileFormat::getFirstInstance(); format; format = format->getNextInstance())
    {
        if (format->canReadFileType( extension ))
        {
            return format;
        }
    }

    return HK_NULL;
}

_Ret_maybenull_ hkImageFileFormat* hkImageFileFormat::getWriter(_In_z_ const char* extension )
{
    for (hkImageFileFormat* format = hkImageFileFormat::getFirstInstance(); format; format = format->getNextInstance())
    {
        if (format->canWriteFileType( extension ))
        {
            return format;
        }
    }

    return HK_NULL;
}

void hkImageFileFormat::getAllReadableExtensions( hkArray<const char*>& extensions )
{
    for (hkImageFileFormat* format = hkImageFileFormat::getFirstInstance(); format; format = format->getNextInstance())
    {
        for (auto extension : format->getReadableExtensions())
        {
            extensions.pushBack( extension );
        }
    }
}

void hkImageFileFormat::getAllWriteableExtensions( hkArray<const char*>& extensions )
{
    for (hkImageFileFormat* format = hkImageFileFormat::getFirstInstance(); format; format = format->getNextInstance())
    {
        for (auto extension : format->getWriteableExtensions())
        {
            extensions.pushBack( extension );
        }
    }
}

bool hkImageFileFormat::canReadFileType( _In_z_ const char* extension ) const
{
    hkArrayView<const char* const> supportedExtensions = getReadableExtensions();
    for (auto supportedExtension : supportedExtensions)
    {
        if (hkString::strCmp( supportedExtension, extension ) == 0)
        {
            return true;
        }
    }
    return false;
}

bool hkImageFileFormat::canWriteFileType( _In_z_ const char* extension ) const
{
    hkArrayView<const char* const> supportedExtensions = getWriteableExtensions();
    for (auto supportedExtension : supportedExtensions)
    {
        if (hkString::strCmp( supportedExtension, extension ) == 0)
        {
            return true;
        }
    }
    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
