// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/hkMeshSystem.h>
#include <Common/Base/Container/LocalArray/hkLocalBuffer.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>

//
//  Create a vertex buffer. The vertex format is retrieved from the given sourceVertexBuffer

_Ret_maybenull_ hkMeshVertexBuffer* hkMeshSystem::createVertexBuffer(_In_ const hkMeshVertexBuffer* templateVertexBuffer, int numVertices)
{
    hkMeshVertexBuffer* meshVb = const_cast<hkMeshVertexBuffer*>(templateVertexBuffer);
    hkVertexFormat fmt;
    meshVb->getVertexFormat(fmt);
    return createVertexBuffer(fmt, numVertices);
}

//
//  Creates a compound shape. The default implementation calls the hkMatrix4 based createCompoundShape().

_Ret_notnull_ hkMeshShape* hkMeshSystem::createCompoundShape(_In_reads_(numShapes) const hkMeshShape*const* shapes, _In_reads_(numShapes) const hkQTransform* transforms, int numShapes)
{
    hkLocalBuffer<hkMatrix4> temp(numShapes);
    for (int k = 0; k < numShapes; k++)
    {
        const hkQTransform& qtm = transforms[k];

        hkTransform tempTm;
        tempTm.setRotation(qtm.m_rotation);
        tempTm.setTranslation(qtm.m_translation);

        temp[k].set(tempTm);
    }

    return createCompoundShape(shapes, temp.begin(), numShapes);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
