// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkMeshMaterial;


/// A registry for materials.
///
/// Note that materials do not need to be registered in the hkMaterialRegistry to work. The registry's only purpose is
/// to map names to materials and keep them in scope. A name must be unique for a material.
///
/// There may be an argument for having hkMaterials held in the registry that are not reference counted. When they go
/// out of scope they are removed automatically from the registry - this is an implementation specific feature though.
///
/// \sa hkMeshMaterial
class HK_EXPORT_COMMON hkMeshMaterialRegistry : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);

            
            /// If a material with this name is found it is returned. If not load will try and create the material
            /// from the name - this may entail reading the material description from disk - but is implementation specific.
            /// Method return HK_NULL if couldn't find or load a material with the specified name.
        virtual _Ret_maybenull_ hkMeshMaterial* loadMaterial(_In_z_ const char* name) = 0;

            /// Find a material (that already exists). If not returns HK_NULL
        virtual _Ret_maybenull_ hkMeshMaterial* findMaterial(_In_z_ const char* name) const = 0;

            /// Register a material with a name. If there is already a material with the specified name it will be replaced.
        virtual void registerMaterial(_In_z_ const char* name, _In_ hkMeshMaterial* material) = 0;

            /// Remove the material
        virtual void unregisterMaterial(_In_z_ const char* name) = 0;

            /// Fills in an array with all of the materials
        inline void getMaterials(hkArray<hkMeshMaterial*>& materials)
        {
            getMaterials(materials, hkContainerHeapAllocator().get(&materials));;
        }

        virtual void getMaterials(hkArrayBase<hkMeshMaterial*>& materials, hkMemoryAllocator& a) = 0;

            /// Gets a materials name, or returns HK_NULL if it doesn't have a registered name
        virtual _Ret_maybenull_z_ const char* getMaterialName(_In_ const hkMeshMaterial* material) const = 0;

            /// Free all the materials
        virtual void freeMaterials() = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
