// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Arranges a set of textures in an atlas
class HK_EXPORT_COMMON hkTextureAtlasUtil
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA, hkTextureAtlasUtil);

    public:

        /// Texture
        struct HK_EXPORT_COMMON Texture
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA, hkTextureAtlasUtil::Texture);

            /// Sets the texture sizes
            HK_INLINE void set(int w, int h)
            {
                m_width = w;
                m_height = h;
            }

            int m_width;    ///< Texture width in pixels
            int m_height;   ///< Texture height in pixels
        };

        /// Texture placement
        struct HK_EXPORT_COMMON Placement
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA, hkTextureAtlasUtil::Placement);

            int m_textureId;    ///< Index of the texture in the input textures array
            int m_x, m_y;       ///< The (x, y) top left pixel in the atlas where the texture should be placed.
            hkUint8 m_rotation; ///< The texture rotation angle. Can only be 0 or 90 degrees CCW.
            hkUint16 m_atlasId; ///< The atlas where the texture was placed
        };

    public:

        /// Estimates the size of the atlas map that could fit the given textures
        static void HK_CALL estimateAtlasSize(_In_reads_(numTextures) const Texture* texturesIn, int numTextures, int& atlasWidthOut, int& atlasHeightOut);

        /// Arranges the given textures in an atlas
        static hkResult HK_CALL arrangeTextures(
            _In_reads_(numTextures) const Texture* texturesIn, int numTextures,
            _Inout_updates_(numTextures) Placement* placementsOut,
            int& atlasWidthOut, int& atlasHeightOut,
            int maxAtlasWidth = 2048, int maxAtlasHeight = 2048);

    public:

        /// Debug self-test.
        static hkResult HK_CALL selfTest();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
