// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/IndexedTransformSet/hkIndexedTransformSet.h>

class hkMeshSystem;
class hkMeshMaterialRegistry;
class hkAabb;

/// A simple utility for processing hkMeshShapes
namespace hkMeshShapeUtil
{
    struct HK_EXPORT_COMMON Statistics
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkMeshShapeUtil::Statistics );

        void clear()
        {
            m_totalNumVertices = 0;
            m_totalNumPrimitives = 0;
            m_numUniqueVertexBuffers = 0;
            m_numUniqueMaterials = 0;
        }

        int m_totalNumVertices;
        int m_totalNumPrimitives;
        int m_numUniqueVertexBuffers;
        int m_numUniqueMaterials;
    };

    struct HK_EXPORT_COMMON SectionInfo
    {
        int m_origSectionIdx;
        bool m_isTransparent;

        static hkBool32 HK_CALL less(const SectionInfo& pA, const SectionInfo& pB)
{
            return (!pA.m_isTransparent && pB.m_isTransparent) || ((pA.m_isTransparent == pB.m_isTransparent) && (pA.m_origSectionIdx < pB.m_origSectionIdx));
        }
    };

        /// Calculate statistics for a single shape
    HK_EXPORT_COMMON void HK_CALL calculateStatistics(_In_ const hkMeshShape* shape, Statistics& statsOut);

        /// Calculate statistics across multiple shapes
    HK_EXPORT_COMMON void HK_CALL calculateStatistics(_In_reads_(numShapes) const hkMeshShape** shape, int numShapes, Statistics& statsOut);

            /// Goes through all of the vertex buffers referenced in the shape, and finds their
            /// unique positions.
    HK_EXPORT_COMMON void HK_CALL findUniqueVertexPositions(_In_ hkMeshShape* shape, hkArray<hkVector4>& verticesOut);

        /// Converts a mesh shape constructed in one mesh system to another
    HK_EXPORT_COMMON _Ret_maybenull_ hkMeshShape* HK_CALL convert(_In_opt_ const  hkMeshMaterialRegistry* srcRegistry, _In_ const hkMeshShape* srcShape, _Inout_ hkMeshMaterialRegistry* dstRegistry, _Inout_ hkMeshSystem* dstSystem);

        /// Replace all of the vertex buffers in meshShape with those specified in the buffer map. If not found will just keep the original.
    HK_EXPORT_COMMON _Ret_maybenull_ hkMeshShape* HK_CALL replaceShapeVertexBuffers(_Inout_ hkMeshSystem* meshSystem, _In_ const hkMeshShape* meshShape, hkPointerMap<hkMeshVertexBuffer*, hkMeshVertexBuffer*>& bufferMap);

        /// Transforms the meshShape by the input transform (normalizes normals if normalize is set)
    HK_EXPORT_COMMON hkResult HK_CALL transform(_Inout_ hkMeshShape* meshShape, const hkMatrix4& transformIn, hkBool normalize);

        /// Calc the aabb surrounding a shape
    HK_EXPORT_COMMON void HK_CALL calcAabb(_In_ const hkMeshShape* shape, hkAabb& aabbOut);

        /// Reorder the mesh sections to make
    HK_EXPORT_COMMON _Ret_maybenull_ hkMeshShape* HK_CALL reorderMeshSections(_In_ const hkMeshShape* shape, _Inout_ hkMeshSystem* meshSystem, hkArray<SectionInfo>& newSectionOrder);

        /// Patches a mesh materials with a given material registery
    HK_EXPORT_COMMON void HK_CALL patchMeshMaterials(_Inout_ hkMeshShape* meshToPatch, _In_ const hkMeshMaterialRegistry* matRegistry);

        /// Clones the given mesh shape
    HK_EXPORT_COMMON _Ret_notnull_ hkMeshShape* HK_CALL cloneMesh(_Inout_ hkMeshSystem* meshSystem, _In_ const hkMeshShape* srcShape);

        /// Returns a new mesh shape with at most maxBones in each mesh section. If the mesh has less than the maximum number of bones per section,
        /// the function returns the unchanged original mesh. The function also returns the array of bone mappings, one for each mesh section.
    HK_EXPORT_COMMON _Ret_maybenull_ const hkMeshShape* HK_CALL createMeshWithLimitedNumBones(_Inout_ hkMeshSystem* meshSystem, _In_ const hkMeshShape* srcShape, int maxBonesPerSection, int numTotalMeshBones);

        /// Applies the given transform on the given uv set
    HK_EXPORT_COMMON void HK_CALL transformUvSet(_Inout_ hkMeshShape* meshShape, int uvSet, const hkMatrix4& uvTm);

        /// Converts the given bone indices from section to mesh
    HK_EXPORT_COMMON void HK_CALL mapSectionBoneIndices(const hkMeshSection& section, hkArray<int>& boneIndices);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
