// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkMeshShape;
class hkMeshSystem;

/// A utility to merge mesh sections.
///
/// Mesh sections can only be merged if they have the same vertex buffer format (or better vertex buffer)
/// and their primitives are compatible.
class HK_EXPORT_COMMON hkMeshSectionMergeUtil
{
    public:
            /// Produce a new mesh shape made up of a merge of the sections with the same material
        static _Ret_notnull_ hkMeshShape* HK_CALL mergeShapeSectionsByMaterial(_In_ hkMeshSystem* system, _In_ hkMeshShape* meshShape);

            /// Returns true if a mesh shape has more than one mesh section with the same material
        static bool HK_CALL hasUniqueMaterials(_In_ const hkMeshShape* meshShape);

            /// Merges the first shape into the second.
        static _Ret_notnull_ hkMeshShape* HK_CALL mergeShapes(_Inout_ hkMeshSystem* system, _In_ const hkMeshShape* one, _In_ const hkMeshShape* two);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
