// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Utils/MeshMaterialUtil/hkMeshMaterialUtil.h>
#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>

void hkMeshMaterialUtil::convert(_In_ const hkMeshMaterial* source, _Inout_ hkMeshMaterial* destination)
{
    destination->setName(source->getName());

    for(int i = 0; i < source->getNumTextures(); ++i)
    {
        hkMeshTexture* texture = source->getTexture(i);
        destination->addTexture(texture);
    }

    // If there are no textures, set material colors
    if( source->getNumTextures() == 0 )
    {
        hkVector4 diffuse;
        hkVector4 ambient;
        hkVector4 specular;
        hkVector4 emmisive;
        source->getColors(diffuse, ambient, specular, emmisive);
        destination->setColors(diffuse, ambient, specular, emmisive);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
