// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/Utils/SkinningUtil/hkSkinningUtil.h>

class HK_EXPORT_COMMON hkFindVertexWeightsUtil
{
    public:
        typedef hkSkinningUtil::Entry Entry;

            /// Insert an entry, returns the current amount of values.
        HK_INLINE static int HK_CALL insertEntry(_Inout_updates_(weightsPerVertex) hkSkinningUtil::Entry* entries, _In_range_(<=, weightsPerVertex) int numValues, int weightsPerVertex, hkReal distSq, int boneIndex);
            /// Get max value. Can be called after insert entry to get the current largest value held
        HK_INLINE static hkReal HK_CALL getMaxValue(_In_reads_(weightsPerVertex) Entry* entries, int weightsPerVertex) {  return entries[weightsPerVertex - 1].m_distanceSquared; }
            /// Set up the values
        static void HK_CALL reset(_Out_writes_(weightsPerVertex * numVertices) Entry* entries, int weightsPerVertex, int numVertices);
};


HK_INLINE /* static */int hkFindVertexWeightsUtil::insertEntry(_Inout_updates_(weightsPerVertex) hkSkinningUtil::Entry* entries, _In_range_(<=, weightsPerVertex) int numValues, int weightsPerVertex, hkReal distSq, int boneIndex)
{
    for (int i = 0; i < numValues; i++)
    {
        if (entries[i].m_distanceSquared > distSq)
        {
            if (numValues < weightsPerVertex)
            {
                numValues++;
            }

            // Copy down
            for (int j = numValues - 1; j > i; j--)
            {
                entries[j] = entries[j - 1];
            }

            entries[i].m_distanceSquared = distSq;
            entries[i].m_index = boneIndex;
            return numValues;
        }
    }

    if (numValues < weightsPerVertex)
    {
        // Just stick at the end
        entries[numValues].m_distanceSquared = distSq;
        entries[numValues].m_index = boneIndex;

        return numValues + 1;
    }

    return numValues;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
