// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// A simple utility to determine the unique set of used indices
///
/// The utility needs to know the index of the maximum vertex index that is going to be processed
/// doing so allows it to use very fast array lookups to determine if an index has already been added.
///
/// Before any indices can be added the 'initialize' method must be called with the number of vertex indices
/// (i.e., 1 more than the maximum index value). Now indices can be added by calling 'addIndex' - it will return
/// the index given to that index.
///
/// The m_uniqueIndices member will hold the original indices of the indices added. The position in uniqueIndices
/// determines what value was assigned to that index.
///
/// The member m_indexMap - holds -1 for any source index which wasn't added, or the index of the output index for the
/// the source index otherwise.
class HK_EXPORT_COMMON hkFindUniqueIndicesUtil
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkFindUniqueIndicesUtil );

            /// Initialize, must be called before anything is added
        void initialize(int maxIndex);

            /// Returns the output index
        int addIndex(int index);

            /// Add indices
        void addIndices(_In_reads_(numIndices) const hkUint16* indices, int numIndices);

            /// Get the index in the unique indices list, or -1 if not added
        int getIndex(int index) const { return m_indicesMap[index]; }

        hkArray<int> m_indicesMap;
        hkArray<int> m_uniqueIndices;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
