// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>

// this
#include <Common/GeometryUtilities/Mesh/Utils/FindUniqueIndicesUtil/hkFindUniqueIndicesUtil.h>

void hkFindUniqueIndicesUtil::initialize(int maxIndex)
{
    m_indicesMap.setSize(maxIndex);
    hkString::memSet4(m_indicesMap.begin(), -1, maxIndex);
    m_uniqueIndices.clear();
}

int hkFindUniqueIndicesUtil::addIndex(int index)
{
    int newIndex = m_indicesMap[index];
    if (newIndex >= 0)
    {
        return newIndex;
    }

    newIndex = m_uniqueIndices.getSize();
    m_indicesMap[index] = newIndex;
    m_uniqueIndices.pushBack(index);

    return newIndex;
}

void hkFindUniqueIndicesUtil::addIndices(_In_reads_(numIndices) const hkUint16* indices, int numIndices)
{
    for (int i = 0; i < numIndices; i++)
    {
        addIndex(indices[i]);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
