// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/Skin/hkSkinnedMeshShape.h>

    /// Mesh shape that references a sub-set of the bones in a hkSkinnedMeshShape
class HK_EXPORT_COMMON hkSkinnedRefMeshShape : public hkMeshShape
{
    //+version(1)

    public:

        HK_DECLARE_CLASS(hkSkinnedRefMeshShape, New, Reflect, BypassCtor);

            /// Constructor
        hkSkinnedRefMeshShape(_In_ hkSkinnedMeshShape* fullSkin, _In_reads_(numBones) const short* bones, _In_reads_bytes_(sizeof(hkVector4) * numBones * 2) const hkQTransformType* localFromRootTransforms, int numBones);

            /// Constructor
        hkSkinnedRefMeshShape(_In_ hkSkinnedMeshShape* fullSkin);

            /// Destructor
        virtual ~hkSkinnedRefMeshShape();

    public:

            /// Returns the skinned mesh shape
        HK_INLINE _Ret_notnull_ hkSkinnedMeshShape* getSkinnedMeshShape() const             { return m_skinnedMeshShape; }

            /// Sets the skinned mesh shape
        HK_INLINE void setSkinnedMeshShape(_In_ hkSkinnedMeshShape* newShape)       { m_skinnedMeshShape = newShape; }

            /// Returns the array of bones
        HK_INLINE const hkArray<short>& getBones() const                { return m_bones; }

            /// Returns the array of transforms (to get the number of transforms call getBones().getSize())
        HK_INLINE _Ret_notnull_ const hkQTransform* getTransforms() const           { return reinterpret_cast<const hkQTransform*>(m_localFromRootTransforms.begin()); }

            /// Creates a compound mesh by merging all the given Vision meshes
        static _Ret_maybenull_ hkSkinnedRefMeshShape* HK_CALL create(_In_reads_(numShapes) const hkMeshShape*const* shapes, _In_reads_(numShapes) const hkQTransformType* transforms, int numShapes);

    public:

            /// Returns the amount of sections
        virtual int getNumSections() const;

            /// Gets information about a section
        virtual void lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const;

            /// Unlocks a mesh section. Must be given exactly the same structure contents as was returned from a lockSection
            /// otherwise behavior is undefined.
        virtual void unlockSection(const hkMeshSection& section) const;

            /// Returns an optional name of the mesh shape
        virtual _Ret_maybenull_z_ const char* getName() const;

            /// Sets an optional name
        virtual void setName(_In_z_ const char* n);

    protected:

            /// The skinned mesh shape we're referencing
        hkRefPtr<hkSkinnedMeshShape> m_skinnedMeshShape;

            /// The sub-set of bones we're referencing
        hkArray<short> m_bones;

            /// The array of bone matrices that transform from root skin to current shape local space (array of hkQTransform)
        hkArray<hkVector4> m_localFromRootTransforms;

            /// The name
        hkStringPtr m_name;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
