// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>

/// A skinned mesh
class HK_EXPORT_COMMON hkSkinBinding : public hkMeshShape
{
    public:

        HK_DECLARE_CLASS(hkSkinBinding, New, Reflect, BypassCtor);

        /// Constructor
        hkSkinBinding(_In_opt_ hkMeshShape* skinnedMesh = HK_NULL, _In_reads_opt_(numBones) const hkMatrix4* HK_RESTRICT worldFromBoneTransforms = HK_NULL, _In_reads_opt_(numBones) const hkStringPtr* HK_RESTRICT boneNames = HK_NULL, int numBones = 0);

    public:

        /// Returns the amount of sections
        virtual int getNumSections() const HK_OVERRIDE;

        /// Gets information about a section
        virtual void lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const HK_OVERRIDE;

        /// Unlocks a mesh section. Must be given exactly the same structure contents as was returned from a lockSection
        /// otherwise behavior is undefined.
        virtual void unlockSection(const hkMeshSection& section) const HK_OVERRIDE;

        /// Returns an optional name of the mesh shape
        virtual _Ret_maybenull_z_ const char* getName() const HK_OVERRIDE;

        /// Sets an optional name
        virtual void setName(_In_z_ const char* n) HK_OVERRIDE;

        /// Returns the index of the bone with the given name
        int findBone(_In_z_ const char* name) const;

    public:

        /// Returns the skin
        HK_INLINE _Ret_notnull_ const hkMeshShape* getSkin() const  {   return m_skin;  }
        HK_INLINE _Ret_notnull_ hkMeshShape* accessSkin()               {   return m_skin;  }

        /// Returns the number of bones
        HK_INLINE int getNumBones() const                               {   return m_worldFromBoneTransforms.getSize(); }

        /// Returns the bind pose
        HK_INLINE _Ret_notnull_ const hkMatrix4* getWorldFromBoneTransform() const  {   return m_worldFromBoneTransforms.begin();   }

        /// Returns the bone names
        HK_INLINE _Ret_notnull_ const hkStringPtr* getBoneNames() const {   return m_boneNames.begin(); }
        HK_INLINE _Ret_notnull_ hkStringPtr* accessBoneNames()          {   return m_boneNames.begin(); }

    protected:

        hkRefPtr<hkMeshShape> m_skin;                       ///< The skin we are working on
        hkArray<hkMatrix4> m_worldFromBoneTransforms;       ///< The bind pose matrices
        hkArray<hkStringPtr> m_boneNames;                   ///< The array of bone names
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
