// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Skin/hkSkinBinding.h>

//
//  Constructor

hkSkinBinding::hkSkinBinding(_In_opt_ hkMeshShape* skinnedMesh, _In_reads_opt_(numBones) const hkMatrix4* HK_RESTRICT worldFromBoneTransforms, _In_reads_opt_(numBones) const hkStringPtr* HK_RESTRICT boneNames, int numBones)
:   hkMeshShape()
,   m_skin(skinnedMesh)
{
    m_worldFromBoneTransforms.append(worldFromBoneTransforms, numBones);
    m_boneNames.append(boneNames, numBones);
}

//
//  Returns the amount of sections

int hkSkinBinding::getNumSections() const
{
    return m_skin->getNumSections();
}

//
//  Gets information about a section

void hkSkinBinding::lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const
{
    m_skin->lockSection(sectionIndex, accessFlags, sectionOut);
}

//
//  Unlocks a mesh section. Must be given exactly the same structure contents as was returned from a lockSection
//  otherwise behavior is undefined.

void hkSkinBinding::unlockSection(const hkMeshSection& section) const
{
    m_skin->unlockSection(section);
}

//
//  Returns an optional name of the mesh shape

_Ret_maybenull_z_ const char* hkSkinBinding::getName() const
{
    return m_skin->getName();
}

//
//  Sets an optional name

void hkSkinBinding::setName(_In_z_ const char* n)
{
    m_skin->setName(n);
}

//
//  Returns the index of the bone with the given name

int hkSkinBinding::findBone(_In_z_ const char* name) const
{
    for (int k = m_boneNames.getSize() - 1 ; k >= 0; k--)
    {
        const char* boneName = m_boneNames[k].cString();

        if ( boneName && name && (hkString::strCmp(boneName, name) == 0) )
        {
            return k;
        }
    }

    return -1;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
