// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/Simplifiers/QemSimplifier/hkQemSimplifier.h>

class hkQemVertexContractionController: public hkQemSimplifier::ContractionController
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);

        typedef hkQemSimplifier::EdgeContraction EdgeContraction;

        // hkQemSimplifier::ContractionController implementation
        virtual hkBool32 allowContraction(const EdgeContraction& contraction);

            /// Enable a vertex
        void setVertexCanContract(int index, bool enable);

            /// Returns true if the vertex can contract
        bool canVertexContract(int index) const;

            /// Set vertex contract state from an aabb. The positions must have the same indices as in the mesh.
            /// Generally this means the positions are the contents of the hkFindUniquePositionsUtil used for previous processing
        void setVertexCanContractFromAabb(const hkArray<hkVector4>& positions, const hkAabb& aabb, bool enable);

    protected:
        hkArray<hkUint32> m_bitField;           ///< Has a bit set if the vertex cannot contract
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
