// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshTexture.h>

    /// A memory based implementation of an hkMeshTexture
class HK_EXPORT_COMMON hkMemoryMeshTexture : public hkMeshTexture
{
    public:
        HK_DECLARE_CLASS(hkMemoryMeshTexture, Reflect, New, Version(2));

        /// Texture sampler
        class HK_EXPORT_COMMON Sampler : public hkMeshTexture::Sampler
        {
        public:

            HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

            /// Samples the texture at the given texel
            virtual void sample(hkVector4Parameter uvIn, hkVector4& texelOut) const HK_OVERRIDE;

            /// Returns an image at the specified mip level
            virtual _Ret_maybenull_ hkImageRef* getImage(int mipLevel) const HK_OVERRIDE;

        public:

            /// Constructor
            Sampler(const hkStringPtr& imgFilename);

        protected:

            hkStringPtr m_imgFilename;
        };

    public:

            /// Default Ctor
        hkMemoryMeshTexture();

            // hkMeshTexture implementation
        virtual void getData(_Outref_ hkUint8*& data, _Out_ int& size, _Out_ Format& format) HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setData(_In_reads_(size) hkUint8* data, int size, Format format) HK_OVERRIDE;

            // Gets the raw data format
        virtual Format getFormat() const HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual _Ret_maybenull_z_ const char* getFilename() const HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setFilename( _In_z_ const char* filename ) HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual bool getHasMipMaps() const HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setHasMipMaps(bool hasMipMaps) HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual FilterMode getFilterMode() const HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setFilterMode(FilterMode filterMode) HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual TextureUsageType getUsageHint() const HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setUsageHint( TextureUsageType hint ) HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual hkInt32 getTextureCoordChannel() const HK_OVERRIDE;
            // hkMeshTexture implementation
        virtual void setTextureCoordChannel( hkInt32 channelIndex ) HK_OVERRIDE;

            // hkMeshTexture implementation
        virtual bool isReadOnly() const HK_OVERRIDE { return false; }

            // hkMeshTexture implementation
        virtual _Ret_notnull_ hkMeshTexture::Sampler* createSampler() const HK_OVERRIDE;

        /// Tests whether two textures are equal
        virtual bool equals(_In_opt_ const hkMeshTexture* other) const HK_OVERRIDE;

    protected:

            /// Filename of the texture
        hkStringPtr m_filename;
            /// Raw texture data
        hkArray<hkUint8> m_data;
            /// Format of texture data
        hkEnum<hkMeshTexture::Format, hkInt8> m_format;
            /// True if the texture has mipmaps, false otherwise
        hkBool m_hasMipMaps;
            /// Filtering mode to use with the texture
        hkEnum<hkMeshTexture::FilterMode, hkInt8> m_filterMode;
            /// Texture usage hint
        hkEnum<hkMeshTexture::TextureUsageType, hkInt8> m_usageHint;
            /// Channel in the vertex buffer
        hkInt32 m_textureCoordChannel;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
