// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Memory/hkMemoryMeshTexture.h>

hkMemoryMeshTexture::hkMemoryMeshTexture()
:m_format(hkMeshTexture::Unknown)
,m_hasMipMaps(false)
,m_filterMode(hkMeshTexture::ANISOTROPIC)
,m_usageHint(hkMeshTexture::UNKNOWN)
,m_textureCoordChannel(-1)
{

}

void hkMemoryMeshTexture::getData(_Outref_ hkUint8*& data, _Out_ int& size, _Out_ hkMemoryMeshTexture::Format& format)
{
    data = m_data.begin();
    size = m_data.getSize();
    format = m_format;
}

void hkMemoryMeshTexture::setData(_In_reads_(size) hkUint8* data, int size, hkMemoryMeshTexture::Format format)
{
    m_format = format;

    // Copy raw formats locally, to have a consistent behaviour
    if ( format == RAW )
    {
        m_data.setSize(0);
        m_data.append(data, size);
    }
    else
    {
        m_data.setDataUserFree(data, size, size);
    }
}

hkMeshTexture::Format hkMemoryMeshTexture::getFormat() const
{
    return m_format;
}

_Ret_maybenull_z_ const char* hkMemoryMeshTexture::getFilename() const
{
    return m_filename.cString();
}

void hkMemoryMeshTexture::setFilename( _In_z_ const char* filename )
{
    m_filename = filename;
}

bool hkMemoryMeshTexture::getHasMipMaps() const
{
    return m_hasMipMaps;
}

void hkMemoryMeshTexture::setHasMipMaps(bool hasMipMaps)
{
    m_hasMipMaps = hasMipMaps;
}

hkMemoryMeshTexture::FilterMode hkMemoryMeshTexture::getFilterMode() const
{
    return m_filterMode;
}

void hkMemoryMeshTexture::setFilterMode(hkMemoryMeshTexture::FilterMode filterMode)
{
    m_filterMode = filterMode;
}

hkMeshTexture::TextureUsageType hkMemoryMeshTexture::getUsageHint() const
{
    return m_usageHint;
}

void hkMemoryMeshTexture::setUsageHint( hkMeshTexture::TextureUsageType hint )
{
    m_usageHint = hint;
}

hkInt32 hkMemoryMeshTexture::getTextureCoordChannel() const
{
    return m_textureCoordChannel;
}

void hkMemoryMeshTexture::setTextureCoordChannel( hkInt32 channelIndex )
{
    m_textureCoordChannel = channelIndex;
}

//
//   Sampler constructor

hkMemoryMeshTexture::Sampler::Sampler(const hkStringPtr& imgFilename)
:   hkMeshTexture::Sampler()
,   m_imgFilename(imgFilename)
{}

//
//  Samples the texture at the given texel

void hkMemoryMeshTexture::Sampler::sample(hkVector4Parameter uvIn, hkVector4& texelOut) const
{
    
    HK_ASSERT_NO_MSG(0x36c5bc1c, false);
}

//
//  Returns an image at the specified mip level

_Ret_maybenull_ hkImageRef* hkMemoryMeshTexture::Sampler::getImage(int mipLevel) const
{
    HK_ASSERT_NO_MSG(0x36c5bc1d, mipLevel == 0);

    hkImageRef* image = new hkImageRef();
    if (image->loadFrom(m_imgFilename).isFailure())
    {
        image->removeReference();
        return HK_NULL;
    }

    return image;
}

//
//  hkMeshTexture implementation

_Ret_notnull_ hkMeshTexture::Sampler* hkMemoryMeshTexture::createSampler() const
{
    return new hkMemoryMeshTexture::Sampler(m_filename);
}

//
//  Tests whether two textures are equal

bool hkMemoryMeshTexture::equals(_In_opt_ const hkMeshTexture* other) const
{
    if ( !other || !hkReflect::exactMatchDynCast<hkMemoryMeshTexture>(other) )
    {
        return false;
    }

    const hkMemoryMeshTexture* mmo = reinterpret_cast<const hkMemoryMeshTexture*>(other);
    if ( (m_format != mmo->m_format)                    ||
         (m_hasMipMaps != mmo->m_hasMipMaps)            ||
         (m_filterMode != mmo->m_filterMode)            ||
         (m_usageHint != mmo->m_usageHint)              ||
         (m_data.getSize() != mmo->m_data.getSize())    ||
         (m_filename.compareTo(mmo->m_filename) != 0)   ||
         (m_textureCoordChannel != mmo->m_textureCoordChannel) )
    {
        return false;
    }

    // Finally, compare the data
    return hkString::memCmp(m_data.begin(), mmo->m_data.begin(), m_data.getSize()) == 0;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
