// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshSystem.h>


    /// A memory based implementation of an hkMeshSystem
class HK_EXPORT_COMMON hkMemoryMeshSystem : public hkMeshSystem
{
    public:
        HK_DECLARE_CLASS(hkMemoryMeshSystem, New, ReflectIdentity);
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

            /// Ctor
        hkMemoryMeshSystem();

            /// Dtor
        virtual ~hkMemoryMeshSystem();

            // hkMeshSystem implementation
        virtual _Ret_notnull_ hkMeshMaterialRegistry* getMaterialRegistry() const HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_maybenull_ hkMeshShape* createShape(_In_reads_(numSections) const hkMeshSectionCinfo* sections, int numSections) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_notnull_ hkMeshShape* createCompoundShape(_In_reads_(numShapes) const hkMeshShape*const* shapes, _In_reads_opt_(numShapes) const hkMatrix4* transforms, int numShapes) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_maybenull_ hkMeshShape* createCompoundShape(_In_reads_(numShapes) const hkMeshShape*const* shapes, _In_reads_opt_(numShapes) const hkQTransform* transforms, int numShapes) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_maybenull_ hkMeshBody* createBody(_In_opt_ const hkMeshShape* shape, const hkMatrix4& mat, _Inout_opt_ hkIndexedTransformSetCinfo* transformSet) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_maybenull_ hkMeshVertexBuffer* createVertexBuffer(const hkVertexFormat& vertexFormat, int numVertices) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_maybenull_ hkMeshVertexBuffer* createVertexBuffer(_In_ const hkMeshVertexBuffer* templateVertexBuffer, int numVertices) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual void findSuitableVertexFormat(const hkVertexFormat& format, hkVertexFormat& formatOut) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual void addBody(_Inout_ hkMeshBody* body) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual void removeBody(_Inout_ hkMeshBody* body) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_notnull_ hkMeshMaterial* createMaterial() HK_OVERRIDE;

            // Clones the given material.
        virtual _Ret_maybenull_ hkMeshMaterial* cloneMaterial(_In_ const hkMeshMaterial* source) HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual _Ret_notnull_ hkMeshTexture* createTexture() HK_OVERRIDE;

            // hkMeshSystem implementation
        virtual void update() HK_OVERRIDE {}

            // hkMeshSystem implementation
        virtual void freeResources() HK_OVERRIDE;

        //
        //  Internal section
        //

        bool isSkinnedFormat(const hkVertexFormat& vertexFormat);

        virtual _Ret_maybenull_ hkMeshVertexBuffer* createSkinnedVertexBuffer(const hkVertexFormat& vertexFormat, int numVertices);

        void setMaterialRegistry(_In_ hkMeshMaterialRegistry* materialRegistry);

    protected:

        hkPointerMap<hkMeshBody*, int> m_bodies;                ///< the bodies added
        hkRefPtr<hkMeshMaterialRegistry> m_materialRegistry;    ///< the material registry
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
