// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>


    /// A memory based implementation of a hkMeshShape
class HK_EXPORT_COMMON hkMemoryMeshShape : public hkMeshShape
{
    public:
        HK_DECLARE_CLASS(hkMemoryMeshShape, New, Reflect, BypassCtor,  Version(1));

    public:

        struct Section
        {
            HK_DECLARE_CLASS(Section, Reflect, New);

            /// Constructor
            HK_INLINE Section()
            :   m_vertexBuffer(HK_NULL)
            ,   m_material(HK_NULL)
            ,   m_numPrimitives(0)
            ,   m_indexBufferOffset(0)
            {}

            /// Vertex buffer that will be used
            hkRefPtr<hkMeshVertexBuffer> m_vertexBuffer;

            /// Material used on this mesh section
            hkRefPtr<hkMeshMaterial> m_material;

            hkMeshBoneIndexMapping m_boneMatrixMap;         ///< Map from vertex buffer bone indices to 'global' bone indices

            /// The primitive types
            hkEnum<hkMeshSection::PrimitiveType, hkUint8> m_primitiveType;
            /// Total number of primitives of type m_primitiveType
            int m_numPrimitives;
            /// The index type used (if NONE, then m_indices must be equal to NULL)
            hkEnum<hkMeshSection::MeshSectionIndexType,hkUint8> m_indexType;

            /// This offset is used if indices aren't specified (ignored if indices are set)
            int m_vertexStartIndex;
            /// Index into transform set used to position this section. -1 if per section transform isn't used.
            int m_transformIndex;

            /// Index buffer offset
            int m_indexBufferOffset;
        };

    public:

        /// Constructor
        hkMemoryMeshShape(_In_reads_opt_(numSections) const hkMeshSectionCinfo* sections, int numSections);

        /// Destructor
        virtual ~hkMemoryMeshShape();

    public:

            // hkMeshShape implementation
        virtual int getNumSections() const HK_OVERRIDE;

            // hkMeshShape implementation
        virtual void lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const HK_OVERRIDE;

            // hkMeshShape implementation
        virtual void unlockSection(const hkMeshSection& section) const HK_OVERRIDE;

        virtual _Ret_z_ const char* getName() const HK_OVERRIDE { return m_name; }
        virtual void setName(_In_z_ const char* n) HK_OVERRIDE { m_name = n; }

    protected:

        mutable hkArray<Section> m_sections;

        hkArray<hkUint16> m_indices16;
        hkArray<hkUint32> m_indices32;

        hkStringPtr m_name;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
