// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Memory/hkMemoryMeshShape.h>

#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>
#include <Common/GeometryUtilities/Mesh/Utils/PrimitiveUtil/hkMeshPrimitiveUtil.h>

hkMemoryMeshShape::hkMemoryMeshShape(_In_reads_opt_(numSections) const hkMeshSectionCinfo* sections, int numSections)
{
    m_name = HK_NULL;

    int numIndices16 = 0;
    int numIndices32 = 0;

    for (int i = 0; i < numSections; i++)
    {
        const hkMeshSectionCinfo& section = sections[i];
        int numIndices = hkMeshPrimitiveUtil::calculateNumIndices(section.m_primitiveType, section.m_numPrimitives);
        switch (section.m_indexType)
        {
            case hkMeshSection::INDEX_TYPE_NONE: break;
            case hkMeshSection::INDEX_TYPE_UINT16: numIndices16 += numIndices; break;
            case hkMeshSection::INDEX_TYPE_UINT32: numIndices32 += numIndices; break;
            default: HK_ASSERT_NO_MSG(0x1312312, !"Unknown type");
        }
    }

    m_indices16.reserve(numIndices16);
    m_indices32.reserve(numIndices32);

    m_sections.setSize(numSections);

    for (int i = 0; i < numSections; i++)
    {
        const hkMeshSectionCinfo& srcSection = sections[i];
        Section& dstSection = m_sections[i];

        dstSection.m_vertexBuffer       = srcSection.m_vertexBuffer;
        dstSection.m_material           = srcSection.m_material;
        dstSection.m_boneMatrixMap      = srcSection.m_boneMatrixMap;
        dstSection.m_primitiveType      = srcSection.m_primitiveType;
        dstSection.m_numPrimitives      = srcSection.m_numPrimitives;
        dstSection.m_indexType          = srcSection.m_indexType;
        dstSection.m_vertexStartIndex   = srcSection.m_vertexStartIndex;
        dstSection.m_transformIndex     = srcSection.m_transformIndex;

        switch (srcSection.m_indexType)
        {
            case hkMeshSection::INDEX_TYPE_NONE:
                break;

            case hkMeshSection::INDEX_TYPE_UINT16:
            {
                const int numIndices = hkMeshPrimitiveUtil::calculateNumIndices(srcSection.m_primitiveType, srcSection.m_numPrimitives);
                dstSection.m_indexBufferOffset = m_indices16.getSize();
                hkUint16* dstIndices = m_indices16.expandBy(numIndices);
                hkString::memCpy(dstIndices, srcSection.m_indices, numIndices * sizeof(hkUint16));
            }
                break;

            case hkMeshSection::INDEX_TYPE_UINT32:
            {
                const int numIndices = hkMeshPrimitiveUtil::calculateNumIndices(srcSection.m_primitiveType, srcSection.m_numPrimitives);
                dstSection.m_indexBufferOffset = m_indices32.getSize();
                hkUint32* dstIndices = m_indices32.expandBy(numIndices);
                hkString::memCpy(dstIndices, srcSection.m_indices, numIndices * sizeof(hkUint32));
            }
                break;
            }
        }
    }


hkMemoryMeshShape::~hkMemoryMeshShape()
{}

int hkMemoryMeshShape::getNumSections() const
{
    return m_sections.getSize();
}

void hkMemoryMeshShape::lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const
{
    const Section& section = m_sections[sectionIndex];

    sectionOut.m_primitiveType = section.m_primitiveType;
    sectionOut.m_numPrimitives = section.m_numPrimitives;
    sectionOut.m_numIndices = hkMeshPrimitiveUtil::calculateNumIndices(section.m_primitiveType, section.m_numPrimitives);
    sectionOut.m_vertexStartIndex = section.m_vertexStartIndex;
    sectionOut.m_indexType = section.m_indexType;
    sectionOut.m_transformIndex = section.m_transformIndex;
    sectionOut.m_boneMatrixMap      = &section.m_boneMatrixMap;
    sectionOut.m_material           = section.m_material;

    // Vertex buffer
    sectionOut.m_vertexBuffer = (accessFlags & ACCESS_VERTEX_BUFFER) ? section.m_vertexBuffer : hkRefPtr<hkMeshVertexBuffer>();

    // Indices
    sectionOut.m_indices = HK_NULL;
    if (accessFlags & ACCESS_INDICES)
{
        if ( section.m_indexType != hkMeshSection::INDEX_TYPE_NONE )
    {
            sectionOut.m_indices = (section.m_indexType == hkMeshSection::INDEX_TYPE_UINT16)    ?
                                        (const void*)&m_indices16[section.m_indexBufferOffset]  :
                                        (const void*)&m_indices32[section.m_indexBufferOffset];
        }
        }

    // Save the section
    sectionOut.m_sectionIndex = sectionIndex;
}

void hkMemoryMeshShape::unlockSection(const hkMeshSection& section) const
{
    Section& srcSection = m_sections[section.m_sectionIndex];

    // Add reference on new material
    srcSection.m_material = section.m_material;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
