// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshTexture.h>

class hkMemoryMeshTexture;


/// A memory based implementation of an hkMeshMaterial
class HK_EXPORT_COMMON hkMemoryMeshMaterial : public hkMeshMaterial
{
    public:
        HK_DECLARE_CLASS(hkMemoryMeshMaterial, Reflect, New, Version(2));
            /// Ctor
        hkMemoryMeshMaterial(_In_opt_z_ const char* name = HK_NULL);

        /// Destructor
        virtual ~hkMemoryMeshMaterial();

            // Assignment operator
        hkMemoryMeshMaterial& operator=(const hkMemoryMeshMaterial& other);

            // hkMeshMaterial implementation
        virtual hkResult createCompatibleVertexFormat(const hkVertexFormat& format, hkVertexFormat& compatibleFormat) HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual _Ret_notnull_ hkMeshVertexBuffer* createCompatibleVertexBuffer(_Inout_ hkMeshVertexBuffer* buffer) HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual bool isCompatible(_In_ const hkMeshVertexBuffer* buffer) HK_OVERRIDE;

            /// Tests whether two materials are equal
        virtual bool equals(_In_ const hkMeshMaterial* other) HK_OVERRIDE;

            // hkMeshMaterial implementation
        virtual void setName(_In_z_ const char* name) HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual _Ret_maybenull_z_ const char* getName() const HK_OVERRIDE;

            // hkMeshMaterial implementation
        virtual int getNumTextures() const HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual _Ret_notnull_ hkMeshTexture* getTexture(int index) const HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual void addTexture(_In_ hkMeshTexture* texture) HK_OVERRIDE;

            // Sets a texture of the given slot
        virtual void setTexture(int index, _In_ hkMeshTexture* texture) HK_OVERRIDE;

            // hkMeshMaterial implementation
        virtual void getColors( hkVector4& diffuse, hkVector4& ambient, hkVector4& specular, hkVector4& emissive ) const HK_OVERRIDE;
            // hkMeshMaterial implementation
        virtual void setColors( const hkVector4& diffuse, const hkVector4& ambient, const hkVector4& specular, const hkVector4& emissive ) HK_OVERRIDE;

        /// Gets user data
        virtual hkUlong getUserData() const HK_OVERRIDE         {   return m_userData;      }

        /// Sets user data
        virtual void setUserData(hkUlong userData) HK_OVERRIDE  {   m_userData = userData;  }

        /// Gets / sets the tesselation factor. Triangles will not be tesselated if the factor is 0.0f, and fully tesselated if the factor is 1.0f
        virtual hkReal getTesselationFactor() const HK_OVERRIDE     {   return m_tesselationFactor; }
        virtual void setTesselationFactor(hkReal f) HK_OVERRIDE     {   m_tesselationFactor = f;    }

        /// Gets / sets the displacement amount. This represents the actual distance a vertex gets displaced for a displacement factor of 1.0f
        virtual hkReal getDisplacementAmount() const HK_OVERRIDE    {   return m_displacementAmount;    }
        virtual void setDisplacementAmount(hkReal f) HK_OVERRIDE    {   m_displacementAmount = f;       }

    protected:

        /// Reserves a texture slot for the given texture
        int reserveTextureSlot(_In_ const hkMeshTexture* newTex);

    public:

        hkStringPtr m_materialName;
        hkArray< hkRefPtr<hkMeshTexture> > m_textures;
        hkVector4 m_diffuseColor;
        hkVector4 m_ambientColor;
        hkVector4 m_specularColor;
        hkVector4 m_emissiveColor;
        hkUlong m_userData;
        hkReal m_tesselationFactor;
        hkReal m_displacementAmount;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
