// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>
#include <Common/GeometryUtilities/Mesh/IndexedTransformSet/hkIndexedTransformSet.h>
#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>


class hkMeshSystem;

/// An memory only version of a hkMeshBody
///
/// The memory implementation is useful for just processing hkMesh data.
///
/// \sa hkMeshBody
class HK_EXPORT_COMMON hkMemoryMeshBody : public hkMeshBody
{
    public:
        HK_DECLARE_CLASS(hkMemoryMeshBody, New, Reflect, BypassCtor);

            /// Ctor
        hkMemoryMeshBody(_In_opt_ const hkMeshSystem* meshSystem, _In_opt_ const hkMeshShape* shape, const hkMatrix4& transform, _Inout_opt_ hkIndexedTransformSetCinfo* transformSet);

            /// Dtor
        virtual ~hkMemoryMeshBody();

            // hkMeshBody implementation
        virtual _Ret_maybenull_ const hkMeshShape* getMeshShape() const HK_OVERRIDE { return m_shape; }

            // hkMeshBody implementation
        virtual void getTransform( hkMatrix4& transform ) const HK_OVERRIDE { transform = m_transform; }

            // hkMeshBody implementation
        virtual void setTransform(const hkMatrix4& matrix) HK_OVERRIDE { m_transform = matrix; }

            // hkMeshBody implementation
        virtual hkResult setPickingData(int id, _In_opt_ void* data) HK_OVERRIDE { return HK_FAILURE; }

            // hkMeshBody implementation
        virtual _Ret_maybenull_ hkMeshVertexBuffer* getVertexBuffer(int sectionIndex) HK_OVERRIDE { return m_vertexBuffers[sectionIndex]; }

            // hkMeshBody implementation
        virtual int getNumIndexedTransforms() HK_OVERRIDE { return m_transformSet ? m_transformSet->getNumMatrices() : 0; }
            // hkMeshBody implementation
        virtual void setIndexedTransforms(int startIndex, _In_reads_(numMatrices) const hkMatrix4* matrices, int numMatrices) HK_OVERRIDE  { HK_ASSERT_NO_MSG(0x34234, m_transformSet); m_transformSet->setMatrices(startIndex, matrices, numMatrices); }
            // hkMeshBody implementation
        virtual void getIndexedTransforms(int startIndex, _Inout_updates_(numMatrices) hkMatrix4* matrices, int numMatrices) HK_OVERRIDE { HK_ASSERT_NO_MSG(0x423432, m_transformSet); m_transformSet->getMatrices(startIndex, matrices, numMatrices); }
            // hkMeshBody implementation
        virtual void getIndexedInverseTransforms(int startIndex, _Inout_updates_(numMatrices) hkMatrix4* matrices, int numMatrices) HK_OVERRIDE { HK_ASSERT_NO_MSG(0x34243207, m_transformSet); m_transformSet->getInverseMatrices(startIndex, matrices, numMatrices); }

            // hkMeshBody implementation
        virtual _Ret_maybenull_ const hkInt16* getIndexTransformsOrder() const HK_OVERRIDE { HK_ASSERT_NO_MSG(0x34243207, m_transformSet); return m_transformSet->m_matricesOrder.begin(); }
            // hkMeshBody implementation
        virtual _Ret_maybenull_ const hkStringPtr* getIndexTransformNames() const HK_OVERRIDE { HK_ASSERT_NO_MSG(0x34243207, m_transformSet); return m_transformSet->m_matricesNames.begin(); }
            // hkMeshBody implementation
        virtual _Ret_maybenull_ const hkMeshBoneIndexMapping* getIndexMappings() const HK_OVERRIDE { HK_ASSERT_NO_MSG(0x34243207, m_transformSet); return m_transformSet->getIndexMappings().begin(); }
            // hkMeshBody implementation
        virtual hkInt32 getNumIndexMappings() const HK_OVERRIDE { return m_transformSet == HK_NULL ? 0 : m_transformSet->getIndexMappings().getSize(); }

            // hkMeshBody implementation
        virtual void completeUpdate() override {}
        virtual void completeUpdate(const hkMatrix4& transform) override {}

        virtual _Ret_z_ const char* getName() const HK_OVERRIDE { return m_name.cString(); }
        virtual void setName(_In_z_ const char* n) HK_OVERRIDE { m_name = n; }

    protected:

        hkMatrix4 m_transform;                              ///< The transform
        hkRefPtr<hkIndexedTransformSet> m_transformSet;     ///< The transform set (can be HK_NULL)
        hkRefPtr<const hkMeshShape> m_shape;                ///< The originating shape
        hkArray<hkMeshVertexBuffer*> m_vertexBuffers;       ///< Vertex buffer for each mesh section (hold the per body/instance data)
        hkStringPtr m_name;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
