// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Memory/hkMemoryMeshBody.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>

hkMemoryMeshBody::hkMemoryMeshBody(_In_opt_ const hkMeshSystem*, _In_opt_ const hkMeshShape* shape, const hkMatrix4& transform, _Inout_opt_ hkIndexedTransformSetCinfo* transformSet)
{
    m_name = "";

    if (transformSet)
    {
        m_transformSet = new hkIndexedTransformSet(*transformSet);
        m_transformSet->removeReference();
    }

    if (shape != HK_NULL)
    {
        const int numSections = shape->getNumSections();
        hkLocalArray<hkMeshVertexBuffer*> buffers(numSections);
        hkLocalArray<hkMeshVertexBuffer*> uniqueBuffers(numSections);
        hkLocalArray<hkMeshVertexBuffer*> dynamicBuffers(numSections);

        {
            hkMeshSection section;
            for (int i = 0; i < numSections; i++)
            {
                shape->lockSection(i, hkMeshShape::ACCESS_VERTEX_BUFFER, section);
                section.m_vertexBuffer->addReference();
                buffers.pushBack(section.m_vertexBuffer);
                shape->unlockSection(section);
            }
        }

        {
            for (int i = 0; i < numSections; i++)
            {
                hkMeshVertexBuffer* buffer = buffers[i];
                if (uniqueBuffers.indexOf(buffer) < 0)
                {
                    uniqueBuffers.pushBack(buffer);
                }
            }
        }

        const int numBuffers = uniqueBuffers.getSize();
        dynamicBuffers.setSize(numBuffers);

        {
            hkVertexFormat dstFormat;
            for (int i = 0; i < numBuffers; i++)
            {
                hkMeshVertexBuffer* srcBuffer = uniqueBuffers[i];
                dynamicBuffers[i] = srcBuffer->clone();
            }
        }

        // Set up each of the buffers
        m_vertexBuffers.setSize(numSections);
        for (int i = 0; i < numSections; i++)
        {
            int index = uniqueBuffers.indexOf(buffers[i]);
            HK_ASSERT_NO_MSG(0x7bba546c, index >= 0);

            hkMeshVertexBuffer* vertexBuffer = dynamicBuffers[index];
            vertexBuffer->addReference();

            m_vertexBuffers[i] = vertexBuffer;
        }

        hkReferencedObject::removeReferences(buffers.begin(), buffers.getSize());
        hkReferencedObject::removeReferences(dynamicBuffers.begin(), dynamicBuffers.getSize());
    }

    m_transform = transform;
    m_shape = shape;
}


hkMemoryMeshBody::~hkMemoryMeshBody()
{
    for (int i = 0; i < m_vertexBuffers.getSize(); i++)
    {
        hkMeshVertexBuffer* buffer = m_vertexBuffers[i];
        buffer->removeReference();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
