// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Deform/hkSkinOperator.h>
#include <Common/GeometryUtilities/Mesh/Deform/hkSkinOperatorGeneric.inl>

void hkSkinOperator::executeCpu(const Parameters& parameters)
{
    const hkUint32 skinningFlags    = parameters.m_input.m_skinExecutionFlags & parameters.m_output.m_skinExecutionFlags;
    const hkUint32 simdFlags        = parameters.m_input.m_simdExecutionFlags & parameters.m_output.m_simdExecutionFlags;

    if ( skinningFlags & HK_SKIN_POSITIONS )
    {
        if ( skinningFlags & HK_SKIN_NORMALS)
        {
            if ( (skinningFlags & HK_SKIN_ALL) == HK_SKIN_ALL )
            {
                // Do all
                if ( simdFlags == HK_USE_SIMD_FOR_ALL )
                {
                    // Skin all with SIMD
                    _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_SIMD_IN, SKIN_SIMD_OUT> (parameters);
                    return;
                }

                if ( (simdFlags & HK_USE_SIMD_FOR_POSITIONS_AND_NORMALS) == HK_USE_SIMD_FOR_POSITIONS_AND_NORMALS )
                {
                    // Special case for our d3d9s display buffers (input is all SIMD, output is SIMD+FLOAT)
                    if ( (parameters.m_input.m_simdExecutionFlags & HK_USE_SIMD_FOR_POSITIONS_AND_NORMALS) == HK_USE_SIMD_FOR_POSITIONS_AND_NORMALS )
                    {
                        // Skin all. Use SIMD for position & normal, and only for input tangent and bitangent
                        _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                            SKIN_SIMD_IN, SKIN_SIMD_OUT,
                            SKIN_SIMD_IN, SKIN_FLOAT32_OUT,
                            SKIN_SIMD_IN, SKIN_FLOAT32_OUT> (parameters);
                        return;
                    }

                    {
                        // Skin all. Use SIMD only for position & normal
                        _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                            SKIN_SIMD_IN, SKIN_SIMD_OUT,
                            SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                            SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT>  (parameters);
                        return;
                    }
                }

                {
                    // Skin all. No SIMD
                    _skinGeneric <SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT>  (parameters);
                    return;
                }
            }

            // Do only positions and normals
            {
                if ( simdFlags == HK_USE_SIMD_FOR_POSITIONS_AND_NORMALS )
                {
                    _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_IGNORE, SKIN_IGNORE,
                        SKIN_IGNORE, SKIN_IGNORE>  (parameters);
                    return;
                }

                if ( simdFlags == HK_USE_SIMD_FOR_POSITIONS )
                {
                    _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                        SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_IGNORE, SKIN_IGNORE,
                        SKIN_IGNORE, SKIN_IGNORE>  (parameters);
                    return;
                }

                {
                    _skinGeneric <SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                        SKIN_IGNORE, SKIN_IGNORE,
                        SKIN_IGNORE, SKIN_IGNORE>  (parameters);
                    return;
                }
            }
        }

        // Do only positions
        {
            if ( simdFlags & HK_USE_SIMD_FOR_POSITIONS )
            {
                _skinGeneric <SKIN_SIMD_IN, SKIN_SIMD_OUT,
                    SKIN_IGNORE, SKIN_IGNORE,
                    SKIN_IGNORE, SKIN_IGNORE,
                    SKIN_IGNORE, SKIN_IGNORE>  (parameters);
                return;
            }

            {
                _skinGeneric <SKIN_FLOAT32_IN, SKIN_FLOAT32_OUT,
                    SKIN_IGNORE, SKIN_IGNORE,
                    SKIN_IGNORE, SKIN_IGNORE,
                    SKIN_IGNORE, SKIN_IGNORE>  (parameters);
                return;
            }
        }
    }

    HK_WARN_ONCE (0x6ec4a445, "Invalid skin configuration - no positions?");
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
