// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>

/// Mesh deformation
///
/// The derived reference counted class for a SIMD based implementation of weighted vertex deformation.
/// Applies to both indexed and non indexed skinning.
/// This deformer requires that the input buffers' deformable
/// members (position, normals) be aligned as a hkVector4 (16byte aligned as it is 128bit)
/// and for faster operation make sure that the outputs are aligned as well.
/// N.B. It is important to note that these deformers are here to be used by Havok's demos but are not production quality.
/// It is assumed that deforming will be done most commonly by your graphics engine, usually in hardware on GPUs or VUs.
/// That hardware deformation is usually performed at the same time as per vertex lighting operations, so Havok cannot
/// provide optimized deformers for all such game specific usage.
class HK_EXPORT_COMMON hkSimdSkinningDeformer : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);

        struct HK_EXPORT_COMMON Binding
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkSimdSkinningDeformer::Binding );

            hkMeshVertexBuffer::LockedVertices m_input;
            hkMeshVertexBuffer::LockedVertices m_output;

            const hkUint8* m_weights;
            int m_weightsStride;

            const hkUint8*  m_transformIndices8;
            const hkUint16* m_transformIndices16;
            int m_transformIndicesStride;

            int m_numWeights;

            hkUint32 m_numVerts;
            hkBool m_normalizeDirections;           
        };

            /// Only Input is 16 byte aligned, requires internal loop copy to unaligned float output buffers so slower
        static void HK_CALL deform(_In_reads_(_Inexpressible_()) const hkMatrix4* worldCompositeMatrices, const Binding& binding );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
