// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshMaterialRegistry.h>


/// Simple implementation of a hkMeshMaterialRegistry
///
/// The loadMaterial method just calls 'findMaterial'. For a registry that will load up an hkMeshSystem specific material
/// deriving from this class and implementing 'loadMaterial' is much simpler than having to implement the whole
/// of the hkMeshMaterialRegistry
///
/// \sa hkMeshMaterialRegistry
class HK_EXPORT_COMMON hkDefaultMeshMaterialRegistry : public hkMeshMaterialRegistry
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);


            // hkMeshMaterialRegistry implementation
        virtual _Ret_maybenull_ hkMeshMaterial* loadMaterial(_In_z_ const char* name) HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual _Ret_maybenull_ hkMeshMaterial* findMaterial(_In_z_ const char* name) const HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual void registerMaterial(_In_z_ const char* name, _In_ hkMeshMaterial* material) HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual void unregisterMaterial(_In_z_ const char* name) HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual void getMaterials(hkArrayBase<hkMeshMaterial*>& materials, hkMemoryAllocator& a) HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual _Ret_maybenull_z_ const char* getMaterialName(_In_ const hkMeshMaterial* material) const HK_OVERRIDE;

            // hkMeshMaterialRegistry implementation
        virtual void freeMaterials() HK_OVERRIDE;

            /// A material entry
        struct HK_EXPORT_COMMON Entry
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkDefaultMeshMaterialRegistry::Entry );

            hkStringPtr m_name;                     ///< the registered name of the material
            hkRefPtr<hkMeshMaterial> m_material;    ///< the material
        };

    protected:

        int _findEntryIndex(_In_z_ const char* name) const;


        //
        //  Members
        //

    protected:

        hkArray<Entry> m_entries; ///< The registered materials
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
