// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/GeometryUtilities/hkGeometryUtilities.h>
#include <Common/GeometryUtilities/Mesh/Default/hkDefaultMeshMaterialRegistry.h>

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>

_Ret_maybenull_ hkMeshMaterial* hkDefaultMeshMaterialRegistry::loadMaterial(_In_z_ const char* name)
{
    return findMaterial(name);
}

int hkDefaultMeshMaterialRegistry::_findEntryIndex(_In_z_ const char* name) const
{
    const int numEntries = m_entries.getSize();
    for (int i = 0; i < numEntries; i++)
    {
        const Entry& entry = m_entries[i];
        if (hkString::strCmp(entry.m_name.cString(), name) == 0)
        {
            return i;
        }
    }

    return -1;
}


_Ret_maybenull_ hkMeshMaterial* hkDefaultMeshMaterialRegistry::findMaterial(_In_z_ const char* name) const
{
    int index = _findEntryIndex(name);
    return (index >= 0) ? (hkMeshMaterial*)m_entries[index].m_material : HK_NULL;
}

void hkDefaultMeshMaterialRegistry::registerMaterial(_In_z_ const char* name, _In_ hkMeshMaterial* material)
{
    int index = _findEntryIndex(name);
    if (index >= 0)
    {
        m_entries[index].m_material = material;
        return;
    }

    Entry& entry = m_entries.expandOne();
    entry.m_name = name;
    entry.m_material = material;
}

void hkDefaultMeshMaterialRegistry::unregisterMaterial(_In_z_ const char* name)
{
    int index = _findEntryIndex(name);
    if (index >= 0)
    {
        m_entries.removeAt(index);
    }
}

void hkDefaultMeshMaterialRegistry::freeMaterials()
{
    m_entries.clearAndDeallocate();
}

void hkDefaultMeshMaterialRegistry::getMaterials(hkArrayBase<hkMeshMaterial*>& materials, hkMemoryAllocator& a)
{
    materials._setSize(a, m_entries.getSize());
    const int numEntries = m_entries.getSize();
    for (int i = 0; i < numEntries; i++)
    {
        const Entry& entry = m_entries[i];
        materials[i] = entry.m_material;
    }
}

_Ret_maybenull_z_ const char* hkDefaultMeshMaterialRegistry::getMaterialName(_In_ const hkMeshMaterial* material) const
{
    const int numEntries = m_entries.getSize();
    for (int i = 0; i < numEntries; i++)
    {
        const Entry& entry = m_entries[i];

        if (entry.m_material == material)
        {
            return entry.m_name.cString();
        }
    }
    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
