// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexDescription.h>
#include <Common/Base/Math/Matrix/hkMatrixDecomposition.h>

class hkxScene;
class hkxNode;
class hkxMeshSection;
class hkxVertexBuffer;
class hkxMaterial;
class hkxMesh;
class hkMeshSystem;
class hkMeshBody;
class hkMeshMaterial;
class hkMeshSectionBuilder;

/// A converter from the Havok HKX scene data formats into more generic hkMeshShape interfaces
class HK_EXPORT_COMMON hkSceneDataToMeshConverter
{
    public:
            /// defines which transform to apply
        enum Space
        {
            SPACE_ONLY_USING_SCALE_SKEW,        ///< only extract skew and scale from the node matrix and apply it
            SPACE_TO_WORLD_SPACE,               ///< use the full matrix of node matrix
            SPACE_LOCAL,                        ///< do not apply any matrix multiplies
        };

            /// Converts a hkxNode into a hkxMeshShape.
            /// The node has to be an hkxMeshNode, and the scene has to be the scene the node came from. The hkMeshShape will be constructed
            /// using the mesh system object passed in.
            /// The overrideMaterial parameter, if passed as HK_NULL the materials will be looked up on the material repository on the
            /// mesh system. If it is non-null the whole shape will use in the passed in material - overriding the materials specified in
            /// the hkxMeshNode
        static _Ret_maybenull_ hkMeshShape* HK_CALL convert(_Inout_ hkMeshSystem* meshSystem, _Inout_opt_ hkMeshMaterial* overrideMaterial, _In_ const class hkxScene* scene, _In_ const hkxNode* node, Space space, bool allowMipmaps = true);

            /// Converts a hkxMesh into a hkMeshShape - see previous convert method for details.
        static _Ret_maybenull_ hkMeshShape* HK_CALL convert(_Inout_ hkMeshSystem* meshSystem, _Inout_opt_ hkMeshMaterial* overrideMaterial, const hkMatrix4& worldTransform, _Inout_ hkxMesh* mesh, bool allowMipmaps = true);

            /// Creates a vertex buffer from a hkxVertexBuffer. The decomposition parameter is used for baking in transform information -
            /// for example if the modeler had skew or scaling in its transform matrices.
        static _Ret_maybenull_ hkMeshVertexBuffer* HK_CALL convertVertexBuffer(_Inout_ hkMeshSystem* meshSystem, hkMatrixDecomposition::Decomposition& decomposition, _Inout_ hkxVertexBuffer* srcVertex);

            /// Convert usage value to hkVertexFormat usage type
        static hkVertexFormat::ComponentUsage HK_CALL convertUsage(hkxVertexDescription::DataUsage usage);

            /// Convert a element desc to hkVertexFormat::Element
        static void HK_CALL convertToElement(_In_ const hkxVertexDescription::ElementDecl* decl, hkVertexFormat::Element& ele);

            /// Convert the indices specified in the section, and add them to the current mesh section in the
            /// mesh section builder. \a vertexBufferOffset is added to all indices.
        static hkResult HK_CALL convertIndices(const hkxMeshSection& section, hkMeshSectionBuilder& builder, _Inout_opt_ hkMeshVertexBuffer* vertexBuffer, _Inout_opt_ hkMeshMaterial* dstMaterial);

            /// Convert an hkxMaterial into a hkMeshMaterial
        static _Ret_maybenull_ hkMeshMaterial* convert(_Inout_ hkMeshSystem* meshSystem, _Inout_ hkxMaterial* material, bool allowMipmaps = true);

            /// Retrieves the vertex positions from a hkMeshShape
        static void HK_CALL collectVertexPositions(_In_ const hkMeshShape* mesh, hkArray<hkVector4>& verticesInOut);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
