// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>
#include <Common/GeometryUtilities/Mesh/hkMeshVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexDescription.h>

class hkxScene;
class hkxNode;
class hkxMeshSection;
class hkxVertexBuffer;
class hkxIndexBuffer;
class hkxMesh;
class hkMeshBody;
class hkMeshSystem;
class hkMeshMaterial;
class hkxMaterial;

/// A converter from the Havok hkMeshShape interface to HKX scene data format
class HK_EXPORT_COMMON hkMeshToSceneDataConverter
{
    public:
            /// Converts a hkMeshBody into a hkxNode
        static _Ret_maybenull_ hkxNode* HK_CALL convertBody(_Inout_ hkxScene* scene, _In_opt_ const hkMeshBody* body);

            /// Converts a hkMeshShape into a hkxMesh
        static _Ret_maybenull_ hkxMesh* HK_CALL convertShape(_Inout_ hkxScene* scene, _In_ const hkMeshShape* shape);

            /// Converts a hkMeshMaterial into a hkxMaterial
        static _Ret_maybenull_ hkxMaterial* HK_CALL convertMaterial(_Inout_ hkxScene* scene, _In_opt_ const hkMeshMaterial* material);

            /// Converts a hkVertexBuffer into a hkxVertexBuffer
        static _Ret_maybenull_ hkxVertexBuffer* HK_CALL convertVertexBuffer(_Inout_ hkMeshVertexBuffer* buf );

            /// Converts the prim data in a hkMeshSection into a hkxIndexBuffer
        static _Ret_maybenull_ hkxIndexBuffer* HK_CALL convertIndexBuffer(_In_opt_ const hkMeshSection* section );

            /// Convert usage value to hkVertexFormat usage type
        static hkxVertexDescription::DataUsage HK_CALL convertUsage(hkVertexFormat::ComponentUsage usage);

            /// Convert a hkVertexFormat Element desc to hkxVertexDescription::Decl.
            /// Will set usage and type. When you use int to create a hkxVertexBuffer the offsets and strides will be set internally
        static void HK_CALL convertToDecl(const hkVertexFormat::Element& elem,  hkxVertexDescription::ElementDecl& decl );

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
