// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Vector/hkPackedVector3.h>


#include <Common/Base/Reflect/Attributes/hkToolAttributes.h>

struct hkMassProperties;

#if defined(HK_COMPILER_MSVC) || defined(HK_COMPILER_INTEL)
#   pragma warning( 3 : 4820 )  // check padding
#endif


/// A mass properties using a diagonalized inertia.
struct HK_EXPORT_COMMON hkDiagonalizedMassProperties
{
    HK_DECLARE_CLASS( hkDiagonalizedMassProperties, New, Reflect, Validate );

    void initAsSphere( hkReal radius, hkReal mass ); ///< sets this to a sphere with radius, mass

    void pack( const hkMassProperties& mp );

    void unpack(_Inout_ hkMassProperties* massPropertiesOut ) const;

    void reset();

    /// The volume.
    hkReal m_volume;

    /// The mass.
    hkReal m_mass;

    hkReal m_padding[2] HK_ATTR( hk::Serialize( false ) );

    /// The center of mass.
    hkVector4 m_centerOfMass;

    /// The inertia tensor.
    hkVector4 m_inertiaTensor;

    /// The rotation rotating from inertia major axis space to world space
    hkQuaternion m_majorAxisSpace;
};

/// Packed inertia, 15 bit accuracy, 32 bytes (hkMassProperties is 96 bytes)
HK_CLASSALIGN(struct,8) HK_EXPORT_COMMON hkCompressedMassProperties
{
    HK_DECLARE_CLASS( hkCompressedMassProperties, New, Reflect, Version(1) );

    /// pack
    void pack( const hkMassProperties& massPropertiesIn );
    void pack( const hkDiagonalizedMassProperties& massPropertiesIn );

    /// unpack
    void unpack( hkMassProperties& massPropertiesOut ) const;
    void unpack(_Inout_ hkDiagonalizedMassProperties* massPropertiesOut ) const;

    HK_ALIGN(hkPackedVector3,8)         m_centerOfMass;
    HK_ALIGN(hkPackedVector3,8)         m_inertia;
    HK_ALIGN(hkPackedUnitVector<4>,8)   m_majorAxisSpace;//+overridetype(hkInt16[4])
    hkReal m_mass;
    hkReal m_volume;
};

#if defined(HK_PLATFORM_WIN32)
#   pragma warning( disable : 4820 )
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
