// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_DETAIL_DIAG_CLANG_PUSH()
HK_DETAIL_DIAG_CLANG_OFF(missing-braces)

#if defined(PATCHES_SIMPLE_CHANGES)

HK_PATCH_BEGIN("SVSimpleStart", 0, "SVSimpleEnd", 0)
    HK_PATCH_MEMBER_ADDED("differentVector", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("originalFloatDivedByTen", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("originalIntPlusTen", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("addedOriginalValue", TYPE_INT, HK_NULL, 0)
    HK_PATCH_FUNCTION(SVSimpleStart_0_to_SVSimpleEnd_0)
    HK_PATCH_MEMBER_REMOVED("i_am_an_int", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("i_am_a_float", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("i_am_a_bool", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

#endif

#if defined(PATCHES_RENAME_READDED)

HK_PATCH_BEGIN("SVSimpleStart", 0, "SVRenameAddedEnd", 1)
HK_PATCH_MEMBER_RENAMED("pos", "posRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_an_int", "i_am_an_intRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_a_float", "i_am_a_floatRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_a_string", "i_am_a_stringRenamedOnce")
HK_PATCH_MEMBER_ADDED("pos", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_an_int", TYPE_INT, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_a_float", TYPE_REAL, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_a_string", TYPE_CSTRING, HK_NULL, 0)

HK_PATCH_MEMBER_ADDED_VEC_4("added_vec4", 1, 2, 3, 4)
HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY("added_vec4_identity")
// intentionally not testing HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY here
// because hkQsTransform is not reflected as an array anymore
HK_PATCH_MEMBER_ADDED_VEC_16("added_vec16", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY("added_vec16_identity")

HK_PATCH_FUNCTION(SVSimpleStart_0_to_SVRenameAddedEnd_1)
HK_PATCH_END()

HK_PATCH_BEGIN("SVRenameAddedEnd", 1, "SVRenameAddedEnd", 2)
HK_PATCH_MEMBER_RENAMED("posRenamedOnce", "posRenamedTwice")
HK_PATCH_MEMBER_RENAMED("i_am_an_intRenamedOnce", "i_am_an_intRenamedTwice")
HK_PATCH_MEMBER_RENAMED("i_am_a_floatRenamedOnce", "i_am_a_floatRenamedTwice")
HK_PATCH_MEMBER_RENAMED("i_am_a_stringRenamedOnce", "i_am_a_stringRenamedTwice")
HK_PATCH_MEMBER_RENAMED("pos", "posRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_an_int", "i_am_an_intRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_a_float", "i_am_a_floatRenamedOnce")
HK_PATCH_MEMBER_RENAMED("i_am_a_string", "i_am_a_stringRenamedOnce")
HK_PATCH_MEMBER_ADDED("pos", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_an_int", TYPE_INT, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_a_float", TYPE_REAL, HK_NULL, 0)
HK_PATCH_MEMBER_ADDED("i_am_a_string", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_FUNCTION(SVRenameAddedEnd_1_to_SVRenameAddedEnd_2)
HK_PATCH_END()

HK_PATCH_BEGIN("SVRenameAddedEnd", 2, "SVRenameAddedEnd", 3)
HK_PATCH_FUNCTION(SVRenameAddedEnd_2_to_SVRenameAddedEnd_3)
HK_PATCH_END()

#endif

#if defined(PATCHES_HIERARCHY)

HK_PATCH_BEGIN("SVHierarchyObjectStart", 0, "SVHierarchyObjectEnd", 1)
HK_PATCH_MEMBER_ADDED("values", TYPE_ARRAY_REAL, HK_NULL, 0)
HK_PATCH_FUNCTION(SVHierarchyObjectStart_0_to_SVHierarchyObjectEnd_1)
HK_PATCH_MEMBER_REMOVED("count", TYPE_INT, HK_NULL, 0)
HK_PATCH_MEMBER_REMOVED("value", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVHierarchyObjectEnd", 1, "SVHierarchyObjectEnd", 2)
HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_DEPENDS("hkReferencedObject", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("SVHierarchyOwnerStart", 0, "SVHierarchyOwnerEnd", 1)
HK_PATCH_MEMBER_ADDED("objs", TYPE_ARRAY_OBJECT, "SVHierarchyObjectEnd", 0)
HK_PATCH_FUNCTION(SVHierarchyOwnerStart_0_to_SVHierarchyOwnerEnd_1)
HK_PATCH_MEMBER_REMOVED("objA", TYPE_STRUCT, "SVHierarchyObjectEnd", 0)
HK_PATCH_MEMBER_REMOVED("objB", TYPE_STRUCT, "SVHierarchyObjectEnd", 0)
HK_PATCH_MEMBER_REMOVED("objC", TYPE_STRUCT, "SVHierarchyObjectEnd", 0)
HK_PATCH_DEPENDS("SVHierarchyObjectEnd", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("SVHierarchyOwnerEnd", 1, "SVHierarchyOwnerEnd", 2)
HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
HK_PATCH_DEPENDS("hkReferencedObject", 3)
HK_PATCH_END()

#endif

#if defined(PATCHES_REMOVED_OBJECTS)

HK_PATCH_BEGIN("SVRemovedObjectsOwnerStart", 0, "SVRemovedObjectsOwnerEnd", 1)
    HK_PATCH_MEMBER_REMOVED("containedObjectOne", TYPE_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_MEMBER_REMOVED("containedObjectTwo", TYPE_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_MEMBER_RENAMED("containedObjectThree", "containedObjectOne")
    HK_PATCH_MEMBER_REMOVED("containedObjectFour", TYPE_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("SVRemovedObjectsOwnerEnd", 1, "SVRemovedObjectsOwnerEnd", 2)
    HK_PATCH_MEMBER_RENAMED("containedObjectOne", "containedObject")
    HK_PATCH_MEMBER_REMOVED("containedObjectsArray", TYPE_ARRAY_OBJECT, "SVHierarchyObjectEnd", 0)
    HK_PATCH_DEPENDS("SVHierarchyObjectEnd", 2)
HK_PATCH_END()

#endif

#if defined(PATCHES_DELETED_TYPE)

HK_PATCH_BEGIN("SVDeletedTypeContainerStart", 0, "SVDeletedTypeContainerEnd", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVDeletedTypeOwnerStart", 0, "SVDeletedTypeOwnerEnd", 0)
HK_PATCH_FUNCTION(SVDeletedTypeOwnerStart_0_to_SVDeletedTypeOwnerEnd_0)
HK_PATCH_MEMBER_REMOVED("a", TYPE_STRUCT, "SVDeletedType", 0)
HK_PATCH_MEMBER_REMOVED("b", TYPE_STRUCT, "SVDeletedType", 0)
HK_PATCH_DEPENDS("SVDeletedType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVDeletedType", 0, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_MEMBER_REMOVED("value", TYPE_INT, HK_NULL, 0)
//HK_PATCH_DEPENDS("SVDeletedTypeOwnerEnd", 0)
HK_PATCH_END()

#endif

#if defined(PATCHES_HOMOGENEOUS_ARRAY)

HK_PATCH_BEGIN("SVHomogeneousArrayContainerStart", 0, "SVHomogeneousArrayContainerEnd", 1)
HK_PATCH_MEMBER_ADDED_REAL("mem0", 100.0f)
HK_PATCH_MEMBER_REMOVED("array", TYPE_ARRAY_STRUCT, HK_NULL, 0)
HK_PATCH_END()

#endif

#if defined(PATCHES_OLD_NATIVE)

// Class is added and removed again
HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "SVAddRemoveClass", 0)
    HK_PATCH_MEMBER_ADDED_REAL("mem0", 100.0f)
    HK_PATCH_MEMBER_ADDED_REAL("mem1", -2000.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("SVAddRemoveClass", 0, "SVAddRemoveClass", 1)
    HK_PATCH_MEMBER_ADDED_REAL("mem2", 3000.0f)
    HK_PATCH_MEMBER_REMOVED("mem1", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVAddRemoveClass", 1, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_MEMBER_REMOVED("mem0", TYPE_REAL, HK_NULL, 0)
HK_PATCH_MEMBER_REMOVED("mem2", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "SVSecondEmbedType", 0)
HK_PATCH_MEMBER_ADDED_INT("emb_c", 0xeecceecc)
HK_PATCH_MEMBER_ADDED_INT("emb_d", 0xeeddeedd)
HK_PATCH_END()

HK_PATCH_BEGIN("SVSecondEmbedType", 0, "SVSecondEmbedTypeFinal", 1)
    HK_PATCH_DEPENDS("SVEmbedType", 0)
    HK_PATCH_MEMBER_REMOVED("emb_d", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "SVSecondVersioningTest", 0)
HK_PATCH_MEMBER_ADDED_INT("a", 0xaaaaaaaa)
HK_PATCH_MEMBER_ADDED("embed2", TYPE_STRUCT, "SVSecondEmbedType", 0)
HK_PATCH_DEPENDS("SVSecondEmbedType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVSecondVersioningTest", 0, "SVSecondVersioningTest", 1)
HK_PATCH_MEMBER_ADDED_INT("b", 0xbbbbbbbb)
HK_PATCH_MEMBER_ADDED_INT("c", 0xcccccccc)
HK_PATCH_END()

HK_PATCH_BEGIN("SVSecondVersioningTest", 1, "SVSecondVersioningTest", 2)
    HK_PATCH_DEPENDS("SVAddRemoveClass", 1)
    HK_PATCH_DEPENDS("SVEmbedType", 0)
    HK_PATCH_MEMBER_REMOVED("b", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ar", TYPE_STRUCT, "SVAddRemoveClass", 0)
    HK_PATCH_MEMBER_ADDED_REAL("add_rem_add", 25.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("SVSecondVersioningTest", 2, "SVSecondVersioningTest", 3)
    HK_PATCH_DEPENDS("SVEmbedType", 1)
    HK_PATCH_MEMBER_ADDED_INT("d", 0x0ddddddd)
    HK_PATCH_MEMBER_ADDED_INT("e", 0x0eeeeeee)
    HK_PATCH_MEMBER_ADDED("embed", TYPE_TUPLE_STRUCT, "SVEmbedType", 2)
    HK_PATCH_MEMBER_REMOVED("add_rem_add", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("array", TYPE_TUPLE_INT, HK_NULL, 4) /* int m_array[4] */
    HK_PATCH_MEMBER_ADDED("embedTypehkArray", TYPE_ARRAY_STRUCT, "SVEmbedType", 0) /* hkArray<SVEmbedType> */
HK_PATCH_END()

HK_PATCH_BEGIN("SVSecondVersioningTest", 3, "SVSecondVersioningTestFinal", 4)
    HK_PATCH_MEMBER_ADDED_INT("add_rem_add", 0x0addaadd)
    HK_PATCH_MEMBER_ADDED("ptr", TYPE_OBJECT, "SVEmbedType", 0)
    HK_PATCH_FUNCTION(SVSecondVersioningTest_3_to_4)
    HK_PATCH_MEMBER_REMOVED("ar", TYPE_STRUCT, "SVAddRemoveClass", 0)
    HK_PATCH_MEMBER_REMOVED("c", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("d", TYPE_INT, HK_NULL, 0)
    HK_PATCH_PARENT_SET(HK_NULL, "SVPatchParentFinal")
    HK_PATCH_DEPENDS("SVPatchParentFinal", 0)
    HK_PATCH_DEPENDS("SVEmbedType", 1)
    HK_PATCH_DEPENDS("SVAddRemoveClass", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "SVEmbedType", 0)
    HK_PATCH_MEMBER_ADDED_INT("int", 27)
HK_PATCH_END()

HK_PATCH_BEGIN("SVEmbedType", 0, "SVEmbedType", 1)
    HK_PATCH_MEMBER_ADDED_REAL("real", -100.0f)
HK_PATCH_END()

HK_PATCH_BEGIN("SVEmbedType", 1, "SVEmbedTypeFinal", 2)
    HK_PATCH_MEMBER_REMOVED("emb_a", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()
#endif

#if defined(PATCHES_TYPE_COMBINE)

//
// A0 -> A1 -> A2 -> C3
// B0 -> B1 ---/
//

HK_PATCH_BEGIN("SVTypeCombineStartA", 0, "SVTypeCombineStartA", 1)
    HK_PATCH_MEMBER_ADDED("anotherInt", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVTypeCombineStartA", 1, "SVTypeCombineStartA", 2)
    HK_PATCH_MEMBER_REMOVED("anotherInt", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("anInt", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("same", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_FUNCTION(SVTypeCombineStartA_1_to_2)
HK_PATCH_END()

HK_PATCH_BEGIN("SVTypeCombineStartA", 2, "SVTypeCombineEndC", 3)
    HK_PATCH_MEMBER_ADDED("stuff", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVTypeCombineStartB", 0, "SVTypeCombineStartB", 1)
    HK_PATCH_MEMBER_ADDED("same", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_FUNCTION(SVTypeCombineStartB_0_to_1)
HK_PATCH_END()

HK_PATCH_BEGIN("SVTypeCombineStartB", 1, "SVTypeCombineStartA", 2)
    HK_PATCH_MEMBER_REMOVED("someInt", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

#endif

#if defined(PATCHES_TEXT_ARRAY_ARRAY)
HK_PATCH_BEGIN("SVTextDescStart", 0, "SVTextDescEnd", 1)
    HK_PATCH_MEMBER_ADDED("allTheInts", TYPE_FROMNAME, "hkArray<int>", 0)
    HK_PATCH_FUNCTION(SVTextDesc_Start0_to_End1)
    HK_PATCH_MEMBER_REMOVED("lotsOfArrays", TYPE_FROMNAME, "hkArray< hkArray< hkArray< hkArray<int> > > >", 0)
HK_PATCH_END()
#endif

#if defined(PATCHES_TRACK_COMBINE)

HK_PATCH_BEGIN("SVCombineTrackA_Alt", 0, "SVCombineTrackA_int", 0)
    HK_PATCH_MEMBER_ADDED("intVal", TYPE_INT, HK_NULL, 0)
    HK_PATCH_FUNCTION(SVCombineTrackA_Alt_float_to_int)
    HK_PATCH_MEMBER_REMOVED("floatVal", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVCombineTrackA", 0, "SVCombineTrackA_int", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVCombineTrackA_int", 0, "SVCombineTrackB", 1)
    HK_PATCH_MEMBER_ADDED("copiedIntVal", TYPE_INT, HK_NULL, 0)
    HK_PATCH_FUNCTION(SVCombineTrackA_Alt_copy_int_val)
HK_PATCH_END()

#endif

#if defined(PATCHES_DOUBLE_PRECISION)

HK_PATCH_BEGIN("SVDoubleStart", 0, "SVDoubleEnd", 0)
    HK_PATCH_FUNCTION(SVDoubleStart_0_to_End_0)
    HK_PATCH_MEMBER_RENAMED("spVec", "dpVec2")
HK_PATCH_END()

#endif

#if defined(PATCHES_BACKLINK_TRACK)

HK_PATCH_BEGIN("SVBacklinkStart", 0, "SVBacklinkEnd", 0)
    HK_PATCH_FUNCTION(SVBacklinkStart_0_to_End_0)
    HK_PATCH_DEPENDS("SVBacklinkLinkedEnd", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVBacklinkLinkedStart", 0, "SVBacklinkLinkedEnd", 0)
    HK_PATCH_FUNCTION(SVBacklinkLinkedStart_0_to_End_0)
HK_PATCH_END()

HK_PATCH_BEGIN("SVBacklinkContainerArrayStart", 0, "SVBacklinkContainerArrayEnd", 0)
    HK_PATCH_DEPENDS("SVBacklinkLinkedEnd", 0)
    HK_PATCH_FUNCTION(SVBacklinkContainerArrayStart_0_to_End_0)
HK_PATCH_END()

#endif

#if defined(PATCHES_IMPORTS)

HK_PATCH_BEGIN("SVImportsStart", 0, "SVImportsEnd", 0)
HK_PATCH_MEMBER_RENAMED("normal", "normalEnd")
HK_PATCH_MEMBER_RENAMED("imported1", "imported1End")
HK_PATCH_MEMBER_ADDED("imported2End", TYPE_ARRAY_OBJECT, "hkReferencedObject", 1)
HK_PATCH_FUNCTION(SVImportsStart_0_to_SVImportsEnd_0)
HK_PATCH_MEMBER_REMOVED("imported2", TYPE_OBJECT, "hkReferencedObject", 1)
HK_PATCH_MEMBER_REMOVED("mixed", TYPE_ARRAY_OBJECT, "hkReferencedObject", 1)
HK_PATCH_DEPENDS("hkReferencedObject", 3)
HK_PATCH_END()

#endif

//////////////////////////////////////////////////////////////////////////////////
// New Patches
//////////////////////////////////////////////////////////////////////////////////

#if defined(PATCHES_SIMPLE_CHANGES_NEW)

BEGIN("SVSimpleStart", 0, "SVSimpleEnd", 0)
ADD("differentVector", "hkVector4")
ADD("originalFloatDivedByTen", "hkReal")
ADD("originalIntPlusTen", "int")
ADD("addedOriginalValue", "int")
FUNCTION(SVSimpleStart_0_to_SVSimpleEnd_0_var)
REMOVE("i_am_an_int", "int")
REMOVE("i_am_a_float", "hkReal")
REMOVE("i_am_a_bool", "bool")
END()

#endif

#if defined(PATCHES_RENAME_READDED_NEW)

BEGIN("SVSimpleStart", 0, "SVRenameAddedEnd", 1)
RENAME("pos", "posRenamedOnce")
RENAME("i_am_an_int", "i_am_an_intRenamedOnce")
RENAME("i_am_a_float", "i_am_a_floatRenamedOnce")
RENAME("i_am_a_string", "i_am_a_stringRenamedOnce")
ADD("pos", "hkVector4")
ADD("i_am_an_int", "int")
ADD("i_am_a_float", "float")
ADD("i_am_a_string", "hkStringPtr")

ADD("added_vec4", "hkVector4")
SET_VALUE("added_vec4", hkVector4, 1, 2, 3, 4)
ADD("added_vec4_identity", "hkVector4")

ADD("added_vec16", "hkTransform")
SET_VALUE("added_vec16", hkTransform, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
ADD("added_vec16_identity", "hkTransform")

FUNCTION(SVSimpleStart_0_to_SVRenameAddedEnd_1_var)
END()

BEGIN("SVRenameAddedEnd", 1, "SVRenameAddedEnd", 2)
RENAME("posRenamedOnce", "posRenamedTwice")
RENAME("i_am_an_intRenamedOnce", "i_am_an_intRenamedTwice")
RENAME("i_am_a_floatRenamedOnce", "i_am_a_floatRenamedTwice")
RENAME("i_am_a_stringRenamedOnce", "i_am_a_stringRenamedTwice")
RENAME("pos", "posRenamedOnce")
RENAME("i_am_an_int", "i_am_an_intRenamedOnce")
RENAME("i_am_a_float", "i_am_a_floatRenamedOnce")
RENAME("i_am_a_string", "i_am_a_stringRenamedOnce")
ADD("pos", "hkVector4")
ADD("i_am_an_int", "int")
ADD("i_am_a_float", "float")
ADD("i_am_a_string", "hkStringPtr")
FUNCTION(SVRenameAddedEnd_1_to_SVRenameAddedEnd_2_var)
END()

BEGIN("SVRenameAddedEnd", 2, "SVRenameAddedEnd", 3)
FUNCTION(SVRenameAddedEnd_2_to_SVRenameAddedEnd_3_var)
END()

#endif

#if defined(PATCHES_HIERARCHY_NEW)

BEGIN("SVHierarchyObjectStart", 0, "SVHierarchyObjectEnd", 1)
ADD("values", "hkArray< hkReal >")
FUNCTION(SVHierarchyObjectStart_0_to_SVHierarchyObjectEnd_1_var)
REMOVE("count", "int")
REMOVE("value", "hkReal")
END()

BEGIN("SVHierarchyObjectEnd", 1, "SVHierarchyObjectEnd", 2)
SET_PARENT(HK_NULL, "hkReferencedObject")
DEPENDS("hkReferencedObject", 3)
END()

BEGIN("SVHierarchyOwnerStart", 0, "SVHierarchyOwnerEnd", 1)
ADD("objs", "hkArray< SVHierarchyObjectEnd* >")
FUNCTION(SVHierarchyOwnerStart_0_to_SVHierarchyOwnerEnd_1_var)
REMOVE("objA", "SVHierarchyObjectEnd")
REMOVE("objB", "SVHierarchyObjectEnd")
REMOVE("objC", "SVHierarchyObjectEnd")
DEPENDS("SVHierarchyObjectEnd", 2)
END()

BEGIN("SVHierarchyOwnerEnd", 1, "SVHierarchyOwnerEnd", 2)
SET_PARENT(HK_NULL, "hkReferencedObject")
DEPENDS("hkReferencedObject", 3)
END()

#endif

#if defined(PATCHES_REMOVED_OBJECTS_NEW)

BEGIN("SVRemovedObjectsOwnerStart", 0, "SVRemovedObjectsOwnerEnd", 1)
REMOVE("containedObjectOne", "hkReferencedObject*")
REMOVE("containedObjectTwo", "hkReferencedObject*")
RENAME("containedObjectThree", "containedObjectOne")
REMOVE("containedObjectFour", "hkReferencedObject*")
DEPENDS("hkReferencedObject", 3) // <-- needs to be 1 or it will think it needs patch 0->1
END()

BEGIN("SVRemovedObjectsOwnerEnd", 1, "SVRemovedObjectsOwnerEnd", 2)
RENAME("containedObjectOne", "containedObject")
REMOVE("containedObjectsArray", "hkArray< SVHierarchyObjectEnd >")
DEPENDS("SVHierarchyObjectEnd", 2)
END()

#endif

#if defined(PATCHES_DELETED_TYPE_NEW)

BEGIN_EMPTY("SVDeletedTypeContainerStart", 0, "SVDeletedTypeContainerEnd", 0)
END_EMPTY()

BEGIN("SVDeletedTypeOwnerStart", 0, "SVDeletedTypeOwnerEnd", 0)
FUNCTION(SVDeletedTypeOwnerStart_0_to_SVDeletedTypeOwnerEnd_0_var)
REMOVE("a", "SVDeletedType")
REMOVE("b", "SVDeletedType")
DEPENDS("SVDeletedType", 0)
END()

BEGIN("SVDeletedType", 0, HK_NULL, HK_CLASS_REMOVED)
REMOVE("value", "int")
//DEPENDS("SVDeletedTypeOwnerEnd", 0)
END()

#endif

#if defined(PATCHES_HOMOGENEOUS_ARRAY_NEW)

BEGIN("SVHomogeneousArrayContainerStart", 0, "SVHomogeneousArrayContainerEnd", 1)
ADD("mem0", "float")
SET_VALUE("mem0", float, 100.0f) // not needed
REMOVE("array", "hkVariantArray")
END()

#endif

#if defined(PATCHES_OLD_NATIVE_NEW)

// Class is added and removed again
BEGIN(HK_NULL, HK_CLASS_ADDED, "SVAddRemoveClass", 0)
ADD("mem0", "hkReal")
SET_VALUE("mem0", hkReal, 100.0f)
ADD("mem1", "hkReal")
SET_VALUE("mem1", hkReal, -2000.0f)
END()

BEGIN("SVAddRemoveClass", 0, "SVAddRemoveClass", 1)
ADD("mem2", "hkReal")
SET_VALUE("mem2", hkReal, 3000.0f)
REMOVE("mem1", "hkReal")
END()

BEGIN("SVAddRemoveClass", 1, HK_NULL, HK_CLASS_REMOVED)
REMOVE("mem0", "hkReal")
REMOVE("mem2", "hkReal")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "SVSecondEmbedType", 0)
ADD("emb_c", "unsigned")
SET_VALUE("emb_c", unsigned, 0xeecceecc)
ADD("emb_d", "unsigned")
SET_VALUE("emb_d", unsigned, 0xeeddeedd)
END()

BEGIN("SVSecondEmbedType", 0, "SVSecondEmbedTypeFinal", 1)
//DEPENDS("SVEmbedType")
REMOVE("emb_d", "int")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "SVSecondVersioningTest", 0)
ADD("a", "unsigned")
SET_VALUE("a", unsigned, 0xaaaaaaaa)
ADD("embed2", "SVSecondEmbedType")
DEPENDS("SVSecondEmbedType", 0)
END()

BEGIN("SVSecondVersioningTest", 0, "SVSecondVersioningTest", 1)
ADD("b", "unsigned")
SET_VALUE("b", unsigned, 0xbbbbbbbb)
ADD("c", "unsigned")
SET_VALUE("c", unsigned, 0xcccccccc)
END()

BEGIN("SVSecondVersioningTest", 1, "SVSecondVersioningTest", 2)
DEPENDS("SVAddRemoveClass", 1)
//DEPENDS("SVEmbedType")
REMOVE("b", "int")
ADD("ar", "SVAddRemoveClass")
ADD("add_rem_add", "hkReal")
SET_VALUE("add_rem_add", hkReal, 25.0f)
END()

BEGIN("SVSecondVersioningTest", 2, "SVSecondVersioningTest", 3)
DEPENDS("SVEmbedType", 1)
ADD("d", "int")
SET_VALUE("d", int, 0x0ddddddd)
ADD("e", "int")
SET_VALUE("e", int, 0x0eeeeeee)
ADD("embed", "SVEmbedType[2]")
REMOVE("add_rem_add", "hkReal")
ADD("array", "int[4]") /* int m_array[4] */
ADD("embedTypehkArray", "hkArray< SVEmbedType >")
END()

BEGIN("SVSecondVersioningTest", 3, "SVSecondVersioningTestFinal", 4)
ADD("add_rem_add", "int")
SET_VALUE("add_rem_add", int, 0x0addaadd)
ADD("ptr", "SVEmbedType*")
FUNCTION(SVSecondVersioningTest_3_to_4_var)
REMOVE("ar", "SVAddRemoveClass")
REMOVE("c", "int")
REMOVE("d", "int")
SET_PARENT(HK_NULL, "SVPatchParentFinal")
DEPENDS("SVPatchParentFinal", 0)
DEPENDS("SVEmbedType", 1)
DEPENDS("SVAddRemoveClass", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "SVEmbedType", 0)
ADD("int", "int")
SET_VALUE("int", int, 27)
END()

BEGIN("SVEmbedType", 0, "SVEmbedType", 1)
ADD("real", "hkReal")
SET_VALUE("real", hkReal, -100.0f)
END()

BEGIN_EMPTY("SVEmbedType", 1, "SVEmbedTypeFinal", 2)
//REMOVE("emb_a", "int") // WTF? Where did this come from
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "SVPatchParentFinal", 0)
ADD("mem", "float")
SET_VALUE("mem", float, 2.0f)
END()

#endif

#if defined(PATCHES_TYPE_COMBINE_NEW)

//
// A0 -> A1 -> A2 -> C3
// B0 -> B1 ---/
//

BEGIN("SVTypeCombineStartA", 0, "SVTypeCombineStartA", 1)
ADD("anotherInt", "int")
END()

BEGIN("SVTypeCombineStartA", 1, "SVTypeCombineStartA", 2)
REMOVE("anotherInt", "int")
REMOVE("anInt", "int")
ADD("same", "hkReal")
FUNCTION(SVTypeCombineStartA_1_to_2_var)
END()

BEGIN("SVTypeCombineStartA", 2, "SVTypeCombineEndC", 3)
ADD("stuff", "hkArray< int >")
END()

BEGIN("SVTypeCombineStartB", 0, "SVTypeCombineStartB", 1)
ADD("same", "hkReal")
FUNCTION(SVTypeCombineStartB_0_to_1_var)
END()

BEGIN_COMBINE("SVTypeCombineStartB", 1, "SVTypeCombineStartA", 2)
REMOVE("someInt", "int")
END()

#endif

#if defined(PATCHES_TEXT_ARRAY_ARRAY_NEW)
BEGIN("SVTextDescStart", 0, "SVTextDescEnd", 1)
ADD("allTheInts", "hkArray< int >")
FUNCTION(SVTextDesc_Start0_to_End1_var)
REMOVE("lotsOfArrays", "hkArray< hkArray< hkArray< hkArray< int > > > >")
END()
#endif

#if defined(PATCHES_TRACK_COMBINE_NEW)

BEGIN_COMBINE("SVCombineTrackA_Alt", 0, "SVCombineTrackA_int", 0)
ADD("intVal", "int")
FUNCTION(SVCombineTrackA_Alt_float_to_int_var)
REMOVE("floatVal", "float")
END()

BEGIN_EMPTY("SVCombineTrackA", 0, "SVCombineTrackA_int", 0)
END_EMPTY()

BEGIN("SVCombineTrackA_int", 0, "SVCombineTrackB", 1)
ADD("copiedIntVal", "int")
FUNCTION(SVCombineTrackA_Alt_copy_int_val_var)
END()

#endif

#if defined(PATCHES_DOUBLE_PRECISION_NEW)

BEGIN("SVDoubleStart", 0, "SVDoubleEnd", 0)
FUNCTION(SVDoubleStart_0_to_End_0_var)
RENAME("spVec", "dpVec2")
END()

#endif

#if defined(PATCHES_BACKLINK_TRACK_NEW)

BEGIN("SVBacklinkStart", 0, "SVBacklinkEnd", 0)
FUNCTION(SVBacklinkStart_0_to_End_0_var)
DEPENDS("SVBacklinkLinkedEnd", 0)
END()

BEGIN("SVBacklinkLinkedStart", 0, "SVBacklinkLinkedEnd", 0)
FUNCTION(SVBacklinkLinkedStart_0_to_End_0_var)
END()

BEGIN("SVBacklinkContainerArrayStart", 0, "SVBacklinkContainerArrayEnd", 0)
DEPENDS("SVBacklinkLinkedEnd", 0)
FUNCTION(SVBacklinkContainerArrayStart_0_to_End_0_var)
END()

#endif

#if defined(PATCHES_TYPE_POINTERS_NEW)

// Slightly different modifications to the same type in the simple test
BEGIN("SVSimpleStart", 0, "SVSimpleEnd", 0)
ADD("differentVector", "hkVector4")
RENAME("i_am_a_float", "originalFloatDivedByTen")
RENAME("i_am_an_int", "originalIntPlusTen")
ADD("addedOriginalValue", "int")
REMOVE("i_am_a_bool", "bool")
END()

BEGIN("SVDeletedType", 0, HK_NULL, HK_CLASS_REMOVED)
REMOVE("value", "int")
END()

BEGIN("SVTypePointersStart", 0, "SVTypePointersEnd", 0)
REMOVE("willBeDeleted", "SVDeletedType")
DEPENDS("SVDeletedType", 0)
END()

#endif

#if defined(PATCHES_IMPORTS_NEW)

BEGIN("SVImportsStart", 0, "SVImportsEnd", 0)
RENAME("normal", "normalEnd")
RENAME("imported1", "imported1End")
ADD("imported2End", "hkArray< hkReferencedObject* >")
FUNCTION(SVImportsStart_0_to_SVImportsEnd_0_var)
REMOVE("imported2", "hkReferencedObject*")
REMOVE("mixed", "hkArray< hkReferencedObject* >")
DEPENDS("hkReferencedObject", 3)
END()


#endif

#if defined(PATCHES_UNPATCHED_TYPE_IN_FUNCTION)

BEGIN("SVContainerFnStart", 0, "SVContainerFnEnd", 0)
    FUNCTION(SVContainerFnStart_End_var)
    DEPENDS("SVContainerFnThing", 0)
END()

#endif

#if defined(PATCHES_REMOVEAT_AND_UNPATCHED_ACCESS)

BEGIN("SVTestingRemoveAtStart", 0, "SVTestingRemoveAtEnd", 0)
    ADD("firstObject", "SVTestingRemoveAtObjectInArray")
    FUNCTION(SVTestingRemoveAt_var)

    DEPENDS("SVTestingRemoveAtObjectInArray", 0)
    DEPENDS("SVTestingRemoveObject", 0)
END()

#endif

#if defined(PATCHES_PATCHED_FIELD_UNPATCHED_STRUCT)

BEGIN("SVPatchedFieldInUnpatchedStruct", 0, "SVPatchedFieldInUnpatchedStruct", 1)
    ADD("fieldFloat", "float")
    FUNCTION(SVPatchedFieldInUnpatchedStructStart_to_End_var)
    REMOVE("fieldInt", "int")
END()

#endif

#if defined(PATCHES_FROM_NATIVE_VERSION)

// This patch should refuse to register as its starting type/version is native
BEGIN("SVSimpleEnd", 0, "SVSimpleEnd", 1)
    REMOVE("differentVector", "hkVector4")
END()

#endif

HK_DETAIL_DIAG_CLANG_POP()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
