// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Compat/UnitTest/Version/SimpleVersioningClasses.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>
#include <Common/Base/Reflect/Version/hkReflectVersionPatcher.h>
#include <Common/Base/Reflect/Version/hkReflectVersionPatches.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>
#include <Common/Base/Serialize/Detail/hkIndexedBundle.h>
#include <Common/Base/Serialize/Resource/hkObjectResource.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileWriteFormat.h>
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>
#include <Common/Base/Config/hkOptionalComponent.h>
#include <Common/Base/UnitTest/Serialize/urlObjects.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>



class ChainedTypeRegistry : public hkReflect::MutableTypeReg
{
public:

    ChainedTypeRegistry(hkReflect::MutableTypeReg* chainedReg) : m_chainedReg(chainedReg) {}
    virtual ~ChainedTypeRegistry() {}

    virtual const hkReflect::Type* typeFromName(const char* name) const HK_OVERRIDE
    {
        // Deleted types will have no name
        if(name)
        {
            for (int i = 0; i < m_types.getSize(); i++)
            {
                if (hkString::strCmp(m_types[i]->getName(), name) == 0)
                {
                    return m_types[i];
                }
            }
            return m_chainedReg->typeFromName(name);
        }
        return HK_NULL;
    }
    virtual const hkReflect::Type* typeFromType(const hkReflect::Type* type) const HK_OVERRIDE
    {
        hkStringBuf b;
        const char* typeFullName = type->getFullName(b);

        for (int i = 0; i < m_types.getSize(); i++)
        {
            if (hkString::strCmp(m_types[i]->getName(), typeFullName) == 0)
            {
                return m_types[i];
            }
        }

        return m_chainedReg->typeFromType(type);
    }
    virtual void appendAllTypesToArray(hkArray<const hkReflect::Type*>& types) const HK_OVERRIDE
    {
        m_chainedReg->appendAllTypesToArray(types);
        types.append(m_types);
    }

    virtual hkResult add(hkReflect::Type* type) HK_OVERRIDE
    {
        m_types.pushBack(type);
        return HK_SUCCESS;
    }

    virtual hkResult remove(hkReflect::Type* type) HK_OVERRIDE
    {
        hkResult res(HK_FAILURE);
        for (int i = 0; i < m_types.getSize(); i++)
        {
            if (m_types[i] == type)
            {
                m_types.removeAt(i);
                i--;
                res = HK_SUCCESS;
            }
        }
        return res;
    }

    virtual Subscription subscribeForChange(TypesChangedFunc cbFunc, void* cbData) HK_OVERRIDE{ return Subscription(); }
    virtual void notifyTypesMutated() HK_OVERRIDE {}

    hkArray<hkReflect::Type*> m_types;
    hkRefPtr<hkReflect::MutableTypeReg> m_chainedReg;
};

bool SVHierarchyObjectEnd::operator ==(const SVHierarchyObjectEnd& rhs) const
{
    if (m_values.getSize() != rhs.m_values.getSize())
    {
        return false;
    }
    for (int i = 0; i < m_values.getSize(); ++i)
    {
        if (m_values[i] != rhs.m_values[i])
        {
            return false;
        }
    }
    return true;
}

namespace
{
    typedef hkHashMap< hkReflect::Var, hkArray<hkReflect::Var> > NoteMap;
    typedef hkHashMap<hkReflect::Var, hkStringPtr> NameFromVar;
    typedef hkHashMap<hkStringPtr, hkReflect::Var> VarFromName;

    using namespace hkSerialize;
    using namespace hkReflect;

    class AutoBundle : public hkSerialize::Detail::OldIndexedBundle
    {
    public:
        AutoBundle()
        {
            m_vars.setSize(1);
            m_types.pushBack(HK_NULL);
            m_extras.setSize(1);
        }
        VarId addVar(const Var& v)
        {
            TypeId tid = addType(v.getType());
            m_vars.expandOne().set(v.getAddress(), tid);
            return m_vars.getSize() - 1;
        }
        VarId addNote(const Var& v, const Var& note)
        {
            TypeId tid = addType(note.getType());

            VarId varId = -1;
            for (int i = 0; i < m_vars.getSize(); ++i)
            {
                if (m_vars[i].m_addr == v.getAddress() && m_vars[i].m_tid == addType(v.getType()))
                {
                    varId = i;
                    break;
                }
            }
                HK_ASSERT_NO_MSG(0x445f227a, varId >= 0);
            if (m_vars[varId].m_addr == HK_NULL)
            {
                // Note on import
                m_vars[varId].m_count = m_notes.getSize();
            }
            m_notes.expandOne().set(note.getAddress(), tid, varId);


            return m_notes.getSize() - 1;
        }
        TypeId addType(const Type* t)
        {
            hkHashMap<const Type*, TypeId>::Iterator it = m_tidFromType.findOrInsertKey(t, -1);
            if (m_tidFromType.getValue(it) == -1)
            {
                m_tidFromType.setValue(it, m_types.getSize());
                m_types.pushBack(t);
            }
            return m_tidFromType.getValue(it);
        }
        int addVarN(const VarN& v)
        {
            TypeId tid = addType(v.getType());
            m_extras.expandOne().set(v.getAddress(), tid, v.getCount());
            return m_extras.getSize() - 1;
        }

        void clear()
        {
            m_tidFromType.clear();
            hkSerialize::Detail::OldIndexedBundle::clear();

            m_vars.setSize(1);
            m_notes.clear();
            m_types.pushBack(HK_NULL);
            m_extras.setSize(1);
        }

        virtual hkReflect::Var getNoteOnPointer(const hkReflect::PointerVar& ptr) const HK_OVERRIDE
        {
            // unused
            return hkReflect::Var();
        }

    protected:
        hkHashMap<const Type*, TypeId> m_tidFromType;
    };

    class VersionTestPatchAdder : public hkReflect::Version::PatchAdder
    {
    public:
        VersionTestPatchAdder(hkReflect::Version::PatchRegistry& reg) : hkReflect::Version::PatchAdder(reg) {}
        virtual ~VersionTestPatchAdder() {}

        virtual void handlePatch(_In_ const hkReflect::Version::PatchInfo* p)
        {
            // Override the default behaviour and register everything
            m_reg.addPatchAndInvalidate(p);
        }
    };
}

namespace SVSimple
{
    void SVSimpleStart_0_to_SVSimpleEnd_0(hkDataObject& obj)
    {
        const float originalFloat = obj["i_am_a_float"].asReal();
        const int originalInt = obj["i_am_an_int"].asInt();
        obj["originalFloatDivedByTen"] = originalFloat / 10.0f;
        obj["originalIntPlusTen"] = originalInt + 10;
        obj["addedOriginalValue"] = originalInt;
        hkVector4f newVal; newVal.set(2.0f, -4.0f, 8.0f, -16.0f);
        obj["differentVector"] = newVal;
    }

    void SVSimpleStart_0_to_SVSimpleEnd_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::FloatVar originalFloat(obj["i_am_a_float"]);
        hkReflect::IntVar originalInt(obj["i_am_an_int"]);

        hkReflect::FloatVar originalFloatDivedByTen(obj["originalFloatDivedByTen"]);
        originalFloatDivedByTen.setValue(originalFloat.getValue().m_value / 10.0f);

        hkReflect::IntVar originalIntPlusTen(obj["originalIntPlusTen"]);
        originalIntPlusTen.setValue(hkReflect::IntValue(originalInt.getValue().convertTo<int>() + 10));
        // = originalInt + 10;
        hkReflect::IntVar addedOriginalValue(obj["addedOriginalValue"]);
        addedOriginalValue.setValue(hkReflect::IntValue(originalInt.getValue().convertTo<int>()));
        // = originalInt;
        hkVector4f newVal; newVal.set(2.0f, -4.0f, 8.0f, -16.0f);

        obj["differentVector"].assign(hkReflect::Var(&newVal));
    }

    template<class VERSIONANDCLONE>
    void initSimple(SVSimpleStart& start, VERSIONANDCLONE& vc)
    {
        start.m_pos.set(1.0f, 2.0f, 3.0f, 4.0f);
        start.m_i_am_an_int = 29434;
        start.m_i_am_a_float = -4e8f;
        start.m_i_am_a_string = "SSSsss...";
        start.m_selfPtr = &start;
        start.m_i_am_a_bool = true;
        start.m_i_will_become_a_true_bool = 42;
        start.m_i_will_become_a_false_bool = 0;

        vc.addVar(&start);
    }

    void checkContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        if (const SVSimpleEnd* versioningEnd = contents.dynCast<SVSimpleEnd>())
        {
            if (HK_TEST(versioningEnd))
            {
                hkSimdFloat32 eps = hkSimdFloat32::fromFloat(1e-6f);
                if (HK_TEST(versioningEnd->m_i_am_a_string.cString()))
                {
                    HK_TEST_EQ(versioningEnd->m_i_am_a_string.cString(), (const char*)"SSSsss...");
                }
                HK_TEST_EQ(versioningEnd->m_originalFloatDivedByTen, -4e7f);
                HK_TEST_EQ(versioningEnd->m_originalIntPlusTen, 29444);
                HK_TEST_EQ(versioningEnd->m_addedOriginalValue, 29434);
                hkVector4f ref; ref.set(1.0f, 2.0f, 3.0f, 4.0f);
                HK_TEST(versioningEnd->m_pos.allEqual<4>(ref, eps));
                hkVector4f newValShouldBe; newValShouldBe.set(2.0f, -4.0f, 8.0f, -16.0f);
                HK_TEST(versioningEnd->m_differentVector.allEqual<4>(newValShouldBe, eps));
                if (HK_TEST(versioningEnd->m_selfPtr))
                {
                    HK_TEST_EQ(const_cast<const SVSimpleEnd*>(versioningEnd->m_selfPtr), versioningEnd);
                }
                HK_TEST(versioningEnd->m_i_will_become_a_true_bool);
                HK_TEST(versioningEnd->m_i_will_become_a_false_bool == false);
                HK_TEST_EQ(versioningEnd->m_nonSerialized, 2.0);

                if (needToDeleteOutput)
                {
                    delete versioningEnd;
                }
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testSimpleChanges()
{
    using namespace SVSimple;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_SIMPLE_CHANGES
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_SIMPLE_CHANGES
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSimpleStart start;
    initSimple(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        // Not a (globally) registered type so we can't use isInstanceOf
        checkContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testSimpleChangesPatchV2()
{
    using namespace SVSimple;

    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_SIMPLE_CHANGES_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_SIMPLE_CHANGES_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSimpleStart start;
    initSimple(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        checkContents(contents, vc.needToDeleteOutput());
    }
}

namespace RenameReadd
{
    void SVSimpleStart_0_to_SVRenameAddedEnd_1(hkDataObject& obj)
    {
        hkVector4f newPos; newPos.set(-4.0f, -50.0f, -600.0f, -7000.0f);
        obj["pos"] = newPos;
        obj["i_am_an_int"] = 2000;
        obj["i_am_a_float"] = 9999.0f;
        obj["i_am_a_string"] = "NewStrrrrRr";
    }

    void SVRenameAddedEnd_1_to_SVRenameAddedEnd_2(hkDataObject& obj)
    {
        hkVector4f newPos; newPos.set(1e5f, 2e6f, 3e7f, 4e8f);
        obj["pos"] = newPos;
        obj["i_am_an_int"] = 44444;
        obj["i_am_a_float"] = 1.0f;
        obj["i_am_a_string"] = "lastString";
    }

    void SVRenameAddedEnd_2_to_SVRenameAddedEnd_3(hkDataObject& obj)
    {
        obj["i_am_an_int"] = 33333;
        obj["i_am_a_floatRenamedOnce"] = 22.0f;
        obj["i_am_an_intRenamedTwice"] = 8888;
        obj["i_am_a_stringRenamedTwice"] = "anotherString";
    }

    void SVSimpleStart_0_to_SVRenameAddedEnd_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkVector4f newPos; newPos.set(-4.0f, -50.0f, -600.0f, -7000.0f);

        obj["pos"].assign(hkReflect::Var(&newPos));

        hkReflect::IntVar(obj["i_am_an_int"]).setValue(2000);
        hkReflect::FloatVar(obj["i_am_a_float"]).setValue(9999.0f);
        hkReflect::StringVar(obj["i_am_a_string"]).setValue("NewStrrrrRr");

        obj["added_vec4_identity"].assign(hkReflect::Var(&hkVec4_0001));
        obj["added_vec16_identity"].assign(hkReflect::Var(&hkTransform::getIdentity()));
    }

    void SVRenameAddedEnd_1_to_SVRenameAddedEnd_2_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkVector4f newPos; newPos.set(1e5f, 2e6f, 3e7f, 4e8f);
        obj["pos"].assign(hkReflect::Var(&newPos));

        hkReflect::IntVar(obj["i_am_an_int"]).setValue(44444);
        hkReflect::FloatVar(obj["i_am_a_float"]).setValue(1.0f);
        hkReflect::StringVar(obj["i_am_a_string"]).setValue("lastString");
    }

    void SVRenameAddedEnd_2_to_SVRenameAddedEnd_3_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::IntVar(obj["i_am_an_int"]).setValue(33333);
        hkReflect::FloatVar(obj["i_am_a_floatRenamedOnce"]).setValue(22.0f);
        hkReflect::IntVar(obj["i_am_an_intRenamedTwice"]).setValue(8888);
        hkReflect::StringVar(obj["i_am_a_stringRenamedTwice"]).setValue("anotherString");
    }

    template<class VERSIONANDCLONE>
    void initSimple(SVSimpleStart& start, VERSIONANDCLONE& vc)
    {
        start.m_pos.set(25.0f, 50.0f, 100.0f, 200.0f);
        start.m_i_am_an_int = -500;
        start.m_i_am_a_float = 2.68;
        start.m_i_am_a_string = "Strrrr";
        start.m_selfPtr = HK_NULL;

        vc.addVar(&start);
    }

    void checkContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        hkSimdFloat32 eps = hkSimdFloat32::fromFloat(1e-6f);
        const SVRenameAddedEnd* versioningEnd = contents.dynCast<SVRenameAddedEnd>();
        if (HK_TEST(versioningEnd))
        {
            if (HK_TEST(versioningEnd->m_i_am_a_string.cString()))
            {
                HK_TEST_EQ(versioningEnd->m_i_am_a_string.cString(), (const char*)"lastString");
            }
            HK_TEST_EQ(versioningEnd->m_i_am_a_float, 1.0f);
            HK_TEST_EQ(versioningEnd->m_i_am_an_int, 33333);

            {
                hkVector4f newValShouldBe; newValShouldBe.set(1e5f, 2e6f, 3e7f, 4e8f);
                HK_TEST(versioningEnd->m_pos.allEqual<4>(newValShouldBe, eps));
            }

            if (HK_TEST(versioningEnd->m_i_am_a_stringRenamedOnce.cString()))
            {
                HK_TEST_EQ(versioningEnd->m_i_am_a_stringRenamedOnce.cString(), (const char*)"NewStrrrrRr");
            }
            HK_TEST_EQ(versioningEnd->m_i_am_a_floatRenamedOnce, 22.0f);
            HK_TEST_EQ(versioningEnd->m_i_am_an_intRenamedOnce, 2000);

            {
                hkVector4f newValShouldBe; newValShouldBe.set(-4.0f, -50.0f, -600.0f, -7000.0f);
                HK_TEST(versioningEnd->m_posRenamedOnce.allEqual<4>(newValShouldBe, eps));
            }

            if (HK_TEST(versioningEnd->m_i_am_a_stringRenamedTwice.cString()))
            {
                HK_TEST_EQ(versioningEnd->m_i_am_a_stringRenamedTwice.cString(), (const char*)"anotherString");
            }
            HK_TEST_EQ(versioningEnd->m_i_am_a_floatRenamedTwice, 2.68f);
            HK_TEST_EQ(versioningEnd->m_i_am_an_intRenamedTwice, 8888);

            {
                hkVector4f newValShouldBe; newValShouldBe.set(25.0f, 50.0f, 100.0f, 200.0f);
                HK_TEST(versioningEnd->m_posRenamedTwice.allEqual<4>(newValShouldBe, eps));
            }

            {
                hkVector4 vec4;

                vec4.set(1, 2, 3, 4);
                HK_TEST(versioningEnd->m_added_vec4.allExactlyEqual<4>(vec4));

                vec4.set(0, 0, 0, 1);
                HK_TEST(versioningEnd->m_added_vec4_identity.allExactlyEqual<4>(vec4));

                vec4.set(1, 2, 3, 4);
                HK_TEST(versioningEnd->m_added_vec16.getColumn(0).allExactlyEqual<4>(vec4));
                vec4.set(5, 6, 7, 8);
                HK_TEST(versioningEnd->m_added_vec16.getColumn(1).allExactlyEqual<4>(vec4));
                vec4.set(9, 10, 11, 12);
                HK_TEST(versioningEnd->m_added_vec16.getColumn(2).allExactlyEqual<4>(vec4));
                vec4.set(13, 14, 15, 16);
                HK_TEST(versioningEnd->m_added_vec16.getColumn(3).allExactlyEqual<4>(vec4));

                vec4.set(1, 0, 0, 0);
                HK_TEST(versioningEnd->m_added_vec16_identity.getColumn(0).allExactlyEqual<4>(vec4));
                vec4.set(0, 1, 0, 0);
                HK_TEST(versioningEnd->m_added_vec16_identity.getColumn(1).allExactlyEqual<4>(vec4));
                vec4.set(0, 0, 1, 0);
                HK_TEST(versioningEnd->m_added_vec16_identity.getColumn(2).allExactlyEqual<4>(vec4));
                vec4.set(0, 0, 0, 1);
                HK_TEST(versioningEnd->m_added_vec16_identity.getColumn(3).allExactlyEqual<4>(vec4));
            }

            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }

        }
    }
}

template<class VERSIONANDCLONE>
void testRenamedReadded()
{
    using namespace RenameReadd;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRenameAddedEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_RENAME_READDED
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_RENAME_READDED
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSimpleStart start;
    initSimple(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        checkContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testRenamedReaddedPatchV2()
{
    using namespace RenameReadd;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRenameAddedEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_RENAME_READDED_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_RENAME_READDED_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSimpleStart start;
    initSimple(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        checkContents(contents, vc.needToDeleteOutput());
    }
}

namespace SVHierarchy
{
    void SVHierarchyObjectStart_0_to_SVHierarchyObjectEnd_1(hkDataObject& obj)
    {
        int count = obj["count"].asInt();
        float firstVal = obj["value"].asReal();

        hkDataArray arr = obj["values"].asArray();
        arr.setSize(count);
        for (int i = 0; i < count; i++)
        {
            arr[i] = firstVal + 3.14f * i;
        }
    }

    void SVHierarchyOwnerStart_0_to_SVHierarchyOwnerEnd_1(hkDataObject& obj)
    {
        hkDataObject oldObjA = obj["objA"].asObject();
        hkDataObject oldObjB = obj["objB"].asObject();
        hkDataObject oldObjC = obj["objC"].asObject();
        hkDataObject newObjA = obj.getWorld().newObject(oldObjA.getClass());
        hkDataObject newObjB = obj.getWorld().newObject(oldObjB.getClass());
        hkDataObject newObjC = obj.getWorld().newObject(oldObjC.getClass());

        newObjA = oldObjA;
        newObjB = oldObjB;
        newObjC = oldObjC;

        hkDataArray arr = obj["objs"].asArray();
        arr.setSize(3);
        arr[0] = newObjA;
        arr[1] = newObjB;
        arr[2] = newObjC;
    }

    void SVHierarchyObjectStart_0_to_SVHierarchyObjectEnd_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        int count = hkReflect::IntVar(obj["count"]).getValue().convertTo<int>();
        double firstVal = hkReflect::FloatVar(obj["value"]).getValue().m_value;

        hkReflect::ArrayVar arr(obj["values"]);
        arr.setArraySize(count);
        for (int i = 0; i < count; i++)
        {
            hkReflect::FloatVar(arr[i]).setValue(firstVal + 3.14f * i);
        }
    }

    void SVHierarchyOwnerStart_0_to_SVHierarchyOwnerEnd_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var oldObjA(obj["objA"]);
        hkReflect::Var oldObjB(obj["objB"]);
        hkReflect::Var oldObjC(obj["objC"]);
        hkReflect::Var newObjA = helper.newObject(oldObjA.getType());
        hkReflect::Var newObjB = helper.newObject(oldObjB.getType());
        hkReflect::Var newObjC = helper.newObject(oldObjC.getType());

        newObjA.assign(oldObjA);
        newObjB.assign(oldObjB);
        newObjC.assign(oldObjC);

        hkReflect::ArrayVar arr(obj["objs"]);
        arr.setArraySize(3);
        hkReflect::PointerVar(arr[0]).setValue(newObjA);
        hkReflect::PointerVar(arr[1]).setValue(newObjB);
        hkReflect::PointerVar(arr[2]).setValue(newObjC);
    }

    template<class VERSIONANDCLONE>
    void initHierarchy(SVHierarchyOwnerStart& start, VERSIONANDCLONE& vc)
    {
        start.m_value = 1;
        start.m_objA.m_count = 8;
        start.m_objA.m_value = 1.0f;
        start.m_objB.m_count = 2;
        start.m_objB.m_value = 2.11f;
        start.m_objC.m_count = 20;
        start.m_objC.m_value = 3.22f;

        vc.template addType<SVHierarchyObjectStart>(); // TODO.ntm Something weird with the order of types here but this works
        vc.addVar(&start);

        vc.template addType<SVHierarchyOwnerStart>(); // If you swap these it seems not to work?
    }

    void test(SVHierarchyOwnerStart* start)
    {
        if (HK_TEST(start))
        {
            HK_TEST_EQ(start->m_value, 1);
            HK_TEST_EQ(start->m_objA.m_count, 8);
            HK_TEST_EQ(start->m_objA.m_value, 1.0f);
            HK_TEST_EQ(start->m_objB.m_count, 2);
            HK_TEST_EQ(start->m_objB.m_value, 2.11f);
            HK_TEST_EQ(start->m_objC.m_count, 20);
            HK_TEST_EQ(start->m_objC.m_value, 3.22f);
        }
    }

    void testContents(const SVHierarchyOwnerEnd* versioningEnd)
    {
        if (HK_TEST(versioningEnd))
        {
            HK_TEST_EQ(versioningEnd->m_value, 1);

            if (HK_TEST(versioningEnd->m_objs.getSize() == 3))
            {
                hkRefPtr<SVHierarchyObjectEnd> objA = versioningEnd->m_objs[0];
                hkRefPtr<SVHierarchyObjectEnd> objB = versioningEnd->m_objs[1];
                hkRefPtr<SVHierarchyObjectEnd> objC = versioningEnd->m_objs[2];

                if (HK_TEST(objA->m_values.getSize() == 8))
                {
                    for (int i = 0; i < objA->m_values.getSize(); i++)
                    {
                        HK_TEST_EQ((float)objA->m_values[i], 1.0f + 3.14f * i);
                    }
                }
                if (HK_TEST(objB->m_values.getSize() == 2))
                {
                    for (int i = 0; i < objB->m_values.getSize(); i++)
                    {
                        HK_TEST_EQ((float)objB->m_values[i], 2.11f + 3.14f * i);
                    }
                }
                if (HK_TEST(objC->m_values.getSize() == 20))
                {
                    for (int i = 0; i < objC->m_values.getSize(); i++)
                    {
                        HK_TEST_EQ((float)objC->m_values[i], 3.22f + 3.14f * i);
                    }
                }
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testHierarchy()
{
    using namespace SVHierarchy;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyOwnerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyOwnerEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_HIERARCHY
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_HIERARCHY
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVHierarchyOwnerStart start;
    initHierarchy(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        // Not a (globally) registered type so we can't use isInstanceOf
        if (HK_TEST_EQ(contents.getType()->getName(), (const char*)"SVHierarchyOwnerEnd"))
        {
            const SVHierarchyOwnerEnd* versioningEnd = reinterpret_cast<SVHierarchyOwnerEnd*>(contents.getAddress());
            testContents(versioningEnd);

            // Even though it is a refobj, the ref count is zero as it is not in a resource
            if (vc.needToDeleteOutput())
            {
                delete versioningEnd;
            }
        }
    }
}

template<typename T>
static hkSerialize::VarN VarN_fromArray(const hkArray<T>& a)
{
    return hkSerialize::VarN::fromArray(a.begin(), hkReflect::getType<T>(), a.getSize());
}

namespace RemovedObjects
{
    template<class VERSIONANDCLONE>
    void initRemoved(SVRemovedObjectsOwnerStart& start, VERSIONANDCLONE& vc)
    {
        SVHierarchyObjectEnd* objOne = new SVHierarchyObjectEnd();
        objOne->m_values.pushBack(1.0);
        start.m_containedObjectOne.setAndDontIncrementRefCount(objOne);
        SVHierarchyObjectEnd* objTwo = new SVHierarchyObjectEnd();
        objTwo->m_values.pushBack(2.0);
        start.m_containedObjectTwo.setAndDontIncrementRefCount(objTwo);
        SVHierarchyObjectEnd* objThree = new SVHierarchyObjectEnd();
        objThree->m_values.pushBack(3.0);
        start.m_containedObjectThree.setAndDontIncrementRefCount(objThree);
        SVHierarchyObjectEnd* objFour = new SVHierarchyObjectEnd();
        objFour->m_values.pushBack(4.0);
        start.m_containedObjectFour.setAndDontIncrementRefCount(objFour);
        SVHierarchyObjectEnd* objInArrayA = new SVHierarchyObjectEnd();
        objInArrayA->m_values.pushBack(5.0);
        SVHierarchyObjectEnd* objInArrayB = new SVHierarchyObjectEnd();
        objInArrayB->m_values.pushBack(6.0);
        start.m_containedObjectsArray.expandOne().setAndDontIncrementRefCount(objInArrayA);
        start.m_containedObjectsArray.expandOne().setAndDontIncrementRefCount(objInArrayB);

        vc.addVar(&start);
        vc.addVar(objOne);
        vc.addVar(objTwo);
        vc.addVar(objThree);
        vc.addVar(objFour);
        vc.addVar(objInArrayA);
        vc.addVar(objInArrayB);
        vc.addVarN(hkSerialize::VarN::invalid());
        vc.addVarN(VarN_fromArray(objOne->m_values));
        vc.addVarN(VarN_fromArray(objTwo->m_values));
        vc.addVarN(VarN_fromArray(objThree->m_values));
        vc.addVarN(VarN_fromArray(objFour->m_values));
        vc.addVarN(VarN_fromArray(objInArrayA->m_values));
        vc.addVarN(VarN_fromArray(objInArrayB->m_values));
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVRemovedObjectsOwnerEnd* versioningEnd = contents.dynCast<SVRemovedObjectsOwnerEnd>();
        if (HK_TEST(versioningEnd))
        {
            hkRefPtr<SVHierarchyObjectEnd> obj = hkDynCast<SVHierarchyObjectEnd>(versioningEnd->m_containedObject);
            if (HK_TEST(obj))
            {
                if (HK_TEST(obj->m_values.getSize() == 1))
                {
                    HK_TEST_EQ(obj->m_values[0], 3.0);
                }
            }

            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }

    }
}

template<class VERSIONANDCLONE>
void testRemovedObjects()
{
    using namespace RemovedObjects;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_REMOVED_OBJECTS
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_REMOVED_OBJECTS
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVRemovedObjectsOwnerStart start;
    initRemoved(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testRemovedObjectsPatchV2()
{
    using namespace RemovedObjects;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_REMOVED_OBJECTS_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_REMOVED_OBJECTS_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVRemovedObjectsOwnerStart start;
    initRemoved(start, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

namespace DeletedType
{
    void SVDeletedTypeOwnerStart_0_to_SVDeletedTypeOwnerEnd_0(hkDataObject& obj)
    {
        const int oldFirst = obj["first"].asInt();
        const int oldA = obj["a"].asObject()["value"].asInt();
        const int oldB = obj["b"].asObject()["value"].asInt();
        const int oldSecond = obj["second"].asInt();

        obj["first"] = oldFirst + oldA;
        obj["second"] = oldSecond + oldB;
    }

    void SVDeletedTypeOwnerStart_0_to_SVDeletedTypeOwnerEnd_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        const int oldFirst = hkReflect::IntVar(obj["first"]).getValue().convertTo<int>();
        const int oldA = hkReflect::IntVar(obj["a"]["value"]).getValue().convertTo<int>();
        const int oldB = hkReflect::IntVar(obj["b"]["value"]).getValue().convertTo<int>();
        const int oldSecond = hkReflect::IntVar(obj["second"]).getValue().convertTo<int>();

        hkReflect::IntVar(obj["first"]).setValue(oldFirst + oldA);
        hkReflect::IntVar(obj["second"]).setValue(oldSecond + oldB);
    }

    template<class VERSIONANDCLONE>
    void initDeleted(hkRefPtr<SVDeletedTypeContainerStart>& containerOne, hkRefPtr<SVDeletedTypeContainerStart>& containerTwo, hkRefPtr<SVDeletedTypeContainerStart>& containerThree,
                        hkRefPtr<SVDeletedTypeOwnerStart>& ownerOne, hkRefPtr<SVDeletedTypeOwnerStart>& ownerTwo, hkRefPtr<SVDeletedTypeOwnerStart>& ownerThree, VERSIONANDCLONE& vc)
    {
        containerOne.setAndDontIncrementRefCount(new SVDeletedTypeContainerStart());
        containerTwo.setAndDontIncrementRefCount(new SVDeletedTypeContainerStart());
        containerOne->m_next = containerTwo;
        containerThree.setAndDontIncrementRefCount(new SVDeletedTypeContainerStart());
        containerTwo->m_next = containerThree;
        containerThree->m_next = HK_NULL;

        ownerOne.setAndDontIncrementRefCount(new SVDeletedTypeOwnerStart());
        ownerTwo.setAndDontIncrementRefCount(new SVDeletedTypeOwnerStart());
        ownerThree.setAndDontIncrementRefCount(new SVDeletedTypeOwnerStart());

        containerOne->m_obj = ownerOne;
        containerTwo->m_obj = ownerTwo;
        containerThree->m_obj = ownerThree;

        ownerOne->m_first = 1;
        ownerOne->m_a.m_value = 2;
        ownerOne->m_b.m_value = 3;
        ownerOne->m_second = 4;

        ownerTwo->m_first = 5;
        ownerTwo->m_a.m_value = 6;
        ownerTwo->m_b.m_value = 7;
        ownerTwo->m_second = 8;

        ownerThree->m_first = 9;
        ownerThree->m_a.m_value = 10;
        ownerThree->m_b.m_value = 11;
        ownerThree->m_second = 12;

        vc.addVar(containerOne.val());
        vc.addVar(containerTwo.val());
        vc.addVar(containerThree.val());
        vc.addVar(ownerOne.val());
        vc.addVar(ownerTwo.val());
        vc.addVar(ownerThree.val());

        vc.template addType<SVDeletedType>();
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVDeletedTypeContainerEnd* versioningEnd = contents.dynCast<SVDeletedTypeContainerEnd>();
        if (HK_TEST(versioningEnd))
        {
            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testDeletedType()
{
    using namespace DeletedType;
    hkReflect::Cloner cloner;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedTypeOwnerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerEnd>().get()));
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedType>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedTypeContainerStart>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DELETED_TYPE
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_DELETED_TYPE
    }

    VERSIONANDCLONE vc(patchReg, typeReg);
    hkRefPtr<SVDeletedTypeContainerStart> containerOne;
    hkRefPtr<SVDeletedTypeContainerStart> containerTwo;
    hkRefPtr<SVDeletedTypeContainerStart> containerThree;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerOne;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerTwo;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerThree;
    initDeleted(containerOne, containerTwo, containerThree, ownerOne, ownerTwo, ownerThree, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testDeletedTypePatchV2()
{
    using namespace DeletedType;
    hkReflect::Cloner cloner;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedTypeOwnerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVRemovedObjectsOwnerEnd>().get()));
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedType>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedTypeContainerStart>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DELETED_TYPE_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_DELETED_TYPE_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);
    hkRefPtr<SVDeletedTypeContainerStart> containerOne;
    hkRefPtr<SVDeletedTypeContainerStart> containerTwo;
    hkRefPtr<SVDeletedTypeContainerStart> containerThree;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerOne;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerTwo;
    hkRefPtr<SVDeletedTypeOwnerStart> ownerThree;
    initDeleted(containerOne, containerTwo, containerThree, ownerOne, ownerTwo, ownerThree, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

hkReflect::Detail::HomogeneousArrayImpl SVHomogeneousArray::impl(HK_NULL);

namespace HomogenousArray
{
    template<class VERSIONANDCLONE>
    void initHomogeneous(SVHomogeneousArrayContainerStart& f, VERSIONANDCLONE& vc)
    {
        const char data[] = { 1, 2, 3, 4, 5 };

        f.m_array.elts = (void*)data;
        f.m_array.size = sizeof(data);
        f.m_array.capacity = sizeof(data);
        f.m_array.eltType = hkReflect::getType<char>();
        vc.addVar(&f);
    }
    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVHomogeneousArrayContainerEnd* versioningEnd = contents.dynCast<SVHomogeneousArrayContainerEnd>();
        if (HK_TEST(versioningEnd))
        {
            HK_TEST_EQ(versioningEnd->m_mem0, 100.0f);
            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testHomogenousArray()
{
    using namespace HomogenousArray;
    SVHomogeneousArray::impl = hkReflect::Detail::HomogeneousArrayImpl(hkMemHeapAllocator());

    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArrayContainerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArrayContainerEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArray>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_HOMOGENEOUS_ARRAY
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_HOMOGENEOUS_ARRAY
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVHomogeneousArrayContainerStart f;
    initHomogeneous(f, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testHomogenousArrayPatchV2()
{
    using namespace HomogenousArray;
    SVHomogeneousArray::impl = hkReflect::Detail::HomogeneousArrayImpl(hkMemHeapAllocator());

    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArrayContainerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArrayContainerEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHomogeneousArray>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_HOMOGENEOUS_ARRAY_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_HOMOGENEOUS_ARRAY_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVHomogeneousArrayContainerStart f;
    initHomogeneous(f, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

namespace Defaults
{
    void init(SVDefaultTestClass& d)
    {
        hkMemUtil::memSet(&d, 0, sizeof(d));
        hkReflect::Var(&d).writeDefault();
    }

    void testDTS(const SVDefaultTestClass* d)
    {
        if (d)
        {
            HK_TEST(d->m_int25 == 25);
            HK_TEST(d->m_int == 0);
            HK_TEST(d->m_int100 == 100);
            HK_TEST(d->m_int999 == 999);
            HK_TEST(d->m_byte254 == 254);
            HK_TEST(d->m_long == -5);
            HK_TEST_EQ(d->m_string, "someString");
            for (int i = 0; i < 4; ++i)
            {
                HK_TEST_EQ(d->m_vector.getComponent(i).getReal(), i + 1);
            }
        }
    }
}

static void testDefaults()
{
    using namespace Defaults;
    SVDefaultTestClass d;
    hkMemUtil::memSet(&d, 0, sizeof(d));

    hkReflect::Var(&d).writeDefault();

    testDTS(&d);
}

// The old VersioningProvider::TestNative, it's a decent test so moving it over

namespace TestOldNative
{
    void SVSecondVersioningTest_3_to_4(hkDataObject& o)
    {
        o["add_rem_add"] = 15000;
        int val = o["d"].asInt();
        o["c"] = val;
        hkDataObject::Value ptrVal = o["ptr"];
        hkDataWorld& world = o.getWorld();
        hkDataObject newObj = world.newObject(ptrVal.asObject().getClass());

        o["array"].asArray()[0] = 2;
        o["array"].asArray()[1] = 3;
        o["array"].asArray()[2] = 4;

        ptrVal = newObj;
    }

    void SVSecondVersioningTest_3_to_4_var(hkReflect::Var o, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::IntVar(o["add_rem_add"]).setValue(15000);
        hkReflect::IntValue val = hkReflect::IntVar(o["d"]).getValue();
        hkReflect::IntVar(o["c"]).setValue(val);
        hkReflect::PointerVar ptrVal(o["ptr"]);
        const hkReflect::Type* subType = ptrVal.getSubType();

        hkReflect::Var newObj = helper.newObject(subType);

        hkReflect::ArrayVar av(o["array"]);
        hkReflect::IntVar(av[0]).setValue(2);
        hkReflect::IntVar(av[1]).setValue(3);
        hkReflect::IntVar(av[2]).setValue(4);

        ptrVal.setValue(newObj);
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVSecondVersioningTestFinal* loaded = contents.dynCast<SVSecondVersioningTestFinal>();
        if (HK_TEST(loaded))
        {
            HK_TEST_EQ(loaded->m_a, 0x0400000);
            HK_TEST_EQ(loaded->m_embed[0].m_int, 27);
            HK_TEST_EQ(loaded->m_embed[0].m_real, -100);
            HK_TEST_EQ(loaded->m_embed[1].m_int, 27);
            HK_TEST_EQ(loaded->m_embed[1].m_real, -100);
            HK_TEST_EQ(loaded->m_e, 0x0eeeeeee);
            HK_TEST_EQ(loaded->m_embed2.m_emb_c, 1000);
            HK_TEST_EQ(loaded->m_add_rem_add, 15000); // Written in patch
            HK_TEST_EQ(loaded->m_mem, 2.0);

            HK_TEST(loaded->m_ptr != HK_NULL);
            if (loaded->m_ptr != HK_NULL)
            {
                HK_TEST_EQ(loaded->m_ptr->m_int, 27);
                HK_TEST_EQ(loaded->m_ptr->m_real, -100);
            }

            HK_TEST(loaded->m_embedPtr != HK_NULL);
            if (loaded->m_embedPtr != HK_NULL)
            {
                HK_TEST_EQ(loaded->m_embedPtr->m_emb_c, 0x00cc00cc);
                HK_TEST(loaded->m_embedPtr->m_tnp == loaded);
            }
            HK_TEST(loaded->m_embed2.m_tnp == loaded);

            HK_TEST_EQ(loaded->m_array[0], 2);
            HK_TEST_EQ(loaded->m_array[1], 3);
            HK_TEST_EQ(loaded->m_array[2], 4);
            HK_TEST_EQ(loaded->m_array[3], 0);

            HK_TEST(loaded->m_string.compareTo("testString") == 0);

            if (HK_TEST(loaded->m_stringArray.getSize() == 2))
            {
                HK_TEST(loaded->m_stringArray[0].compareTo("testStringArray1") == 0);
                HK_TEST(loaded->m_stringArray[1].compareTo("testStringArray2") == 0);
                HK_TEST(loaded->m_stringArray[0].compareTo("testStringArray2") != 0);
            }

            if (needToDeleteOutput)
            {
                delete loaded->m_ptr;
                delete loaded->m_embedPtr;
                delete loaded;
            }
        }
    }

    template<class VERSIONANDCLONE>
    void initOldNative(SVSecondVersioningTest& testMe, SVSecondEmbedType& secondObject, VERSIONANDCLONE& vc)
    {
        testMe.m_a = 0x0400000;
        testMe.m_b = 150; // Deleted
        testMe.m_c = 5000; // Deleted
        testMe.m_embed2.m_emb_c = 1000;
        testMe.m_embed2.m_emb_d = 0xffffffff; // Deleted
        testMe.m_embed2.m_tnp = &testMe;
        testMe.m_embedPtr = &secondObject;
        testMe.m_string = "testString";
        testMe.m_stringArray.pushBack("testStringArray1");
        testMe.m_stringArray.pushBack("testStringArray2");

        secondObject.m_emb_c = 0x00cc00cc;
        secondObject.m_emb_d = 0xf0f0f0f0; // Deleted
        secondObject.m_tnp = &testMe;

        vc.addVar(&testMe);
        vc.addVar(&secondObject);
        vc.addVarN(VarN_fromArray(testMe.m_stringArray));

    }
}

template<class VERSIONANDCLONE>
void testOldNative()
{
    using namespace TestOldNative;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSecondVersioningTest>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSecondEmbedType>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_OLD_NATIVE
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_OLD_NATIVE
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSecondVersioningTest testMe;
    SVSecondEmbedType secondObject;
    initOldNative(testMe, secondObject, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testOldNativePatchV2()
{
    using namespace TestOldNative;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSecondVersioningTest>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSecondEmbedType>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_OLD_NATIVE_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_OLD_NATIVE_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVSecondVersioningTest testMe;
    SVSecondEmbedType secondObject;
    initOldNative(testMe, secondObject, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}
namespace TypeCombine
{
    void SVTypeCombineStartA_1_to_2(hkDataObject& obj)
    {
        obj["same"] = obj["aDouble"].asReal();
    }
    void SVTypeCombineStartB_0_to_1(hkDataObject& obj)
    {
        obj["same"] = obj["aDouble"].asReal();
    }

    void SVTypeCombineStartA_1_to_2_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::FloatVar(obj["same"]).setValue(hkReflect::FloatVar(obj["aDouble"]).getValue());
    }
    void SVTypeCombineStartB_0_to_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::FloatVar(obj["same"]).setValue(hkReflect::FloatVar(obj["aDouble"]).getValue());
    }

    void testContentsA(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVTypeCombineEndC* versioningEnd = contents.dynCast<SVTypeCombineEndC>();
        if (HK_TEST(versioningEnd))
        {
            HK_TEST(versioningEnd->m_aDouble == -1);
            HK_TEST(versioningEnd->m_same == -1);
            HK_TEST(versioningEnd->m_stuff.isEmpty());
            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }
    }

    void testContentsB(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVTypeCombineEndC* versioningEnd = contents.dynCast<SVTypeCombineEndC>();
        if (HK_TEST(versioningEnd))
        {
            HK_TEST(versioningEnd->m_aDouble == -2);
            HK_TEST(versioningEnd->m_same == -2);
            HK_TEST(versioningEnd->m_stuff.isEmpty());
            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testTypeCombine()
{
    using namespace TypeCombine;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineStartA>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineStartB>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineEndC>().get()));

    {
        SVTypeCombineStartA f;
        f.m_anInt = 25;
        f.m_aDouble = -1;

        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TYPE_COMBINE
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_TYPE_COMBINE
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&f);

        if (hkReflect::Var contents = vc.apply())
        {
            testContentsA(contents, vc.needToDeleteOutput());
        }
    }

    {
        SVTypeCombineStartB f;
        f.m_someInt = 25;
        f.m_aDouble = -2;

        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TYPE_COMBINE
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_TYPE_COMBINE
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&f);

        if (hkReflect::Var contents = vc.apply())
        {
            testContentsB(contents, vc.needToDeleteOutput());
        }
    }
}

template<class VERSIONANDCLONE>
void testTypeCombinePatchV2()
{
    using namespace TypeCombine;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineStartA>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineStartB>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeCombineEndC>().get()));

    {
        SVTypeCombineStartA f;
        f.m_anInt = 25;
        f.m_aDouble = -1;

        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TYPE_COMBINE_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_TYPE_COMBINE_NEW
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&f);

        if (hkReflect::Var contents = vc.apply())
        {
            testContentsA(contents, vc.needToDeleteOutput());
        }
    }

    {
        SVTypeCombineStartB f;
        f.m_someInt = 25;
        f.m_aDouble = -2;

        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TYPE_COMBINE_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_TYPE_COMBINE_NEW
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&f);

        if (hkReflect::Var contents = vc.apply())
        {
            testContentsB(contents, vc.needToDeleteOutput());
        }
    }
}

namespace TextDesc
{
    void SVTextDesc_Start0_to_End1(hkDataObject& obj)
    {
        hkDataObject::Array firstArray = obj["lotsOfArrays"].asArray(); // hkArray< hkArray< hkArray< hkArray<int> > > >
        hkDataObject::Array convertedArray = obj["allTheInts"].asArray(); // hkArray<int>

        for (int firstIndex = 0; firstIndex < firstArray.getSize(); firstIndex++)
        {
            hkDataObject::Array secondArray = firstArray[firstIndex].asArray(); // hkArray< hkArray< hkArray<int> > >
            for (int secondIndex = 0; secondIndex < secondArray.getSize(); secondIndex++)
            {
                hkDataObject::Array thirdArray = secondArray[secondIndex].asArray(); // hkArray< hkArray<int> >
                for (int thirdIndex = 0; thirdIndex < thirdArray.getSize(); thirdIndex++)
                {
                    hkDataObject::Array intArray = thirdArray[thirdIndex].asArray(); // hkArray<int> >
                    for (int intIndex = 0; intIndex < intArray.getSize(); intIndex++)
                    {
                        hkDataObject::Value val = intArray[intIndex]; // pushBack!
                        const int intVal = val.asInt();
                        const int oldSize = convertedArray.getSize();
                        convertedArray.setSize(oldSize + 1);
                        convertedArray[oldSize] = intVal;
                    }
                }
            }
        }
    }

    void SVTextDesc_Start0_to_End1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::ArrayVar firstArray(obj["lotsOfArrays"]); // hkArray< hkArray< hkArray< hkArray<int> > > >
        hkReflect::ArrayVar convertedArray(obj["allTheInts"]); // hkArray<int>

        for (int firstIndex = 0; firstIndex < firstArray.getCount(); firstIndex++)
        {
            hkReflect::ArrayVar secondArray(firstArray[firstIndex]); // hkArray< hkArray< hkArray<int> > >
            for (int secondIndex = 0; secondIndex < secondArray.getCount(); secondIndex++)
            {
                hkReflect::ArrayVar thirdArray(secondArray[secondIndex]); // hkArray< hkArray<int> >
                for (int thirdIndex = 0; thirdIndex < thirdArray.getCount(); thirdIndex++)
                {
                    hkReflect::ArrayVar intArray(thirdArray[thirdIndex]); // hkArray<int> >
                    for (int intIndex = 0; intIndex < intArray.getCount(); intIndex++)
                    {
                        hkReflect::IntVar val(intArray[intIndex]);
                        convertedArray.pushBack(val);
                    }
                }
            }
        }
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVTextDescEnd* loaded = contents.dynCast<SVTextDescEnd>();
        if (HK_TEST(loaded))
        {
            if (HK_TEST_EQ(loaded->m_allTheInts.getSize(), 16))
            {
                for (int i = 0; i < loaded->m_allTheInts.getSize(); i++)
                {
                    HK_TEST_EQ(loaded->m_allTheInts[i], i + 1);
                }
            }
        }

        if (needToDeleteOutput)
        {
            delete loaded;
        }
    }

    template<class VERSIONANDCLONE>
    void initTextArray(SVTextDescStart& testMe, VERSIONANDCLONE& vc)
    {
        // hkArray< hkArray< hkArray< hkArray<int> > > >
        testMe.m_lotsOfArrays.expandOne();
        testMe.m_lotsOfArrays.expandOne();

        // hkArray< hkArray< hkArray<int> > >
        testMe.m_lotsOfArrays[0].expandOne();
        testMe.m_lotsOfArrays[0].expandOne();

        testMe.m_lotsOfArrays[0][0].expandOne();
        testMe.m_lotsOfArrays[0][0].expandOne();

        testMe.m_lotsOfArrays[0][0][0].pushBack(1);
        testMe.m_lotsOfArrays[0][0][0].pushBack(2);
        testMe.m_lotsOfArrays[0][0][0].pushBack(3);
        testMe.m_lotsOfArrays[0][0][1].pushBack(4);
        testMe.m_lotsOfArrays[0][0][1].pushBack(5);

        testMe.m_lotsOfArrays[0][1].expandOne();
        testMe.m_lotsOfArrays[0][1].expandOne();

        testMe.m_lotsOfArrays[0][1][0].pushBack(6);
        testMe.m_lotsOfArrays[0][1][1].pushBack(7);
        testMe.m_lotsOfArrays[0][1][1].pushBack(8);

        // hkArray< hkArray< hkArray<int> > >
        testMe.m_lotsOfArrays[1].expandOne();
        testMe.m_lotsOfArrays[1].expandOne();

        testMe.m_lotsOfArrays[1][0].expandOne();
        testMe.m_lotsOfArrays[1][0].expandOne();

        testMe.m_lotsOfArrays[1][0][0].pushBack(9);
        testMe.m_lotsOfArrays[1][0][1].pushBack(10);
        testMe.m_lotsOfArrays[1][0][1].pushBack(11);
        testMe.m_lotsOfArrays[1][0][1].pushBack(12);
        testMe.m_lotsOfArrays[1][0][1].pushBack(13);

        testMe.m_lotsOfArrays[1][1].expandOne();
        testMe.m_lotsOfArrays[1][1].expandOne();

        testMe.m_lotsOfArrays[1][1][0].pushBack(14);
        testMe.m_lotsOfArrays[1][1][1].pushBack(15);
        testMe.m_lotsOfArrays[1][1][1].pushBack(16);

        vc.addVar(&testMe);

        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1]));

        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][1]));

        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][0][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][0][1]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][1][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[0][1][1]));

        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][1]));

        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][0][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][0][1]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][1][0]));
        vc.addVarN(VarN_fromArray(testMe.m_lotsOfArrays[1][1][1]));
    }
}

template<class VERSIONANDCLONE>
void testTextArrayOfArray()
{
    using namespace TextDesc;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTextDescStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTextDescEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_TEXT_ARRAY_ARRAY
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_TEXT_ARRAY_ARRAY
    }

    VERSIONANDCLONE vc(patchReg, typeReg);
    SVTextDescStart testMe;
    initTextArray(testMe, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }

    // Test that we fail correctly when we don't want versioning to be carried out
    // TODO
    //outBundle = patcher.applyPatchesTo(&bundle, &typeReg, &patchReg, true);
    //HK_TEST(outBundle == HK_NULL);
}

template<class VERSIONANDCLONE>
void testTextArrayOfArrayPatchV2()
{
    using namespace TextDesc;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTextDescStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTextDescEnd>().get()));


    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_TEXT_ARRAY_ARRAY_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_TEXT_ARRAY_ARRAY_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    SVTextDescStart testMe;
    initTextArray(testMe, vc);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }

    
    
    
    
}

namespace SVDouble
{
    void SVDoubleStart_0_to_End_0(hkDataObject& obj)
    {
        hkVector4d vec = obj["dpVec"].asVector4d();

        // If this operation is not carried out in double precision, we will lose it due to underflow
        hkVector4d delta(0.0, 1.0e-12, 0.0, 0.0);
        vec.add(delta);

        obj["dpVec"] = vec;
    }

    void SVDoubleStart_0_to_End_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::ArrayVar av(obj["dpVec"]);

        // If this operation is not carried out in double precision, we will lose it due to underflow
        hkVector4d delta(0.0, 1.0e-12, 0.0, 0.0);

        for (int i = 0; i < 4; i++)
        {
            hkReflect::FloatVar fv(av[i]);
            fv.setValue(fv.getValue().m_value + delta(i));
        }
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVDoubleEnd* loaded = contents.dynCast<SVDoubleEnd>();
        if (HK_TEST(loaded))
        {
            HK_TEST_EQ(loaded->m_dpVec(0), 0.0);
            HK_TEST_EQ(loaded->m_dpVec(1), 1.000000000001);
            HK_TEST_EQ(loaded->m_dpVec(2), 2.0);
            HK_TEST_EQ(loaded->m_dpVec(3), 3.0);
            HK_TEST_EQ(loaded->m_dpVec2(0), -2.0);
            HK_TEST_EQ(loaded->m_dpVec2(1), 123456);
            HK_TEST_EQ(loaded->m_dpVec2(2), -4.75);
            HK_TEST_EQ(loaded->m_dpVec2.getInt24W(), 500);
        }

        if (needToDeleteOutput)
        {
            delete loaded;
        }
    }
}

template<class VERSIONANDCLONE>
void testDoublePrecision()
{
    using namespace SVDouble;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleEnd>().get()));

    SVDoubleStart st;
    st.m_dpVec.set(0.0, 1.0, 2.0, 3.0);
    st.m_spVec.set(-2.0, 123456, -4.75);
    st.m_spVec.setInt24W(500);


    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DOUBLE_PRECISION
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_DOUBLE_PRECISION
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    vc.addVar(&st);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testDoublePrecisionPatchV2()
{
    using namespace SVDouble;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleEnd>().get()));

    SVDoubleStart st;
    st.m_dpVec.set(0.0, 1.0, 2.0, 3.0);
    st.m_spVec.set(-2.0, 123456, -4.75);
    st.m_spVec.setInt24W(500);


    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DOUBLE_PRECISION_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_DOUBLE_PRECISION_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    vc.addVar(&st);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

namespace CombineTrack
{
    void SVCombineTrackA_Alt_float_to_int(hkDataObject& obj)
    {
        obj["intVal"] = int(obj["floatVal"].asReal());
    }


    void SVCombineTrackA_Alt_copy_int_val(hkDataObject& obj)
    {
        obj["copiedIntVal"] = obj["intVal"].asInt();
    }

    void SVCombineTrackA_Alt_float_to_int_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::IntVar(obj["intVal"]).setValue(int(hkReflect::FloatVar(obj["floatVal"]).getValue().m_value));
    }

    void SVCombineTrackA_Alt_copy_int_val_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::IntVar(obj["copiedIntVal"]).setValue(hkReflect::IntVar(obj["intVal"]).getValue());
    }

    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVCombineTrackB* versioningEnd = contents.dynCast<SVCombineTrackB>();
        if (HK_TEST(versioningEnd))
        {
            HK_TEST(versioningEnd->m_intVal == 2);
            HK_TEST(versioningEnd->m_copiedIntVal == 2);
            if (HK_TEST(versioningEnd->m_next.val()))
            {
                if (SVCombineTrackB* nextObj = hkDynCast<SVCombineTrackB>(versioningEnd->m_next))
                {
                    HK_TEST(nextObj->m_intVal == 3);
                    HK_TEST(nextObj->m_copiedIntVal == 3);
                    HK_TEST(nextObj->m_next.val() == 0);
                }
            }
            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }
    }

    template<class VERSIONANDCLONE>
    void initCombineTrack(hkRefPtr<SVCombineTrackA>& startA, hkRefPtr<SVCombineTrackA_Alt>& startB, VERSIONANDCLONE& vc)
    {
        startA = hkAutoRemoveReference(new SVCombineTrackA);
        startB = hkAutoRemoveReference(new SVCombineTrackA_Alt);
        startA->m_intVal = 2;
        startB->m_floatVal = 3.0f;
        startA->m_next = startB;

        vc.template addType<SVCombineTrackBase>();

        vc.addVar(startA.val());
        vc.addVar(startB.val());
    }
}

template<class VERSIONANDCLONE>
void testCombineTracking()
{
    using namespace CombineTrack;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackBase>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackA>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackA_Alt>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackB>().get()));

    {
        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TRACK_COMBINE
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_TRACK_COMBINE
        }

        VERSIONANDCLONE vc(patchReg, typeReg);
        hkRefPtr<SVCombineTrackA> startA;
        hkRefPtr<SVCombineTrackA_Alt> startB;
        initCombineTrack(startA, startB, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            testContents(contents, vc.needToDeleteOutput());
        }
    }
}

template<class VERSIONANDCLONE>
void testCombineTrackingPatchV2()
{
    using namespace CombineTrack;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackBase>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackA>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackA_Alt>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackB>().get()));
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVCombineTrackA_int>().get()));

    {
        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TRACK_COMBINE_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_TRACK_COMBINE_NEW
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        hkRefPtr<SVCombineTrackA> startA;
        hkRefPtr<SVCombineTrackA_Alt> startB;
        initCombineTrack(startA, startB, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            testContents(contents, vc.needToDeleteOutput());
        }
    }
}

namespace BacklinkTrack
{
    void SVBacklinkStart_0_to_End_0(hkDataObject& obj)
    {
        hkDataObject next = obj["nextObject"].asObject();
        next["embedA"].asObject()["a"] = obj["nest"];
        obj["embedA"] = next["embedA"];
    }

    void SVBacklinkLinkedStart_0_to_End_0(hkDataObject& obj)
    {
        hkDataObject embedB = obj["embedB"].asObject();
        // Link A and B
        obj["embedA"] = embedB;
        embedB["a"] = obj["nest"].asObject();
        embedB["b"] = embedB["a"].asObject();
    }

    void SVBacklinkContainerArrayStart_0_to_End_0(hkDataObject& obj)
    {
        hkDataArray links(obj["links"].asArray());
        // Should cause a reallocation
        links.setSize(4);
    }

    void SVBacklinkStart_0_to_End_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::PointerVar next(obj["nextObject"]);
        if (!next.isNull())
        {
            hkReflect::RecordVar pointedTo(next.getValue());
            hkReflect::RecordVar(pointedTo["embedA"])["a"].assign(obj["nest"]);
            hkReflect::RecordVar(obj["embedA"]).assign(pointedTo["embedA"]);
        }
    }

    void SVBacklinkLinkedStart_0_to_End_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::RecordVar embedB(obj["embedB"]);
        // Link A and B
        hkReflect::RecordVar(obj["embedA"]).assign(embedB);
        embedB["a"].assign(obj["nest"]);
        embedB["b"].assign(embedB["a"]);
    }

    void SVBacklinkContainerArrayStart_0_to_End_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::ArrayVar links(obj["links"]);
        // Should cause a reallocation
        links.setArraySize(4);
    }

    template<class VERSIONANDCLONE>
    void initFirstBacklinkTest(SVBacklinkLinkedStart& st, VERSIONANDCLONE& vc)
    {
        st.m_nest.m_value = -250; // Everything should get set to this
        st.m_embedA.m_a.m_value = 1;
        st.m_embedA.m_b.m_value = 2;
        st.m_embedB.m_a.m_value = 3;
        st.m_embedB.m_b.m_value = 4;

        vc.addVar(&st);

        vc.template addType<SVBackLinkEmbedded>();
        vc.template addType<SVBackLinkEmbeddedNested>();
    }

    template<class VERSIONANDCLONE>
    void initSecondBacklinkTest(SVBacklinkStart& st1, SVBacklinkLinkedStart& st2, VERSIONANDCLONE& vc)
    {
        st1.m_nest.m_value = -250; // embedA should get set to this
        st1.m_embedA.m_a.m_value = 1;
        st1.m_embedA.m_b.m_value = 2;
        st1.m_embedB.m_a.m_value = 3;
        st1.m_embedB.m_b.m_value = 4;
        st1.m_nextObject = &st2;
        st2.m_nest.m_value = -7; // Everything should get set to this
        st2.m_embedA.m_a.m_value = 77;
        st2.m_embedA.m_b.m_value = 777;
        st2.m_embedB.m_a.m_value = 7777;
        st2.m_embedB.m_b.m_value = 77777;

        vc.addVar(&st1);
        vc.addVar(&st2);

        vc.template addType<SVBackLinkEmbedded>();
        vc.template addType<SVBackLinkEmbeddedNested>();
    }

    template<class VERSIONANDCLONE>
    void initThirdBacklinkTest(SVBacklinkContainerArrayStart& st1, VERSIONANDCLONE& vc)
    {
        st1.m_links.setSize(2);
        st1.m_links[0].m_nest.m_value = -250; // Everything should get set to this
        st1.m_links[0].m_embedA.m_a.m_value = 1;
        st1.m_links[0].m_embedA.m_b.m_value = 2;
        st1.m_links[0].m_embedB.m_a.m_value = 3;
        st1.m_links[0].m_embedB.m_b.m_value = 4;

        st1.m_links[1].m_nest.m_value = -7; // Everything should get set to this
        st1.m_links[1].m_embedA.m_a.m_value = 77;
        st1.m_links[1].m_embedA.m_b.m_value = 777;
        st1.m_links[1].m_embedB.m_a.m_value = 7777;
        st1.m_links[1].m_embedB.m_b.m_value = 77777;

        vc.addVar(&st1);
        vc.addVarN(VarN_fromArray(st1.m_links));

        vc.template addType<SVBackLinkEmbedded>();
        vc.template addType<SVBackLinkEmbeddedNested>();
    }
}

template<class VERSIONANDCLONE>
void testBackLinkTracking()
{
    using namespace BacklinkTrack;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkLinkedStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkLinkedEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBackLinkEmbedded>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBackLinkEmbeddedNested>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_BACKLINK_TRACK
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_BACKLINK_TRACK
    }

    // Single object with internal dependencies, this will fail if the internal copying doesn't consider the order required
    if (1)
    {
        SVBacklinkLinkedStart st;

        VERSIONANDCLONE vc(patchReg, typeReg);
        initFirstBacklinkTest(st, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkLinkedEnd* versioningEnd = contents.dynCast<SVBacklinkLinkedEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_nest.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_a.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_b.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedB.m_a.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedB.m_b.m_value, -250);
            }

            if (vc.needToDeleteOutput())
            {
                delete versioningEnd;
            }
        }
    }

    // Two interdependent objects (copy per object can never resolve this)
    if (1)
    {
        SVBacklinkStart st1;
        SVBacklinkLinkedStart st2;

        VERSIONANDCLONE vc(patchReg, typeReg);
        initSecondBacklinkTest(st1, st2, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkEnd* versioningEnd = contents.dynCast<SVBacklinkEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_nest.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_a.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_b.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedB.m_a.m_value, 3);
                HK_TEST_EQ(versioningEnd->m_embedB.m_b.m_value, 4);

                SVBacklinkLinkedEnd* next = versioningEnd->m_nextObject;
                if (HK_TEST(next))
                {
                    HK_TEST_EQ(next->m_nest.m_value, -250);
                    HK_TEST_EQ(next->m_embedA.m_a.m_value, -250);
                    HK_TEST_EQ(next->m_embedA.m_b.m_value, -250);
                    HK_TEST_EQ(next->m_embedB.m_a.m_value, -250);
                    HK_TEST_EQ(next->m_embedB.m_b.m_value, -250);
                }
            }

            if (vc.needToDeleteOutput())
            {
                delete versioningEnd->m_nextObject;
                delete versioningEnd;
            }
        }
    }

    // Objects in an array (check we correctly patch objects in an array that later gets reallocated)
    if (1)
    {
        SVBacklinkContainerArrayStart st1;
        VERSIONANDCLONE vc(patchReg, typeReg);

        initThirdBacklinkTest(st1, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkContainerArrayEnd* versioningEnd = contents.dynCast<SVBacklinkContainerArrayEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_links.getSize(), 4);

                if (versioningEnd->m_links.getSize() > 0)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[0];
                    HK_TEST_EQ(link.m_nest.m_value, -250);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, -250);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, -250);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, -250);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, -250);
                }
                if (versioningEnd->m_links.getSize() > 1)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[1];
                    HK_TEST_EQ(link.m_nest.m_value, -7);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, -7);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, -7);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, -7);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, -7);
                }
                if (versioningEnd->m_links.getSize() > 2)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[2];
                    HK_TEST_EQ(link.m_nest.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, 0);
                }
                if (versioningEnd->m_links.getSize() > 3)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[3];
                    HK_TEST_EQ(link.m_nest.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, 0);
                }
            }
            if (vc.needToDeleteOutput())
            {
                delete versioningEnd;
            }
        }
    }
}

template<class VERSIONANDCLONE>
void testBackLinkTrackingPatchV2()
{
    using namespace BacklinkTrack;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkLinkedStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBacklinkLinkedEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBackLinkEmbedded>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVBackLinkEmbeddedNested>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_BACKLINK_TRACK_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_BACKLINK_TRACK_NEW
    }

    // Single object with internal dependencies, this will fail if the internal copying doesn't consider the order required
    if (1)
    {
        SVBacklinkLinkedStart st;

        VERSIONANDCLONE vc(patchReg, typeReg);
        initFirstBacklinkTest(st, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkLinkedEnd* versioningEnd = contents.dynCast<SVBacklinkLinkedEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_nest.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_a.m_value, 3);
                HK_TEST_EQ(versioningEnd->m_embedA.m_b.m_value, 4);
                HK_TEST_EQ(versioningEnd->m_embedB.m_a.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedB.m_b.m_value, -250);
            }

            if (vc.needToDeleteOutput())
            {
                delete versioningEnd;
            }
        }
    }

    // Two interdependent objects (copy per object can never resolve this)
    if (1)
    {
        SVBacklinkStart st1;
        SVBacklinkLinkedStart st2;

        VERSIONANDCLONE vc(patchReg, typeReg);
        initSecondBacklinkTest(st1, st2, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkEnd* versioningEnd = contents.dynCast<SVBacklinkEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_nest.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_a.m_value, -250);
                HK_TEST_EQ(versioningEnd->m_embedA.m_b.m_value, 77777);
                HK_TEST_EQ(versioningEnd->m_embedB.m_a.m_value, 3);
                HK_TEST_EQ(versioningEnd->m_embedB.m_b.m_value, 4);

                SVBacklinkLinkedEnd* next = versioningEnd->m_nextObject;
                if (HK_TEST(next))
                {
                    HK_TEST_EQ(next->m_nest.m_value, -7);
                    HK_TEST_EQ(next->m_embedA.m_a.m_value, -250);
                    HK_TEST_EQ(next->m_embedA.m_b.m_value, 77777);
                    HK_TEST_EQ(next->m_embedB.m_a.m_value, -7);
                    HK_TEST_EQ(next->m_embedB.m_b.m_value, -7);

                }
            }

            if (vc.needToDeleteOutput())
            {
                delete versioningEnd->m_nextObject;
                delete versioningEnd;
            }
        }
    }

    // Objects in an array (check we correctly patch objects in an array that later gets reallocated)
    if (1)
    {
        SVBacklinkContainerArrayStart st1;

        VERSIONANDCLONE vc(patchReg, typeReg);
        initThirdBacklinkTest(st1, vc);

        if (hkReflect::Var contents = vc.apply())
        {
            const SVBacklinkContainerArrayEnd* versioningEnd = contents.dynCast<SVBacklinkContainerArrayEnd>();
            if (HK_TEST(versioningEnd))
            {
                HK_TEST_EQ(versioningEnd->m_links.getSize(), 4);

                if (versioningEnd->m_links.getSize() > 0)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[0];
                    HK_TEST_EQ(link.m_nest.m_value, -250);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 3);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 4);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, -250);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, -250);
                }
                if (versioningEnd->m_links.getSize() > 1)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[1];
                    HK_TEST_EQ(link.m_nest.m_value, -7);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 7777);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 77777);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, -7);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, -7);
                }
                if (versioningEnd->m_links.getSize() > 2)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[2];
                    HK_TEST_EQ(link.m_nest.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, 0);
                }
                if (versioningEnd->m_links.getSize() > 3)
                {
                    const SVBacklinkLinkedEnd& link = versioningEnd->m_links[3];
                    HK_TEST_EQ(link.m_nest.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedA.m_b.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_a.m_value, 0);
                    HK_TEST_EQ(link.m_embedB.m_b.m_value, 0);
                }
            }
            if (vc.needToDeleteOutput())
            {
                delete versioningEnd;
            }
        }
    }
}

namespace ReSave
{
    void testContents(hkReflect::Var contents, bool needToDeleteOutput)
    {
        const SVDoubleEnd* loaded = contents.dynCast<SVDoubleEnd>();
        if (HK_TEST(loaded))
        {
            HK_TEST_EQ(loaded->m_dpVec(0), 0.0);
            HK_TEST_EQ(loaded->m_dpVec(1), 1.000000000001);
            HK_TEST_EQ(loaded->m_dpVec(2), 2.0);
            HK_TEST_EQ(loaded->m_dpVec(3), 3.0);
            HK_TEST_EQ(loaded->m_dpVec2(0), -2.0);
            HK_TEST_EQ(loaded->m_dpVec2(1), 123456);
            HK_TEST_EQ(loaded->m_dpVec2(2), -4.75);
            HK_TEST_EQ(loaded->m_dpVec2.getInt24W(), 500);
        }

        hkString::memSet((void*)loaded, 0xf0, hkSizeOf(SVDoubleEnd));
        if (needToDeleteOutput)
        {
            delete loaded;
        }
    }
}

template<class VERSIONANDCLONE>
void testReSave()
{
    using namespace SVDouble;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleEnd>().get()));

    SVDoubleStart st;
    st.m_dpVec.set(0.0, 1.0, 2.0, 3.0);
    st.m_spVec.set(-2.0, 123456, -4.75);
    st.m_spVec.setInt24W(500);

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DOUBLE_PRECISION
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_DOUBLE_PRECISION
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    vc.addVar(&st);

    hkReflect::Var contents;
    if ((contents = vc.apply()))
    {
        testContents(contents, vc.needToDeleteOutput());
    }
    vc.reset(); // Reset bundle, reuse patcher for simple case
    vc.addVar(&st);

    if ((contents = vc.apply()))
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

template<class VERSIONANDCLONE>
void testReSavePatchV2()
{
    using namespace SVDouble;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDoubleEnd>().get()));

    SVDoubleStart st;
    st.m_dpVec.set(0.0, 1.0, 2.0, 3.0);
    st.m_spVec.set(-2.0, 123456, -4.75);
    st.m_spVec.setInt24W(500);

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_DOUBLE_PRECISION_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_DOUBLE_PRECISION_NEW
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    vc.addVar(&st);

    hkReflect::Var contents;
    if ((contents = vc.apply()))
    {
        testContents(contents, vc.needToDeleteOutput());
    }
    vc.reset(); // Reset bundle, reuse patcher for simple case
    vc.addVar(&st);

    if ((contents = vc.apply()))
    {
        testContents(contents, vc.needToDeleteOutput());
    }
}

namespace Notes
{
    void init(SVHierarchyObjectStart& start)
    {
        start.m_count = 8;
        start.m_value = 1.0f;
    }

    void testSVOO(const SVHierarchyObjectEnd* end)
    {
        if (HK_TEST(end))
        {
            if (HK_TEST(end->m_values.getSize() == 8))
            {
                for (int i = 0; i < end->m_values.getSize(); i++)
                {
                    HK_TEST_EQ((float)end->m_values[i], 1.0f + 3.14f * i);
                }
            }
        }
    }

    void testNoteOnVersioned(hkReflect::Var contents, bool needToDeleteOutput, NoteMap& notes)
    {
        const SVSimpleEnd* versioningEnd = contents.dynCast<SVSimpleEnd>();
        if (HK_TEST(versioningEnd))
        {
            hkArray<hkReflect::Var> empty;
            auto& notesOnObj = notes.getWithDefault(contents, empty);
            if (HK_TEST_EQ(notesOnObj.getSize(), 3))
            {
                auto viNote = notesOnObj[0].dynCast<int>();
                if (HK_TEST(viNote))
                {
                    HK_TEST_EQ(*viNote, 42);
                }
                auto vsNote = notesOnObj[1].dynCast<hkStringPtr>();
                if (HK_TEST(vsNote))
                {
                    HK_TEST_EQ(*vsNote, "someNote");
                }
                auto vobjNote = notesOnObj[2].dynCast<SVDefaultTestClass>();
                Defaults::testDTS(vobjNote);
            }

            SVSimple::checkContents(contents, needToDeleteOutput);
        }
    }

    void testVersionedNote(hkReflect::Var contents, bool needToDeleteOutput, NoteMap& notes)
    {
        const SVDefaultTestClass* versioningEnd = contents.dynCast<SVDefaultTestClass>();
        if (HK_TEST(versioningEnd))
        {
            Defaults::testDTS(versioningEnd);

            hkArray<hkReflect::Var> empty;
            auto& notesOnObj = notes.getWithDefault(contents, empty);
            if (HK_TEST_EQ(notesOnObj.getSize(), 1))
            {
                auto versionedNote = notesOnObj[0].dynCast<SVHierarchyObjectEnd>();
                Notes::testSVOO(versionedNote);
            }

            if (needToDeleteOutput)
            {
                delete versioningEnd;
            }
        }

    }
}


template<class VERSIONANDCLONE>
static void testNotes()
{
    using namespace Notes;
    using namespace SVHierarchy;
    using namespace SVSimple;
    using namespace Defaults;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_SIMPLE_CHANGES
#define PATCHES_HIERARCHY
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_SIMPLE_CHANGES
#undef PATCHES_HIERARCHY
    }

    // Notes on versioned object
    {
        VERSIONANDCLONE vc(patchReg, typeReg);

        SVSimpleStart start; initSimple(start, vc);

        int iNote = 42;
        hkStringPtr sNote = "someNote";
        SVDefaultTestClass objNote; init(objNote);

        vc.addNote(&start, &iNote);
        vc.addNote(&start, &sNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            NoteMap notes; vc.getNotes(notes);
            testNoteOnVersioned(contents, vc.needToDeleteOutput(), notes);
        }
    }

    // Versioned note on object
    {
        SVDefaultTestClass start; init(start);

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&start);

        SVHierarchyObjectStart objNote; init(objNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            NoteMap notes; vc.getNotes(notes);
            testVersionedNote(contents, vc.needToDeleteOutput(), notes);
        }
    }

    // Versioned note on versioned object
    {
        VERSIONANDCLONE vc(patchReg, typeReg);

        SVSimpleStart start; initSimple(start, vc);

        SVHierarchyObjectStart objNote; init(objNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            auto versioningEnd = contents.dynCast<SVSimpleEnd>();
            if (HK_TEST(versioningEnd))
            {
                NoteMap notes; vc.getNotes(notes);
                hkArray<hkReflect::Var> empty;
                auto& notesOnObj = notes.getWithDefault(contents, empty);
                if (HK_TEST_EQ(notesOnObj.getSize(), 1))
                {
                    auto versionedNote = notesOnObj[0].dynCast<SVHierarchyObjectEnd>();
                    testSVOO(versionedNote);
                }
            }

            checkContents(contents, vc.needToDeleteOutput());
        }
    }
}

#if 0
template<class VERSIONANDCLONE>
static void testNotesPatchV2()
{
    using namespace Notes;
    using namespace SVHierarchy;
    using namespace SVSimple;
    using namespace Defaults;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVHierarchyObjectEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_SIMPLE_CHANGES_NEW
#define PATCHES_HIERARCHY_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_SIMPLE_CHANGES_NEW
#undef PATCHES_HIERARCHY_NEW
    }

    // Notes on versioned object
    {
        SVSimpleStart start; init(start);

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&start);

        int iNote = 42;
        hkStringPtr sNote = "someNote";
        SVDefaultTestClass objNote; init(objNote);

        vc.addNote(&start, &iNote);
        vc.addNote(&start, &sNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            NoteMap notes; vc.getNotes(notes);
            testNoteOnVersioned(contents, vc.needToDeleteOutput(), notes);
        }
    }

    // Versioned note on object
    {
        SVDefaultTestClass start; init(start);

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&start);

        SVHierarchyObjectStart objNote; init(objNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            NoteMap notes; vc.getNotes(notes);
            testVersionedNote(contents, vc.needToDeleteOutput(), notes);
        }
    }

    // Versioned note on versioned object
    {
        SVSimpleStart start; init(start);

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&start);

        SVHierarchyObjectStart objNote; init(objNote);
        vc.addNote(&start, &objNote);

        if (hkReflect::Var contents = vc.apply())
        {
            auto versioningEnd = contents.dynCast<SVSimpleEnd>();
            if (HK_TEST(versioningEnd))
            {
                NoteMap notes; vc.getNotes(notes);
                hkArray<hkReflect::Var> empty;
                auto& notesOnObj = notes.getWithDefault(contents, empty);
                if (HK_TEST_EQ(notesOnObj.getSize(), 1))
                {
                    auto versionedNote = notesOnObj[0].dynCast<SVHierarchyObjectEnd>();
                    testSVOO(versionedNote);
                }
            }

            checkContents(contents, vc.needToDeleteOutput());
        }
    }
}
#endif
namespace Imports
{
    void SVImportsStart_0_to_SVImportsEnd_0(hkDataObject& obj)
    {
        hkDataObject imported2 = obj["imported2"].asObject();
        hkDataArray mixed = obj["mixed"].asArray();
        hkDataArray imported2End = obj["imported2End"].asArray();
        imported2End.setSize(1 + mixed.getSize());
        imported2End[0] = imported2;
        for (int i = 0; i < mixed.getSize(); ++i)
        {
            imported2End[1 + i] = mixed[i].asObject()["ptr"];
        }
    }

    void SVImportsStart_0_to_SVImportsEnd_0_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var imported2 = hkReflect::PointerVar(obj["imported2"]).getValue();
        hkReflect::ArrayVar mixed(obj["mixed"]);
        hkReflect::ArrayVar imported2End(obj["imported2End"]);

        imported2End.setArraySize(1 + mixed.getCount());
        hkReflect::PointerVar(imported2End[0]).setValue(imported2);
        for (int i = 0; i < mixed.getCount(); ++i)
        {
            // Could just use = ??
            hkReflect::PointerVar(imported2End[1 + i]).setValue(hkReflect::PointerVar(mixed[i]["ptr"]).getValue());
        }
    }
    void testContents(hkReflect::Var contents, bool needToDeleteOutput, SVDefaultTestClass& import1, SVHierarchyObjectEnd* import2, SVHierarchyObjectEnd* import3, SVHierarchyObjectEnd* toClone, SVImportsStart& start, SVImportsBackPtr* backPtr)
    {
        auto end = hkDynCast<SVImportsEnd>(contents);
        if (HK_TEST(end))
        {
            Defaults::testDTS(end->normalEnd);
            HK_TEST_EQ(end->imported1End, &import1);
            if (HK_TEST(end->imported2End.getSize() == 3))
            {
                HK_TEST_EQ(end->imported2End[0], import2);
                HK_TEST_EQ(end->imported2End[1], import3);
                auto cloned = hkDynCast<SVHierarchyObjectEnd>(end->imported2End[2]);
                if (HK_TEST(cloned))
                {
                    HK_TEST(cloned != toClone);
                    HK_TEST(*cloned == *toClone);
                }
            }
            auto unchangedEnd = end->unchanged;
            if (HK_TEST(unchangedEnd))
            {
                HK_TEST(unchangedEnd != start.unchanged);
                if (HK_TEST(end->imported2End.getSize() == 3))
                {
                    HK_TEST_EQ(unchangedEnd->m_containedObjectOne, end->imported2End[2]);
                }
                HK_TEST_EQ(unchangedEnd->m_containedObjectTwo, import3);
                auto backPtrEnd = hkDynCast<SVImportsBackPtr>(unchangedEnd->m_containedObjectThree);
                if (HK_TEST(backPtrEnd))
                {
                    HK_TEST(backPtrEnd != backPtr);
                    HK_TEST(hkDynCast<SVImportsEnd>(backPtrEnd->versioned) != HK_NULL);
                    HK_TEST_EQ(backPtrEnd->versioned.getAddress(), end);
                }
                HK_TEST_EQ(unchangedEnd->m_containedObjectFour, (void*)HK_NULL);
                if (HK_TEST_EQ(unchangedEnd->m_containedObjectsArray.getSize(), 3))
                {
                    HK_TEST_EQ(unchangedEnd->m_containedObjectsArray[0], import3);
                    HK_TEST_EQ(unchangedEnd->m_containedObjectsArray[1], (void*)HK_NULL);
                    if (HK_TEST(end->imported2End.getSize() == 3))
                    {
                        HK_TEST_EQ(unchangedEnd->m_containedObjectsArray[2], end->imported2End[2]);
                    }
                }
            }
        }
    }
}

template<class VERSIONANDCLONE>
static void testImports()
{
    using namespace Imports;
    using namespace Defaults;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVImportsStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVImportsEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_IMPORTS
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_IMPORTS
    }

    SVImportsStart start;

    SVDefaultTestClass normal;
    init(normal);
    start.normal = &normal;

    SVDefaultTestClass import1;
    start.imported1 = &import1;

    hkRefPtr<SVHierarchyObjectEnd> import2(hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd));
    start.imported2 = import2;

    // This will be imported
    hkRefPtr<SVHierarchyObjectEnd> import3 = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);
    start.mixed.pushBack(import3);

    // This will be cloned
    hkRefPtr<SVHierarchyObjectEnd> toClone = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);
    for (int i = 0; i < 10; ++i)
    {
        toClone->m_values.pushBack(i);
    }
    start.mixed.pushBack(toClone);

    // This will be discarded
    hkRefPtr<SVHierarchyObjectEnd> discarded = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);

    // This will not be patched, but the pointed object will change
    hkRefPtr<SVImportsBackPtr> backPtr = hkRefNew<SVImportsBackPtr>(new SVImportsBackPtr);
    backPtr->versioned = &start;

    SVRemovedObjectsOwnerStart unchanged;
    unchanged.m_containedObjectOne = toClone;
    unchanged.m_containedObjectTwo = import3;
    unchanged.m_containedObjectThree = backPtr;
    unchanged.m_containedObjectFour = discarded;
    unchanged.m_containedObjectsArray.pushBack(import3);
    unchanged.m_containedObjectsArray.pushBack(discarded);
    unchanged.m_containedObjectsArray.pushBack(toClone);
    start.unchanged = &unchanged;

    VERSIONANDCLONE vc(patchReg, typeReg);
    vc.addImport(&import1, "Import1");
    vc.addImport(import2.val(), "Import2");
    vc.addImport(import3.val(), "Import3");
    vc.addImport(discarded.val(), HK_NULL);
    vc.addVar(&start);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput(), import1, import2, import3, toClone, start, backPtr);
    }
}

template<class VERSIONANDCLONE>
static void testImportsPatchV2()
{
    using namespace Imports;
    using namespace Defaults;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVImportsStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVImportsEnd>().get()));

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_IMPORTS_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_IMPORTS_NEW
    }

    SVImportsStart start;

    SVDefaultTestClass normal;
    init(normal);
    start.normal = &normal;

    SVDefaultTestClass import1;
    start.imported1 = &import1;

    hkRefPtr<SVHierarchyObjectEnd> import2(hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd));
    start.imported2 = import2;

    // This will be imported
    hkRefPtr<SVHierarchyObjectEnd> import3 = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);
    start.mixed.pushBack(import3);

    // This will be cloned
    hkRefPtr<SVHierarchyObjectEnd> toClone = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);
    for (int i = 0; i < 10; ++i)
    {
        toClone->m_values.pushBack(i);
    }
    start.mixed.pushBack(toClone);

    // This will be discarded
    hkRefPtr<SVHierarchyObjectEnd> discarded = hkRefNew<SVHierarchyObjectEnd>(new SVHierarchyObjectEnd);

    // This will not be patched, but the pointed object will change
    hkRefPtr<SVImportsBackPtr> backPtr = hkRefNew<SVImportsBackPtr>(new SVImportsBackPtr);
    backPtr->versioned = &start;

    SVRemovedObjectsOwnerStart unchanged;
    unchanged.m_containedObjectOne = toClone;
    unchanged.m_containedObjectTwo = import3;
    unchanged.m_containedObjectThree = backPtr;
    unchanged.m_containedObjectFour = discarded;
    unchanged.m_containedObjectsArray.pushBack(import3);
    unchanged.m_containedObjectsArray.pushBack(discarded);
    unchanged.m_containedObjectsArray.pushBack(toClone);
    start.unchanged = &unchanged;

    VERSIONANDCLONE vc(patchReg, typeReg);
    vc.addImport(&import1, "Import1");
    vc.addImport(import2.val(), "Import2");
    vc.addImport(import3.val(), "Import3");
    vc.addImport(discarded.val(), HK_NULL);
    vc.addVar(&start);

    if (hkReflect::Var contents = vc.apply())
    {
        testContents(contents, vc.needToDeleteOutput(), import1, import2, import3, toClone, start, backPtr);
    }
}

class SimpleNoteHandler : public hkSerialize::NoteHandler
{
public:

    SimpleNoteHandler(const VarFromName* exports = HK_NULL) : m_exports(exports) {}

    virtual void addNotes(const hkArrayView<hkReflect::Var>& notes, hkReflect::Var& dst, hkReflect::Var& src) HK_OVERRIDE
    {
        auto& objNotes = m_notesOut.getOrInsertKey(dst, hkArray<hkReflect::Var>());
        objNotes.append(notes);
    }

    virtual bool atPointerNote(const hkReflect::Var& note, hkReflect::PointerVar& dst, hkReflect::PointerVar& src) HK_OVERRIDE
    {
        if (m_exports)
        {
            if (auto import = hkDynCast<hkSerialize::Note::Import>(note))
            {
                if (hkReflect::Var exp = m_exports->getWithDefault(import->m_name, hkReflect::Var()))
                {
                    hkReflect::Detail::getPlain(dst).setValue(exp);
                    return false;
                }
            }
        }
        return true;
    }

    ~SimpleNoteHandler()
    {
        for (int i = 0; i < m_notesOut.viewItems().getSize(); ++i)
        {
            const hkArray<hkReflect::Var>& notes = m_notesOut.viewItems()[i].m_1;
            for (int n = 0; n < notes.getSize(); ++n)
            {
                hkReflect::Var(notes[n]).destroy();
            }
        }
    }

    NoteMap m_notesOut;
    const VarFromName* m_exports;
};


template<typename VERSIONANDCLONE>
void testTypeRef()
{
    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
        using namespace SVSimple;
#define PATCHES_SIMPLE_CHANGES
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>  
#   undef HK_PATCHES_FILE
#undef PATCHES_SIMPLE_CHANGES
    }

    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDefaultTestClass>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypeRef>().get()));

    SVTypeRef start;
    start.unchangedType = hkReflect::getType<SVDefaultTestClass>();
    start.changedType = hkReflect::getType<SVSimpleStart>();
    start.declInUnchangedType = hkReflect::DataFieldDecl(&SVDefaultTestClass::m_int);
    start.declInChangedType = hkReflect::DataFieldDecl(&SVSimpleStart::m_i_am_a_string);

    VERSIONANDCLONE vc(patchReg, typeReg);
    vc.addVar(&start);
    vc.addVar(hkReflect::Var(hkReflect::getType<SVDefaultTestClass>()));
    vc.addVar(hkReflect::Var(hkReflect::getType<SVSimpleStart>()));
    vc.addVar(hkReflect::Var(hkReflect::DataFieldDecl(&SVDefaultTestClass::m_int).getType()));
    vc.addVar(hkReflect::Var(hkReflect::DataFieldDecl(&SVSimpleStart::m_i_am_a_string).getType()));
    vc.addType(hkReflect::getType<SVDefaultTestClass>());
    vc.addType(hkReflect::getType<SVSimpleStart>());

    if (hkReflect::Var contents = vc.apply())
    {
        const SVTypeRef* versioned = hkDynCast(contents);
        if (HK_TEST(versioned))
        {
            HK_TEST_EQ(versioned->unchangedType, start.unchangedType);
            HK_TEST_EQ(versioned->changedType, hkReflect::getType<SVSimpleEnd>());
            HK_TEST_EQ(versioned->declInUnchangedType.getType(), start.declInUnchangedType.getType());
            HK_TEST_EQ(versioned->declInChangedType.getType(), hkReflect::DataFieldDecl(&SVSimpleEnd::m_i_am_a_string).getType());

            if (vc.needToDeleteOutput())
            {
                delete versioned;
            }
        }
    }
}


template<class VERSIONANDCLONE>
void testTypePointersPatchV2()
{
    if(VERSIONANDCLONE::SupportsFieldReferences)
    {
        ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

        typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVDeletedType>().get()));
        typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVSimpleStart>().get()));
        typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTypePointersStart>().get()));

        SVTypePointersStart st;

        st.m_unchangedType = hkReflect::getType<SVDefaultTestClass>();
        st.m_typePointer = hkReflect::getType<SVSimpleStart>();
        st.m_typePointerToDeleted = hkReflect::getType<SVDeletedType>();
        st.m_declInUnchangedType = hkReflect::DataFieldDecl(&SVDefaultTestClass::m_int);
        st.m_declInChangedType = hkReflect::DataFieldDecl(&SVSimpleStart::m_i_am_a_string);
        st.m_declRenamed = hkReflect::DataFieldDecl(&SVSimpleStart::m_i_am_an_int);
        st.m_fieldDeclRemovedFromType = hkReflect::DataFieldDecl(&SVSimpleStart::m_i_am_a_bool);
        st.m_fieldDeclInRemovedType = hkReflect::DataFieldDecl(&SVDeletedType::m_value);
        st.m_nsDeclInUnchangedType = hkReflect::DataFieldDecl(&SVDefaultTestClass::m_nonSerialized);
        st.m_nsDeclInChangedType = hkReflect::DataFieldDecl(&SVSimpleStart::m_nonSerialized);
        st.m_nsDeclInRemovedType = hkReflect::DataFieldDecl(&SVDeletedType::m_nonSerialized);
        st.m_simple.m_selfPtr = nullptr;

        hkReflect::Version::PatchRegistry patchReg;
        {
            VersionTestPatchAdder man(patchReg);
#define PATCHES_TYPE_POINTERS_NEW
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_TYPE_POINTERS_NEW
        }

        VERSIONANDCLONE vc(patchReg, typeReg);

        vc.addVar(&st);
        vc.template addType<SVDefaultTestClass>();
        vc.template addType<SVTypePointersStart>();

        hkReflect::Var contents;
        if ((contents = vc.apply()))
        {
            const SVTypePointersEnd* loaded = contents.dynCast<SVTypePointersEnd>();
            if (HK_TEST(loaded))
            {
                HK_TEST_EQ(loaded->m_unchangedType, st.m_unchangedType);
                HK_TEST(loaded->m_typePointer->equals<SVSimpleEnd>());
                HK_TEST(loaded->m_typePointerToDeleted == HK_NULL);

                HK_TEST_EQ(loaded->m_declInUnchangedType.getType(), st.m_declInUnchangedType.getType());
                HK_TEST_EQ(loaded->m_declInChangedType.getType(), hkReflect::DataFieldDecl(&SVSimpleEnd::m_i_am_a_string).getType());
                HK_TEST_EQ(loaded->m_declRenamed.getType(), hkReflect::DataFieldDecl(&SVSimpleEnd::m_originalIntPlusTen).getType());
                HK_TEST(!loaded->m_fieldDeclRemovedFromType);
                HK_TEST(!loaded->m_fieldDeclInRemovedType);

                HK_TEST_EQ(loaded->m_nsDeclInUnchangedType.getType(), st.m_nsDeclInUnchangedType.getType());
                HK_TEST_EQ(loaded->m_nsDeclInChangedType.getType(), hkReflect::DataFieldDecl(&SVSimpleEnd::m_nonSerialized).getType());
                HK_TEST(!loaded->m_nsDeclInRemovedType);
            }

            if (vc.needToDeleteOutput())
            {
                delete loaded;
            }
        }
    }
}

namespace UnpatchedThing
{
    void SVContainerFnStart_End_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var newVar = helper.newObject("SVContainerFnThing");

        hkReflect::IntVar newVarInt(newVar["int"]);
        newVarInt.setValue(100);
        hkReflect::PointerVar(obj["ptr"]).setValue(newVar);
        hkReflect::StringVar(newVar["str"]).setValue("Added");
    }
}

template<class VERSIONANDCLONE>
void testUnpatchedThingInContainer()
{
    using namespace UnpatchedThing;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVContainerFnStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVContainerFnEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVContainerFnThing>().get()));

    SVContainerFnStart st;

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_UNPATCHED_TYPE_IN_FUNCTION
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_UNPATCHED_TYPE_IN_FUNCTION
    }

    VERSIONANDCLONE vc(patchReg, typeReg);

    vc.addVar(&st);
    vc.template addType<SVContainerFnStart>();

    hkReflect::Var contents;
    if ((contents = vc.apply()))
    {
        const SVContainerFnEnd* loaded = contents.dynCast<SVContainerFnEnd>();
        if (HK_TEST(loaded))
        {
            SVContainerFnThing* fnt = hkDynCast(loaded->m_ptr);
            if (HK_TEST(fnt))
            {
                HK_TEST(fnt->m_int == 100);
                HK_TEST(fnt->m_str.compareTo("Added") == 0);
            }
        }

        if (vc.needToDeleteOutput())
        {
            delete loaded;
        }
    }
}

namespace RemoveAtAndUnpatched
{
    void SVTestingRemoveAt_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var firstObjInArray(obj["objects"][0]);
        hkReflect::Var newObject(obj["firstObject"]);

        hkReflect::PointerVar(newObject["ptr"]).setValue(hkReflect::PointerVar(firstObjInArray["ptr"]).getValue());
        newObject["int"].assign(firstObjInArray["int"]);
        newObject["float"].assign(firstObjInArray["float"]);

        hkReflect::ArrayVar(obj["objects"]).removeAt(0);

        // Mix around some pointers in unversioned things
        hkReflect::PointerVar firstPtr(obj["objects"][0]["ptr"]);
        hkReflect::PointerVar secondPtr(obj["objects"][1]["ptr"]);
        hkReflect::Var valueFromFirst = firstPtr.getValue();
        hkReflect::Var valueFromSecond = secondPtr.getValue();

        hkReflect::PointerVar(valueFromFirst["anotherObject"]).setValue(valueFromSecond);
        hkReflect::PointerVar(valueFromSecond["anotherObject"]).setValue(valueFromFirst);

        firstPtr.setValue(valueFromSecond);
        secondPtr.setValue(valueFromFirst);
    }
}

template<class VERSIONANDCLONE>
void testRemoveAtAndAccessUnpatchedRecord()
{
    using namespace RemoveAtAndUnpatched;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTestingRemoveAtStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTestingRemoveAtEnd>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTestingRemoveAtObjectInArray>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVTestingRemoveObject>().get()));

    SVTestingRemoveAtStart st;

    st.m_objects.setSize(3);
    st.m_objects[0].m_ptr = hkRefNew<SVTestingRemoveObject>(new SVTestingRemoveObject);
    st.m_objects[0].m_ptr->m_id = -1;
    st.m_objects[0].m_float = -1.0f;
    st.m_objects[0].m_int = -1;

    st.m_objects[1].m_ptr = hkRefNew<SVTestingRemoveObject>(new SVTestingRemoveObject);
    st.m_objects[1].m_ptr->m_id = 1;
    st.m_objects[1].m_float = 1.0f;
    st.m_objects[1].m_int = 1;

    st.m_objects[2].m_ptr = hkRefNew<SVTestingRemoveObject>(new SVTestingRemoveObject);
    st.m_objects[2].m_ptr->m_id = 2;
    st.m_objects[2].m_float = 2.0f;
    st.m_objects[2].m_int = 2;

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_REMOVEAT_AND_UNPATCHED_ACCESS
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_REMOVEAT_AND_UNPATCHED_ACCESS
    }

    VERSIONANDCLONE vc(patchReg, typeReg);
    vc.addVar(&st);
    vc.addVar(st.m_objects[0].m_ptr.val());
    vc.addVar(st.m_objects[1].m_ptr.val());
    vc.addVar(st.m_objects[2].m_ptr.val());
    vc.addVarN(hkSerialize::VarN::fromArray(st.m_objects.begin(), hkReflect::getType<SVTestingRemoveAtObjectInArray>(), st.m_objects.getSize()));
    vc.template addType<SVTestingRemoveAtStart>();
    vc.template addType<SVTestingRemoveAtObjectInArray>();
    vc.template addType<SVTestingRemoveObject>();

    hkReflect::Var contents;
    if ((contents = vc.apply()))
    {
        const SVTestingRemoveAtEnd* loaded = contents.dynCast<SVTestingRemoveAtEnd>();
        if (HK_TEST(loaded))
        {
            if (HK_TEST(loaded->m_objects.getSize() > 0))
            {
                if (HK_TEST(loaded->m_objects[0].m_ptr))
                {
                    HK_TEST_EQ(loaded->m_objects[0].m_ptr->m_id, 2);
                    if (HK_TEST(loaded->m_objects[0].m_ptr->m_anotherObject))
                    {
                        HK_TEST_EQ(loaded->m_objects[0].m_ptr->m_anotherObject->m_id, 1);
                    }
                }
                HK_TEST_EQ(loaded->m_objects[0].m_int, 1);
                HK_TEST_EQ(loaded->m_objects[0].m_int, 1.0f);
            }
            if (HK_TEST(loaded->m_objects.getSize() > 1))
            {
                if (HK_TEST(loaded->m_objects[1].m_ptr))
                {
                    HK_TEST_EQ(loaded->m_objects[1].m_ptr->m_id, 1);
                    if (HK_TEST(loaded->m_objects[1].m_ptr->m_anotherObject))
                    {
                        HK_TEST_EQ(loaded->m_objects[1].m_ptr->m_anotherObject->m_id, 2);
                    }

                }
                HK_TEST_EQ(loaded->m_objects[1].m_int, 2);
                HK_TEST_EQ(loaded->m_objects[1].m_int, 2.0f);
            }

            HK_TEST(loaded->m_objects.getSize() == 2);

            if (HK_TEST(loaded->m_firstObject.m_ptr))
            {
                HK_TEST_EQ(loaded->m_firstObject.m_ptr->m_id, -1);
            }
            HK_TEST_EQ(loaded->m_firstObject.m_int, -1);
            HK_TEST_EQ(loaded->m_firstObject.m_int, -1.0f);
        }

        if (vc.needToDeleteOutput())
        {
            delete loaded;
        }
    }
}

namespace PatchedFieldInUnpatchedStruct
{
    void SVPatchedFieldInUnpatchedStructStart_to_End_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        int v = hkReflect::IntVar(obj["fieldInt"]).getValue().convertTo<int>();
        double vv = (double)v;
        hkReflect::FloatVar(obj["fieldFloat"]).setValue(vv);
    }
}

template<class VERSIONANDCLONE>
void testPatchedFieldInUnpatchedStructInContainer()
{
    using namespace PatchedFieldInUnpatchedStruct;
    ChainedTypeRegistry typeReg(hkReflect::getTypeReg());

    // We only register some of these, deliberately
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVPatchedFieldInUnpatchedStructStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVPatchedFieldInUnpatchedStructEnd>().get()));
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVUnpatchedStructStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVUnpatchedStruct>().get()));
    //typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVUnpatchedContainerStart>().get()));
    typeReg.add(const_cast<hkReflect::Type*>(hkReflect::getType<SVUnpatchedContainer>().get()));


    SVUnpatchedContainerStart st;
    st.m_arrayOfUnpatched.expandOne();
    st.m_arrayOfUnpatched.back().m_aField = 10;
    st.m_arrayOfUnpatched.back().m_patchedField.m_fieldInt = -4;
    st.m_arrayOfUnpatched.back().m_anotherField = 6543;

    hkReflect::Version::PatchRegistry patchReg;
    {
        VersionTestPatchAdder man(patchReg);
#define PATCHES_PATCHED_FIELD_UNPATCHED_STRUCT
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_PATCHED_FIELD_UNPATCHED_STRUCT
    }

    VERSIONANDCLONE vc(patchReg, typeReg);
    vc.addVar(&st);
    vc.addVarN(hkSerialize::VarN::fromArray(st.m_arrayOfUnpatched.begin(), hkReflect::getType<SVUnpatchedStructStart>(), st.m_arrayOfUnpatched.getSize()));

    vc.template addType<SVPatchedFieldInUnpatchedStructEnd>();
    vc.template addType<SVUnpatchedStruct>();
    vc.template addType<SVUnpatchedContainer>();

    hkReflect::Var contents;
    if ((contents = vc.apply()))
    {
        const SVUnpatchedContainer* loaded = contents.dynCast<SVUnpatchedContainer>();
        if (HK_TEST(loaded))
        {
            if (HK_TEST(loaded->m_arrayOfUnpatched.getSize() > 0))
            {
                HK_TEST_EQ(loaded->m_arrayOfUnpatched[0].m_aField, 10);
                HK_TEST_EQ(loaded->m_arrayOfUnpatched[0].m_patchedField.m_fieldFloat, -4.0f);
                HK_TEST_EQ(loaded->m_arrayOfUnpatched[0].m_anotherField, 6543);
            }

            HK_TEST_EQ(loaded->m_arrayOfUnpatched.getSize(), 1);
        }

        if (vc.needToDeleteOutput())
        {
            delete loaded;
        }
    }
}

class BundleVersionAndClone
{
public:
    enum { SupportsFieldReferences = 1 };
    BundleVersionAndClone(hkReflect::Version::PatchRegistry& patchReg, hkReflect::MutableTypeReg& typeReg) : m_patchReg(patchReg), m_typeReg(typeReg) {}

    void addVar(const hkReflect::Var& var)
    {
        bundle.addVar(var);
        addType(var.getType());
    }

    void addVarN(const hkSerialize::VarN& varn)
    {
        bundle.addVarN(varn);
        addType(varn.getType());
    }

    void addType(const hkReflect::Type* t)
    {
        bundle.addType(t);
    }

    void addNote(const hkReflect::Var& obj, const hkReflect::Var& note)
    {
        bundle.addNote(obj, note);
        addType(note.getType());
    }

    void reset()
    {
        bundle.clear();
    }

    template<typename T>
    void addType()
    {
        addType(hkReflect::getType<T>());
    }

    bool needToDeleteOutput() const { return true; }

    void getNotes(NoteMap& notesOut)
    {
        notesOut = m_nh.m_notesOut;
    }

    struct Callback : public hkSerialize::Detail::CloneToRegistered
    {
        Callback(hkReflect::TypeReg& typeReg, hkSerialize::Bundle& b, hkSerialize::NoteHandler& nh)
            : hkSerialize::Detail::CloneToRegistered(&typeReg), m_bundle(b), m_nh(nh), m_notesCallback(&typeReg) {}

        virtual hkResult beginVar(hkReflect::Var& dst, hkReflect::Var& src) HK_OVERRIDE
        {
            if (hkSerialize::Detail::CloneToRegistered::beginVar(dst, src).isFailure())
            {
                return HK_FAILURE;
            }

            hkArray<hkSerialize::Bundle::Item> items; m_bundle.getItems(items);
            for (int i = 0; i < items.getSize(); ++i)
            {
                auto& item = items[i];
                if (hkReflect::Var annotated = items[item.getAnnotated()].var())
                {
                    if (annotated.getAddress() == src.getAddress())
                    {
                        hkReflect::Var clone = hkReflect::Cloner().cloneVar(item.var(), m_notesCallback);
                        m_nh.addNotes(hkArrayViewT::fromSingleObject(clone), dst, src);
                    }
                }
            }
            return HK_SUCCESS;
        }

        hkSerialize::Bundle& m_bundle;
        hkSerialize::NoteHandler& m_nh;
        hkSerialize::Detail::CloneToRegistered m_notesCallback;
    };


    hkReflect::Var apply()
    {
        hkRefPtr<hkReflect::Version::PatcherInterface> patcher = hkReflect::Version::PatcherInterface::create();

        {
            hkViewPtr<hkSerialize::Bundle> outBundle1 = patcher->applyPatchesTo(&bundle, &m_typeReg, &m_patchReg);
            if (HK_TEST(outBundle1))
            {
                Callback callback(m_typeReg, *outBundle1, m_nh);
                if (hkReflect::Var contents = hkReflect::Cloner().cloneVar(outBundle1->getContents(), callback))
                {
                    return contents;
                }
            }
        }

        return hkReflect::Var();
    }

    AutoBundle bundle;
    hkReflect::Version::PatchRegistry& m_patchReg;
    hkReflect::MutableTypeReg& m_typeReg;
    SimpleNoteHandler m_nh;
};

template <class WRITEFORMAT>
class SerializeAndClone
{
public:
    // Tagfile formats don't support field references yet
    enum { SupportsFieldReferences = 0 };

    SerializeAndClone(hkReflect::Version::PatchRegistry& patchReg, hkReflect::TypeReg& typeReg)
        : m_patchReg(patchReg), m_typeReg(typeReg), m_nh(&m_exports)
    {
        m_patcher = hkReflect::Version::PatcherInterface::create(&m_patchReg);
    }

    ~SerializeAndClone()
    {

    }

    void addVar(const hkReflect::Var& var)
    {
        if (!m_contents.isValid())
        {
            m_contents = var;
        }
    }

    void addVarN(const hkSerialize::VarN& varn)
    {
    }

    void addType(const hkReflect::Type* t)
    {
    }

    void reset()
    {
        m_contents = hkReflect::Var();
    }

    template<typename T>
    void addType()
    {
    }

    void addNote(const hkReflect::Var& obj, const hkReflect::Var& note)
    {
        auto& notes = m_notes.getOrInsertKey(obj, hkArray<hkReflect::Var>());
        notes.pushBack(note);
    }

    void addImport(const hkReflect::Var& obj, const char* name)
    {
        if (name)
        {
            m_exports.insert(name, obj);
        }
        m_imports.insert(obj, name);
    }

    bool needToDeleteOutput() const { return false; }


    void getNotes(NoteMap& notesOut)
    {
        notesOut = m_nh.m_notesOut;
    }

    static void HK_CALL varCallback(const hkReflect::Var& var, BundleBuilder& bb, void* data)
    {
        SerializeAndClone* thisPtr = static_cast<SerializeAndClone*>(data);

        hkArray<hkReflect::Var> empty;
        auto& notes = thisPtr->m_notes.getWithDefault(var, empty);
        for (int i = 0; i < notes.getSize(); ++i)
        {
            auto& note = notes[i];
            bb.addNote(var, note);
        }
    }

    static hkReflect::Var HK_CALL ptrCallback(const hkReflect::PointerVar& ptr, BundleBuilder& bb, void* data)
    {
        SerializeAndClone* thisPtr = static_cast<SerializeAndClone*>(data);

        hkReflect::Var var = ptr.getValue();

        auto it = thisPtr->m_imports.findKey(var);

        if (thisPtr->m_imports.isValid(it))
        {
            if (const char* import = thisPtr->m_imports.getValue(it))
            {
                bb.addImport(var, import);
            }
            else
            {
                bb.addEmpty(var);
            }
        }
        return var;
    }

    hkReflect::Var apply()
    {
        hkArray<char> saveBuf;
        hkSerialize::Save().withFormat<WRITEFORMAT>().withCallbacks(this, &varCallback, &ptrCallback)
            .contentsVar(m_contents, &saveBuf);

        m_res = hkSerialize::Load().withTypeReg(&m_typeReg).withNoteHandler(&m_nh)
            .withVersioning(hkSerialize::Load::VERSIONING_DEFAULT, m_patcher).toOwnedResource(saveBuf.begin(), saveBuf.getSize());

        if (HK_TEST(m_res))
        {
            return m_res->getContents();
        }

        return hkReflect::Var();
    }

    hkReflect::Version::PatchRegistry& m_patchReg;
    hkReflect::TypeReg& m_typeReg;
    hkRefPtr<hkReflect::Version::PatcherInterface> m_patcher;
    hkReflect::Var m_contents;
    hkRefPtr<hkResource> m_res;
    NoteMap m_notes;
    SimpleNoteHandler m_nh;

    VarFromName m_exports;
    NameFromVar m_imports;
};


// Difficult to implement, should be covered by the other versions anyway
template<> void testImports<BundleVersionAndClone>() {}
template<> void testImportsPatchV2<BundleVersionAndClone>() {}

// Xml does not support type refs.
template<> void testTypeRef< SerializeAndClone<hkSerialize::XmlWriteFormat> >() {}
template<> void testTypePointersPatchV2< SerializeAndClone<hkSerialize::XmlWriteFormat> >() {}

// Only the rw bundle works for these due to some dodgy type manipulation required for the test
template<> void testPatchedFieldInUnpatchedStructInContainer<SerializeAndClone<hkSerialize::TagfileWriteFormat> >() {}
template<> void testPatchedFieldInUnpatchedStructInContainer<SerializeAndClone<hkSerialize::XmlWriteFormat> >() {}
#if defined(HK_BUILDING_WITH_ENGINE)
template<> void testPatchedFieldInUnpatchedStructInContainer<SerializeAndClone<UnitTest::OptionalWriteFormatWrapper<&hkSerialize::Detail::fileFormatYamlfile> > >() {}
#endif

template<class VERSIONANDCLONE>
int simpleVersioning_main_impl()
{
    testSimpleChanges<VERSIONANDCLONE>();
    testRenamedReadded<VERSIONANDCLONE>();
//      //////testHierarchy<VERSIONANDCLONE>(); // Disabling this, there is something wrong with it
    testRemovedObjects<VERSIONANDCLONE>();
    testDeletedType<VERSIONANDCLONE>();
    testHomogenousArray<VERSIONANDCLONE>();
    testOldNative<VERSIONANDCLONE>();
    testTypeCombine<VERSIONANDCLONE>();
    testCombineTracking<VERSIONANDCLONE>();
    testTextArrayOfArray<VERSIONANDCLONE>();
    testDoublePrecision<VERSIONANDCLONE>();
    testBackLinkTracking<VERSIONANDCLONE>();
    testReSave<VERSIONANDCLONE>();
    testNotes<VERSIONANDCLONE>();
    testImports<VERSIONANDCLONE>();
    testTypeRef<VERSIONANDCLONE>();

    testSimpleChangesPatchV2<VERSIONANDCLONE>();
    testRenamedReaddedPatchV2<VERSIONANDCLONE>();
    testRemovedObjectsPatchV2<VERSIONANDCLONE>();
    testDeletedTypePatchV2<VERSIONANDCLONE>();
    //testTypeRefV2<VERSIONANDCLONE>(); 
    testHomogenousArrayPatchV2<VERSIONANDCLONE>();
    testOldNativePatchV2<VERSIONANDCLONE>();
    testTypeCombinePatchV2<VERSIONANDCLONE>();
    testCombineTrackingPatchV2<VERSIONANDCLONE>();
    testTextArrayOfArrayPatchV2<VERSIONANDCLONE>();
    testDoublePrecisionPatchV2<VERSIONANDCLONE>();
    testBackLinkTrackingPatchV2<VERSIONANDCLONE>(); // The behaviour has changed here (different link tracking) -- test adjusted to match
    testReSavePatchV2<VERSIONANDCLONE>();

    testTypePointersPatchV2<VERSIONANDCLONE>(); // Only in V2
    //testNotesPatchV2<VERSIONANDCLONE>(); // Needs fix
    //testImportsPatchV2<VERSIONANDCLONE>(); // Also needs fix
    testUnpatchedThingInContainer<VERSIONANDCLONE>();
    testRemoveAtAndAccessUnpatchedRecord<VERSIONANDCLONE>();
    testPatchedFieldInUnpatchedStructInContainer<VERSIONANDCLONE>();

    return 0;
}

void testCantRegisterInvalidPatch()
{
    hkReflect::Version::PatchRegistry patchReg;

    // Patch registry starts empty
    HK_TEST_EQ(patchReg.getPatches().getSize(), 0);

    {
        UnitTest::Raii::CaptureThreadLogOutput logOutput; // This will generate Log_Errors
        // Use the default patch adder which should reject this patch
        hkReflect::Version::PatchAdder man(patchReg);
#define PATCHES_FROM_NATIVE_VERSION
#   define HK_PATCHES_FILE <Common/Compat/UnitTest/Version/SimpleVersioningTestPatches.cxx>
# include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx> 
#   undef HK_PATCHES_FILE
#undef PATCHES_FROM_NATIVE_VERSION
    }

    // Nothing should have been registered
    HK_TEST_EQ(patchReg.getPatches().getSize(), 0);
}


int simpleVersioning_main()
{
    testDefaults();
    simpleVersioning_main_impl<BundleVersionAndClone>();
    simpleVersioning_main_impl<SerializeAndClone<hkSerialize::TagfileWriteFormat> >();
    simpleVersioning_main_impl<SerializeAndClone<hkSerialize::XmlWriteFormat> >();
    //simpleVersioning_main_impl<SerializeAndClone<hkSerialize::TagfileWriteFormat2015> >(); // TODO What happened to this?
#if defined(HK_BUILDING_WITH_ENGINE)
    typedef UnitTest::OptionalWriteFormatWrapper<&hkSerialize::Detail::fileFormatYamlfile> YamlFormat;
    if (HK_TEST(YamlFormat::isAvailable()))
    {
        simpleVersioning_main_impl< SerializeAndClone<YamlFormat> >();
    }
#endif
    testCantRegisterInvalidPatch();
    return 0;
}
HK_TEST_REGISTER(simpleVersioning_main, "Fast", "Common/Test/UnitTest/Compat/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
