// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once
#include <Common/Base/Types/hkWeakPtr.h>

class SVSimpleStart
{
public:
    HK_DECLARE_CLASS(SVSimpleStart, New, Reflect);
    //HK_RECORD_ATTR(hk::RegisterType(false)); // This is the start type for versioning
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVSimpleStart() : m_nonSerialized(1.0) {}

    hkVector4f m_pos;
    int m_i_am_an_int;
    float m_i_am_a_float;
    double m_nonSerialized HK_ATTR(hk::Serialize(false));
    hkStringPtr m_i_am_a_string;
    class SVSimpleStart* m_selfPtr;
    hkBool m_i_am_a_bool;
    int m_i_will_become_a_true_bool;
    int m_i_will_become_a_false_bool;
};

class SVSimpleEnd
{
public:
    HK_DECLARE_CLASS(SVSimpleEnd, New, Reflect);
    //HK_RECORD_ATTR(hk::RegisterType(false)); // This is the end type for versioning
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVSimpleEnd() : m_nonSerialized(2.0) {}

    hkVector4f m_differentVector;
    hkStringPtr m_i_am_a_string;
    double m_nonSerialized HK_ATTR(hk::Serialize(false));
    float m_originalFloatDivedByTen;
    int m_originalIntPlusTen;
    int m_addedOriginalValue;
    hkVector4f m_pos;
    class SVSimpleEnd* m_selfPtr;
    hkBool m_i_will_become_a_true_bool;
    hkBool m_i_will_become_a_false_bool;
};

class SVRenameAddedEnd
{
public:
    HK_DECLARE_CLASS(SVRenameAddedEnd, New, Reflect, BypassCtor);
    //HK_RECORD_ATTR(hk::RegisterType(false)); // This is the start type for versioning
    HK_RECORD_ATTR(hk::Version(3));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVRenameAddedEnd() {}

    hkVector4f m_posRenamedOnce;
    hkVector4f m_posRenamedTwice;
    float m_i_am_a_floatRenamedOnce;
    hkStringPtr m_i_am_a_stringRenamedOnce;
    int m_i_am_an_intRenamedTwice;
    float m_i_am_a_floatRenamedTwice;
    hkStringPtr m_i_am_a_stringRenamedTwice;
    float m_i_am_a_float;
    hkStringPtr m_i_am_a_string;
    hkVector4f m_pos;
    int m_i_am_an_int;
    int m_i_am_an_intRenamedOnce;

    hkVector4 m_added_vec4;
    hkVector4 m_added_vec4_identity;
    hkTransform m_added_vec16;
    hkTransform m_added_vec16_identity;
};

class SVHierarchyObjectStart
{
public:
    HK_DECLARE_CLASS(SVHierarchyObjectStart, New, Reflect);
    //HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_count;
    float m_value;
};

class SVHierarchyObjectEnd : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVHierarchyObjectEnd, New, Reflect);
    HK_RECORD_ATTR(hk::Version(2));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    bool operator==(const SVHierarchyObjectEnd&) const;
    bool operator!=(const SVHierarchyObjectEnd&) const;

    hkArray<double> m_values;
};

class SVHierarchyOwnerStart
{
public:
    HK_DECLARE_CLASS(SVHierarchyOwnerStart, New, Reflect);
    //HK_RECORD_ATTR(hk::RegisterType(false)); // This is the start type for versioning
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_value;

    SVHierarchyObjectStart m_objA;
    SVHierarchyObjectStart m_objB;
    SVHierarchyObjectStart m_objC;
};

class SVHierarchyOwnerEnd : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVHierarchyOwnerEnd, New, Reflect);
    //HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::Version(2));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    int m_value;

    hkArray<hkRefPtr<SVHierarchyObjectEnd> > m_objs;
};

class SVRemovedObjectsOwnerStart
{
public:
    HK_DECLARE_CLASS(SVRemovedObjectsOwnerStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    //HK_RECORD_ATTR(hk::RegisterType(false));

    hkRefPtr<hkReferencedObject> m_containedObjectOne;
    hkRefPtr<hkReferencedObject> m_containedObjectTwo;
    hkRefPtr<hkReferencedObject> m_containedObjectThree;
    hkRefPtr<hkReferencedObject> m_containedObjectFour;
    hkArray<hkRefPtr< SVHierarchyObjectEnd> > m_containedObjectsArray;
};

class SVRemovedObjectsOwnerEnd
{
public:
    HK_DECLARE_CLASS(SVRemovedObjectsOwnerEnd, New, Reflect);
    HK_RECORD_ATTR(hk::Version(2));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<hkReferencedObject> m_containedObject; // was Three
};

class SVDeletedType
{
public:
    HK_DECLARE_CLASS(SVDeletedType, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    //HK_RECORD_ATTR(hk::RegisterType(false));

    int m_value;
    hkUint16 m_nonSerialized HK_ATTR(hk::Serialize(false));
};

class SVDeletedTypeOwnerStart : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVDeletedTypeOwnerStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    //HK_RECORD_ATTR(hk::RegisterType(false));

    int m_first;
    SVDeletedType m_a;
    SVDeletedType m_b;
    int m_second;
};

class SVDeletedTypeOwnerEnd : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVDeletedTypeOwnerEnd, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_second;
    int m_first;
};

class SVDeletedTypeContainerStart : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVDeletedTypeContainerStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    //HK_RECORD_ATTR(hk::RegisterType(false));

    hkRefPtr<SVDeletedTypeOwnerStart> m_obj;
    hkRefPtr<SVDeletedTypeContainerStart> m_next;
};

// We just need this to get the rename for the native type
class SVDeletedTypeContainerEnd : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVDeletedTypeContainerEnd, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<SVDeletedTypeOwnerEnd> m_obj;
    hkRefPtr<SVDeletedTypeContainerEnd> m_next;
};

struct SVHomogeneousArray
{
    static hkReflect::Detail::HomogeneousArrayImpl impl;

    HK_DECLARE_CLASS(SVHomogeneousArray, New, Reflect);
    HK_RECORD_ATTR(hk::ReflectAs(format = hkReflect::KIND_ARRAY, subtype = HK_NULL, impl = &SVHomogeneousArray::impl));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVHomogeneousArray() : elts(0), size(0), capacity(0), eltType(0) {}

    void* elts;
    hkInt32 size;
    hkInt32 capacity;
    const hkReflect::Type* eltType;
};

struct SVHomogeneousArrayContainerStart
{
    HK_DECLARE_CLASS(SVHomogeneousArrayContainerStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVHomogeneousArray m_array;
};

struct SVHomogeneousArrayContainerEnd
{
    HK_DECLARE_CLASS(SVHomogeneousArrayContainerEnd, New, Reflect);
    HK_RECORD_ATTR(hk::Version(1));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    float m_mem0;
};

struct SVDefaultTestClass
{
    HK_DECLARE_CLASS(SVDefaultTestClass, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    typedef int int100 HK_ATTR(hk::Default(100));
    typedef int plainint;

    int m_int25 HK_ATTR(hk::Default(25));
    plainint m_int; // no default
    int100 m_int100;
    int100 m_int999 HK_ATTR(hk::Default(999)); // override 100
    hkUint8 m_byte254 HK_ATTR(hk::Default(254));
    hkLong m_long HK_ATTR(hk::Default(-5));
    double m_nonSerialized HK_ATTR(hk::Serialize(false));
    hkStringPtr m_string HK_ATTR(hk::Default("someString"));
    hkVector4 m_vector HK_ATTR(hk::Default(1, 2, 3, 4));
};

HK_REFLECT_TYPEDEF(, SVDefaultTestClass::int100, SVDefaultTestClass_int100);

// Leaving these with the old declaration format to test
class SVSecondEmbedType
{
public:
    //+version(0)
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SVSecondEmbedType);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    unsigned m_emb_c;
    unsigned m_emb_d;

    class SVSecondVersioningTest* m_tnp;
};

class SVSecondVersioningTest
{
public:
    //+version(1)
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SVSecondVersioningTest);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    unsigned m_a;
    unsigned m_b;
    unsigned m_c;
    SVSecondEmbedType m_embed2;
    SVSecondEmbedType* m_embedPtr;
    hkStringPtr m_string;
    hkArray<hkStringPtr> m_stringArray;

    SVSecondVersioningTest() {}
};

class SVEmbedTypeFinal
{
public:
    //+version(2)
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, SVEmbedTypeFinal);
    HK_DECLARE_REFLECTION();
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_int; //+default(27)
    float m_real; //+default(-100)
};

class SVSecondEmbedTypeFinal
{
public:
    //+version(1)
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SVSecondEmbedTypeFinal);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    int m_emb_c; //+default(0xeecceecc)

    class SVSecondVersioningTestFinal* m_tnp;
};

class SVPatchParentFinal
{
public:
    //+version(0)
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SVPatchParentFinal);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    float m_mem; //+default(2.0)
};

class SVSecondVersioningTestFinal : public SVPatchParentFinal
{
public:
    //+version(4)
    HK_DECLARE_REFLECTION();
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, SVSecondVersioningTestFinal);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    int m_a; //+default(0xaaaaaaaa)
    SVEmbedTypeFinal m_embed[2];
    int m_e; //+default(0xeeeeeeee)
    int m_add_rem_add; //+default(0xaaddaadd)
    SVSecondEmbedTypeFinal m_embed2;
    SVSecondEmbedTypeFinal* m_embedPtr;
    hkStringPtr m_string;
    SVEmbedTypeFinal* m_ptr;
    hkArray<hkStringPtr> m_stringArray;

    int m_array[4];
    hkArray<SVEmbedTypeFinal> m_embedTypehkArray;
};


class SVTextDescStart
{
public:
    HK_DECLARE_CLASS(SVTextDescStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray< hkArray< hkArray< hkArray<int> > > > m_lotsOfArrays;
};

class SVTextDescEnd
{
public:
    HK_DECLARE_CLASS(SVTextDescEnd, Reflect, New);
    HK_RECORD_ATTR(hk::Version(1));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray< int > m_allTheInts;
};

//
// A0 -> A1 -> A2 -> C3
// B0 -> B1 ---/
//

class SVTypeCombineStartA
{
public:
    HK_DECLARE_CLASS(SVTypeCombineStartA, Reflect, New);
    HK_RECORD_ATTR(hk::Version(0));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkInt64 m_anInt;
    hkDouble64 m_aDouble;
};

class SVTypeCombineStartB
{
public:
    HK_DECLARE_CLASS(SVTypeCombineStartB, Reflect, New);
    HK_RECORD_ATTR(hk::Version(0));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkDouble64 m_aDouble;
    hkUint64 m_someInt;
};

class SVTypeCombineEndC
{
public:
    HK_DECLARE_CLASS(SVTypeCombineEndC, Reflect, New);
    HK_RECORD_ATTR(hk::Version(3));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray<hkUint32> m_stuff;
    float m_same;
    hkDouble64 m_aDouble;
};

class SVCombineTrackBase : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVCombineTrackBase, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<SVCombineTrackBase> m_next;
};
class SVCombineTrackA : public SVCombineTrackBase
{
public:
    HK_DECLARE_CLASS(SVCombineTrackA, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_intVal;
};

class SVCombineTrackA_Alt : public SVCombineTrackBase
{
public:
    HK_DECLARE_CLASS(SVCombineTrackA_Alt, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    float m_floatVal;
};

class SVCombineTrackB : public SVCombineTrackBase
{
public:
    HK_DECLARE_CLASS(SVCombineTrackB, Reflect, New);
    HK_RECORD_ATTR(hk::Version(1));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_intVal;
    int m_copiedIntVal;
};

class SVDoubleStart
{
public:
    HK_DECLARE_CLASS(SVDoubleStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkVector4d m_dpVec;
    hkVector4f m_spVec;
};

class SVDoubleEnd
{
public:
    HK_DECLARE_CLASS(SVDoubleEnd, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkVector4d m_dpVec;
    hkVector4d m_dpVec2;
};

class SVBackLinkEmbeddedNested
{
public:
    HK_DECLARE_CLASS(SVBackLinkEmbeddedNested, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_value;
};

class SVBackLinkEmbedded
{
public:
    HK_DECLARE_CLASS(SVBackLinkEmbedded, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVBackLinkEmbeddedNested m_a;
    SVBackLinkEmbeddedNested m_b;
};

class SVBacklinkLinkedStart
{
public:
    HK_DECLARE_CLASS(SVBacklinkLinkedStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVBackLinkEmbedded m_embedA;
    SVBackLinkEmbedded m_embedB;
    SVBackLinkEmbeddedNested m_nest;
};

class SVBacklinkLinkedEnd
{
public:
    HK_DECLARE_CLASS(SVBacklinkLinkedEnd, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVBackLinkEmbedded m_embedA;
    SVBackLinkEmbedded m_embedB;
    SVBackLinkEmbeddedNested m_nest;
};

class SVBacklinkStart
{
public:
    HK_DECLARE_CLASS(SVBacklinkStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVBackLinkEmbedded m_embedA;
    SVBackLinkEmbedded m_embedB;
    SVBackLinkEmbeddedNested m_nest;
    SVBacklinkLinkedStart* m_nextObject;
};

class SVBacklinkEnd
{
public:
    HK_DECLARE_CLASS(SVBacklinkEnd, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVBackLinkEmbedded m_embedA;
    SVBackLinkEmbedded m_embedB;
    SVBackLinkEmbeddedNested m_nest;
    SVBacklinkLinkedEnd* m_nextObject;
};

class SVBacklinkContainerArrayStart
{
public:
    HK_DECLARE_CLASS(SVBacklinkContainerArrayStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray<SVBacklinkLinkedStart> m_links;
};

class SVBacklinkContainerArrayEnd
{
public:
    HK_DECLARE_CLASS(SVBacklinkContainerArrayEnd, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray<SVBacklinkLinkedEnd> m_links;
};

class SVImportsStart
{
public:
    HK_DECLARE_CLASS(SVImportsStart, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVDefaultTestClass* normal;
    SVDefaultTestClass* imported1;
    hkRefPtr<hkReferencedObject> imported2;

    struct WithPointer
    {
        HK_DECLARE_CLASS(WithPointer, Reflect, New, EmptyCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        template<typename T> WithPointer(T refPtr) : m_ptr(refPtr) {}

        hkReferencedObject* val() const { return m_ptr.val(); }

        hkRefPtr<hkReferencedObject> m_ptr;
    };

    hkArray< WithPointer > mixed;
    SVRemovedObjectsOwnerStart* unchanged;
};

class SVImportsEnd
{
public:
    HK_DECLARE_CLASS(SVImportsEnd, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVDefaultTestClass* normalEnd;
    SVDefaultTestClass* imported1End;
    hkArray< hkRefPtr<hkReferencedObject> > imported2End;
    SVRemovedObjectsOwnerStart* unchanged;
};

class SVImportsBackPtr : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVImportsBackPtr, Reflect, New);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkReflect::Var versioned;
};

class SVTypePointersStart
{
public:
    HK_DECLARE_CLASS(SVTypePointersStart, Reflect, New, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVTypePointersStart() {}

    const hkReflect::Type* m_unchangedType;
    const hkReflect::Type* m_typePointer;
    const hkReflect::Type* m_typePointerToDeleted;
    hkReflect::FieldDecl m_declInUnchangedType;
    hkReflect::FieldDecl m_declInChangedType;
    hkReflect::FieldDecl m_declRenamed;
    hkReflect::FieldDecl m_fieldDeclRemovedFromType;
    hkReflect::FieldDecl m_fieldDeclInRemovedType;
    hkReflect::FieldDecl m_nsDeclInUnchangedType;
    hkReflect::FieldDecl m_nsDeclInChangedType;
    hkReflect::FieldDecl m_nsDeclInRemovedType;

    SVDeletedType m_willBeDeleted;
    SVSimpleStart m_simple;
};

class SVTypePointersEnd
{
public:
    HK_DECLARE_CLASS(SVTypePointersEnd, Reflect, New, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    const hkReflect::Type* m_unchangedType;
    const hkReflect::Type* m_typePointer;
    const hkReflect::Type* m_typePointerToDeleted;
    hkReflect::FieldDecl m_declInUnchangedType;
    hkReflect::FieldDecl m_declInChangedType;
    hkReflect::FieldDecl m_declRenamed;
    hkReflect::FieldDecl m_fieldDeclRemovedFromType;
    hkReflect::FieldDecl m_fieldDeclInRemovedType;
    hkReflect::FieldDecl m_nsDeclInUnchangedType;
    hkReflect::FieldDecl m_nsDeclInChangedType;
    hkReflect::FieldDecl m_nsDeclInRemovedType;

    SVSimpleEnd m_simple;
};


class SVTypeRef
{
public:
    HK_DECLARE_CLASS(SVTypeRef, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    const hkReflect::Type* unchangedType;
    const hkReflect::Type* changedType;
    hkReflect::FieldDecl declInUnchangedType;
    hkReflect::FieldDecl declInChangedType;

    
    // hkReflect::FieldDecl changedDecl;
};


class SVContainerFnThing : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVContainerFnThing, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    // Doesn't really matter what's in here but it should not be versioned
    int m_int;
    hkStringPtr m_str;
};

class SVContainerFnStart
{
public:
    HK_DECLARE_CLASS(SVContainerFnStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<hkReferencedObject> m_ptr;
};

class SVContainerFnEnd
{
public:
    HK_DECLARE_CLASS(SVContainerFnEnd, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<hkReferencedObject> m_ptr;
};


// Test RemoveAt in a patch and accessing unversioned things properly
class SVTestingRemoveObject : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(SVTestingRemoveObject, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_id;
    hkViewPtr<class SVTestingRemoveObject> m_anotherObject;
};

class SVTestingRemoveAtObjectInArray
{
public:
    HK_DECLARE_CLASS(SVTestingRemoveAtObjectInArray, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkRefPtr<SVTestingRemoveObject> m_ptr;
    int m_int;
    float m_float;
};

class SVTestingRemoveAtStart
{
public:
    HK_DECLARE_CLASS(SVTestingRemoveAtStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray<SVTestingRemoveAtObjectInArray> m_objects;
};

class SVTestingRemoveAtEnd
{
public:
    HK_DECLARE_CLASS(SVTestingRemoveAtEnd, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    SVTestingRemoveAtObjectInArray m_firstObject;
    hkArray<SVTestingRemoveAtObjectInArray> m_objects;
};


// These types do some strange manipulation to appear to have two versions of the same thing in the system

class SVPatchedFieldInUnpatchedStructStart
{
public:
    HK_DECLARE_CLASS(SVPatchedFieldInUnpatchedStructStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::Rename(SVPatchedFieldInUnpatchedStruct), hk::RegisterType(false));

    int m_fieldInt;
};

class SVPatchedFieldInUnpatchedStructEnd
{
public:
    HK_DECLARE_CLASS(SVPatchedFieldInUnpatchedStructEnd, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::Version(1), hk::Rename(SVPatchedFieldInUnpatchedStruct));

    float m_fieldFloat;
};


class SVUnpatchedStructStart
{
public:
    HK_DECLARE_CLASS(SVUnpatchedStructStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::Rename(SVUnpatchedStruct), hk::RegisterType(false));

    int m_aField;
    SVPatchedFieldInUnpatchedStructStart m_patchedField;
    int m_anotherField;
};

class SVUnpatchedStruct
{
public:
    HK_DECLARE_CLASS(SVUnpatchedStruct, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    int m_aField;
    SVPatchedFieldInUnpatchedStructEnd m_patchedField;
    int m_anotherField;
};

class SVUnpatchedContainerStart
{
public:
    HK_DECLARE_CLASS(SVUnpatchedContainerStart, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::Rename(SVUnpatchedContainer), hk::RegisterType(false));

    hkArray<SVUnpatchedStructStart> m_arrayOfUnpatched;
};

class SVUnpatchedContainer
{
public:
    HK_DECLARE_CLASS(SVUnpatchedContainer, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

    hkArray<SVUnpatchedStruct> m_arrayOfUnpatched;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
