// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// This file is #included from various places to register patches. It will instantiate the HK_PATCH_REGISTER_ACTION macro with the name
// of the patch handler function for each patch file that is to be included. Typically this is included into the middle of a function
// that will generate a call to each registration function, or else it is used to generate a static patch registry init node to do the
// global registration for a static build.

#if !defined(HK_SERIALIZE_MIN_COMPATIBLE_VERSION)
// If HK_SERIALIZE_MIN_COMPATIBLE_VERSION is not defined, use all versions (300 being the first Havok version).
#   if defined(HK_SERIALIZE_LATEST_VERSION_ONLY)
#       define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE (HK_HAVOK_VERSION_Current - 1)
#   else
#       define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE HK_HAVOK_VERSION_300
#   endif
#else
#   define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE HK_HAVOK_VERSION(HK_SERIALIZE_MIN_COMPATIBLE_VERSION)
#endif

#ifndef HK_HAVOK_KEYCODE
#   error Common/Base/KeyCode.h must be included before this file
#endif

#ifndef HK_HAVOK_VERSIONS_H
#   error hkHavokVersions.h must be included before this file
#endif

#if !defined(HK_PATCH_REGISTER_ACTION)
#   define HK_PATCH_REGISTER_ACTION(x) hkReflect::Detail::PatchesRegNode x##_reg(x)
#endif

// If this is defined, just do the old, keycode / exclude behaviour
#if !defined(HK_REGISTER_PATCHES_FROM_KEYCODES)
#   if defined(HK_REGISTER_COMMON_PATCHES)  || defined(HK_REGISTER_AI_PATCHES) || defined(HK_REGISTER_ANIMATION_PATCHES)  || defined(HK_REGISTER_CLOTH_PATCHES) \
    || defined(HK_REGISTER_DESTRUCTION_2012_PATCHES) || defined(HK_REGISTER_BEHAVIOR_PATCHES) || defined(HK_REGISTER_PHYSICS_2012_PATCHES) \
    || defined(HK_REGISTER_PHYSICS_PATCHES) || defined(HK_REGISTER_FX_PATCHES) || defined(HK_REGISTER_DESTRUCTION_PATCHES) || defined(HK_REGISTER_ENGINE_PATCHES)

// 2015.1 Behaviour, only register what we have been asked to register
#       define HK_EXCLUDE_COMMON_PATCHES
#       undef HK_FEATURE_PRODUCT_AI
#       undef HK_FEATURE_PRODUCT_ANIMATION
#       undef HK_FEATURE_PRODUCT_CLOTH
#       undef HK_FEATURE_PRODUCT_DESTRUCTION_2012
#       undef HK_FEATURE_PRODUCT_BEHAVIOR
#       undef HK_FEATURE_PRODUCT_PHYSICS_2012
#       undef HK_FEATURE_PRODUCT_PHYSICS
#       undef HK_FEATURE_PRODUCT_FX
#       undef HK_FEATURE_PRODUCT_DESTRUCTION
#       undef HK_FEATURE_PRODUCT_BEHAVIOR
#       undef HK_FEATURE_PRODUCT_ENGINE
#       undef HK_FEATURE_PRODUCT_NEW_TOOLS

#       if defined(HK_REGISTER_COMMON_PATCHES)
#           undef HK_EXCLUDE_COMMON_PATCHES
#       endif
#       if defined(HK_REGISTER_AI_PATCHES)
#           define HK_FEATURE_PRODUCT_AI
#       endif
#       if defined(HK_REGISTER_ANIMATION_PATCHES)
#           define HK_FEATURE_PRODUCT_ANIMATION
#       endif
#       if defined(HK_REGISTER_CLOTH_PATCHES)
#           define HK_FEATURE_PRODUCT_CLOTH
#       endif
#       if defined(HK_REGISTER_DESTRUCTION_2012_PATCHES)
#           define HK_FEATURE_PRODUCT_DESTRUCTION_2012
#       endif
#       if defined(HK_REGISTER_BEHAVIOR_PATCHES)
#           define HK_FEATURE_PRODUCT_BEHAVIOR
#       endif
#       if defined(HK_REGISTER_PHYSICS_2012_PATCHES)
#           define HK_FEATURE_PRODUCT_PHYSICS_2012
#       endif
#       if defined(HK_REGISTER_PHYSICS_PATCHES)
#           define HK_FEATURE_PRODUCT_PHYSICS
#       endif
#       if defined(HK_REGISTER_FX_PATCHES)
#           define HK_FEATURE_PRODUCT_FX
#       endif
#       if defined(HK_REGISTER_DESTRUCTION_PATCHES)
#           define HK_FEATURE_PRODUCT_DESTRUCTION
#       endif
#       if defined(HK_REGISTER_ENGINE_PATCHES)
#           define HK_FEATURE_PRODUCT_ENGINE
#       endif
#       if defined(HK_REGISTER_NEWTOOLS_PATCHES)
#           define HK_FEATURE_PRODUCT_NEW_TOOLS
#       endif
// Make sure we don't break productfeatures
#       define HK_REGISTER_PATCHES_CHANGED_FEATURES

#   endif
#endif

// Call the patches registration functions depending on the products available
// and the selected minimum compatible version.

// Patches are organized in folders depending on the version they affect, and in
// each folder we have several files (one for each Havok product). For instance,
// the hkbPatches.cxx/hkbPatches.cpp files in 2011_2/ implement the changes
// needed to patch Behavior classes from version 2011.2 to the next version
// (2011.3).

#if defined(HK_REGISTER_INITIAL_CLASS_PATCHES)
    extern void HK_CALL registerInitialClassPatches(hkVersionPatchManager&);
    HK_PATCH_REGISTER_ACTION(registerInitialClassPatches);
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE < HK_HAVOK_VERSION_660r1)
// All the patches applied to versions older than Havok 660, needed to bring
// the classes to version 660, are available in the
// Common/Compat/Patches/Legacy/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_Legacy);
        extern void HK_CALL registerCollidePatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_Legacy);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_Legacy(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_Legacy);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_660r1)
// All patches necessary to update version 660 classes to the next version
// are available in the Common/Compat/Patches/660/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_660);
        extern void HK_CALL registerCollidePatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_660);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_660(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_660);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_700r1)
// All patches necessary to update version 700 classes to the next version
// are available in the Common/Compat/Patches/700/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_700);
        extern void HK_CALL registerCollidePatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_700);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_700(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_700);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_710r1)
// All patches necessary to update version 710 classes to the next version
// are available in the Common/Compat/Patches/710/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_710);
        extern void HK_CALL registerCollidePatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_710);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_710(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_710);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201010r1)
// All patches necessary to update version 2010.1 classes to the next version
// are available in the Common/Compat/Patches/2010_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2010_1);
        extern void HK_CALL registerCollidePatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2010_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2010_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2010_1);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201020r1)
// All patches necessary to update version 2010.2 classes to the next version
// are available in the Common/Compat/Patches/2010_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2010_2);
        extern void HK_CALL registerCollidePatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2010_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2010_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2010_2);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201110r1)
// All patches necessary to update version 2011.1 classes to the next version
// are available in the Common/Compat/Patches/2011_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2011_1);
        extern void HK_CALL registerCollidePatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2011_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2011_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2011_1);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201120r1)
// All patches necessary to update version 2011.2 classes to the next version
// are available in the Common/Compat/Patches/2011_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2011_2);
        extern void HK_CALL registerCollidePatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2011_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2011_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2011_2);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201130r1)
// All patches necessary to update version 2011.3 classes to the next version
// are available in the Common/Compat/Patches/2011_3/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2011_3);
        extern void HK_CALL registerCollidePatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2011_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2011_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2011_3);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201210r1)
// All patches necessary to update version 2011.3 classes to the next version
// are available in the Common/Compat/Patches/2012_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2012_1);
        extern void HK_CALL registerCollidePatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2012_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2012_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2012_1);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201220r1)
// All patches necessary to update version 2012.1 classes to the next version
// are available in the Common/Compat/Patches/2012_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2012_2);
        extern void HK_CALL registerCollidePatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
        extern void HK_CALL registerNewPhysicsPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2012_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
        extern void HK_CALL registerNewDestructionPatches_2012_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2012_2);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201310r1)
        // All patches necessary to update version 2013.1 classes to the next version
        // are available in the Common/Compat/Patches/2013_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2013_1);
        extern void HK_CALL registerCollidePatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsConstraintPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
        extern void HK_CALL registerNewPhysicsPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2013_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
        extern void HK_CALL registerNewDestructionPatches_2013_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2013_1);
    #endif
    #if defined (HK_FEATURE_PRODUCT_NEW_TOOLS)
        extern void HK_CALL registerNewToolsPatches(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewToolsPatches);
    #endif

#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201320r1)
        // All patches necessary to update version 2013.2 classes to the next version
        // are available in the Common/Compat/Patches/2013_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2013_2);
        extern void HK_CALL registerCollidePatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsConstraintPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
        extern void HK_CALL registerNewPhysicsPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2013_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
        extern void HK_CALL registerNewDestructionPatches_2013_2(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2013_2);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201330r1)
        // All patches necessary to update version 2013.3 classes to the next version
        // are available in the Common/Compat/Patches/2013_3/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2013_3);
        extern void HK_CALL registerCollidePatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsConstraintPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
        extern void HK_CALL registerNewPhysicsPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2013_3);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
        extern void HK_CALL registerNewDestructionPatches_2013_3(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2013_3);
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201410r1)
        // All patches necessary to update version 2014.1 classes to the next version
        // are available in the Common/Compat/Patches/2014_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
        extern void HK_CALL registerCommonPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCommonPatches_2014_1);
        extern void HK_CALL registerCollidePatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerCollidePatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
        extern void HK_CALL registerAiPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAiPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
        extern void HK_CALL registerAnimationPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
        extern void HK_CALL registerClothPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerClothPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
        extern void HK_CALL registerDestructionPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
        extern void HK_CALL registerBehaviorPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsConstraintPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
        extern void HK_CALL registerPhysicsPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
        extern void HK_CALL registerNewPhysicsPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2014_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
        extern void HK_CALL registerNewDestructionPatches_2014_1(hkVersionPatchManager&);
        HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2014_1);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2014_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2014_1);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201410r2)
            // All patches necessary to update version 2014.2 classes to the next version
            // are available in the Common/Compat/Patches/2014_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2014_2);
            extern void HK_CALL registerCollidePatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2014_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2014_2);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2014_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2014_2);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201420r1)
            // All patches necessary to update version 2014.2.5 classes to the next version
            // are available in the Common/Compat/Patches/2014_2_5/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2014_2_5);
            extern void HK_CALL registerCollidePatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2014_2_5);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2014_2_5);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2014_2_5(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2014_2_5);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201510r1)
            // All patches necessary to update version 2015.1 classes to the next version
            // are available in the Common/Compat/Patches/2015_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2015_1);
            extern void HK_CALL registerCollidePatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2015_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2015_1);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2015_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2015_1);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201610r1)
            // All patches necessary to update version 2016.1 classes to the next version
            // are available in the Common/Compat/Patches/2016_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2016_1);
            extern void HK_CALL registerCollidePatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2016_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2016_1);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2016_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2016_1);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201620r1)
            // All patches necessary to update version 2016.2 classes to the next version
            // are available in the Common/Compat/Patches/2016_2/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2016_2);
            extern void HK_CALL registerCollidePatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2016_2);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2016_2);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2016_2(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2016_2);
        #endif
    #endif
#endif

#if (HK_SERIALIZE_MIN_COMPATIBLE_VERSION_PATCHES_VALUE <= HK_HAVOK_VERSION_201710r1)
    // All patches necessary to update version 2017.1 classes to the next version
    // are available in the Common/Compat/Patches/2017_1/ directory.
    #if !defined( HK_EXCLUDE_COMMON_PATCHES )
            extern void HK_CALL registerCommonPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCommonPatches_2017_1);
            extern void HK_CALL registerCollidePatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerCollidePatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_AI)
            extern void HK_CALL registerAiPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAiPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_ANIMATION)
            extern void HK_CALL registerAnimationPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerAnimationPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_CLOTH)
            extern void HK_CALL registerClothPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerClothPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012)
            extern void HK_CALL registerDestructionPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerDestructionPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_BEHAVIOR)
            extern void HK_CALL registerBehaviorPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerBehaviorPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS) || defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsConstraintPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsConstraintPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
            extern void HK_CALL registerPhysicsPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerPhysicsPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_PHYSICS)
            extern void HK_CALL registerNewPhysicsPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewPhysicsPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_FX)
            extern void HK_CALL registerFxPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerFxPatches_2017_1);
    #endif
    #if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
            extern void HK_CALL registerNewDestructionPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNewDestructionPatches_2017_1);
        #if defined(HK_INCLUDE_LIBRARY_hkndIntegration)
            extern void HK_CALL registerNdIntegrationPatches_2017_1(hkVersionPatchManager&);
            HK_PATCH_REGISTER_ACTION(registerNdIntegrationPatches_2017_1);
        #endif
    #endif
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
