// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hclTransitionConstraintSetPerParticle_0_to_1(hkDataObject& obj)
{
    obj["toAnimDelay"] = obj["particleDelay"].asReal();
    obj["toSimDelay"] = obj["particleDelay"].asReal();
}

static void hclTransitionConstraintSet_0_to_1(hkDataObject& obj)
{
    obj["toAnimPeriod"] = obj["transitionPeriod"].asReal();
    obj["toSimPeriod"] = obj["transitionPeriod"].asReal();
    obj["toAnimPlusDelayPeriod"] = obj["transitionPlusDelayPeriod"].asReal();
    obj["toSimPlusDelayPeriod"] = obj["transitionPlusDelayPeriod"].asReal();
}

static void hclSkinOperator_0_to_1(hkDataObject& obj)
{
    // HCL-127: We've added start and end vertices parameters. For old assets, these should be set to 0 and numVertices-1
    // Number of vertices can be guessed from the number of entries in "boneInfluencesStartPerVertex" in those assets,
    // which contains numVertices+1 entries.

    obj["endVertex"] = obj["boneInfluenceStartPerVertex"].asArray().getSize() - 2;
}

static void hclMeshMeshDeformOperator_0_to_1(hkDataObject& obj)
{
    // HCL-839: We've added start and end vertices parameters. For old assets, these should be set to 0 and numVertices-1
    // Number of vertices can be guessed from the number of entries in "triangleVertexStartForVertex" in those assets,
    // which used to contain numVertices+1 entries.

    obj["endVertex"] = obj["triangleVertexStartForVertex"].asArray().getSize() - 2;
}

void HK_CALL registerClothPatches_Legacy(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/Legacy/hclPatches_Legacy.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
