// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkpCompressedMeshShape_8_to_9(hkDataObject& obj)
{
    hkDataArray transforms = obj["transforms"].asArray();

    if( obj.hasMember("transforms") && transforms.getSize()!=0 )
    {
        hkDataArray newtransforms = obj["newtransforms"].asArray();
        newtransforms.setSize( transforms.getSize() );

        for ( int i = 0; i < transforms.getSize(); ++i )
        {
            const hkTransformf tr = transforms[i].asTransformf();
            hkQsTransformf qs; qs.setFromTransform(tr);
            newtransforms[i] = qs;
        }
    }
}

static void hkpExtendedMeshShape_2_to_3(hkDataObject& obj)
{
    hkVector4f scale = obj["scaling"].asVector4f();
    hkDataArray triSubparts = obj["trianglesSubparts"].asArray();
    for ( int i = 0; i < triSubparts.getSize(); ++i )
    {
        hkDataObject triSub = triSubparts[i].asObject();
        hkQsTransformf transform = triSub["transform"].asQsTransformf();
        transform.setScale( scale );
        triSub["transform"] = transform;
        triSubparts[i] = triSub;
    }
}

void HK_CALL registerPhysicsPatches_710(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/710/hkpPatches_710.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
