// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkxSkinBinding_1_to_2(hkDataObject& obj)
{
    // COM-883
    // Change the array of mapping nodes to an array of mapping names
    // This prevents the possiblility of circular references

    hkDataArray oldMapping = obj["mapping" ].asArray();
    hkDataArray newNodeNames = obj["nodeNames" ].asArray();

    int num = oldMapping.getSize();
    newNodeNames.setSize(num);
    for( int i = 0; i < num; ++i )
    {
        hkDataObject oldNode = oldMapping[ i ].asObject();
        if( !oldNode.isNull() )
        {
            newNodeNames[i] = oldNode["name"].asString();
        }
    }
}

void HK_CALL registerCommonPatches_700(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/700/hkPatches_700.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
