// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkaiCharacter_4_to_5(hkDataObject& obj)
{
    const hkDataWorld* world = obj.getClass().getWorld();
    hkDataClass steeringClass( world->findClass("hkaiDefaultLocalSteering") );
    hkDataObject steering( world->newObject( steeringClass ) );
    steering["pathFollowingProperties"] = obj["pathFollowingProperties"];
    steering["avoidanceProperties"] = obj["avoidanceProperties"];
    obj["localSteering"] = steering;
}

static void hkaiNavMesh_1_to_2(hkDataObject& obj)
{
    hkDataObject aabb = obj["aabb"].asObject();

    hkDataArray meshVerts = obj["vertices"].asArray();
    hkVector4f vMin, vMax;
    vMin.setAll(HK_FLOAT_MAX);
    vMax.setAll(-HK_FLOAT_MAX);

    for (int i=0; i<meshVerts.getSize(); i++)
    {
        hkVector4f v = meshVerts[i].asVector4f();
        vMin.setMin(vMin, v);
        vMax.setMax(vMax, v);
    }

    aabb["min"] = vMin;
    aabb["max"] = vMax;
}

void HK_CALL registerAiPatches_660(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/660/hkaiPatches_660.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
