// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

static void hkp6DofConstraintData_Blueprints_0_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    for(int a = 0; a < 3; a++)
    {
        bool linFixedA = hkReflect::BoolVar(obj["linearIsFixed"][a]).getValue();

        double springLength = hkReflect::FloatVar(obj["stiffSpring"]["maxLength"]).getValue();
        hkReflect::FloatVar(obj["linearLimits"][a]["min"]).setValue(-springLength);
        hkReflect::FloatVar(obj["linearLimits"][a]["max"]).setValue(springLength);
        hkReflect::IntVar(obj["linearLimits"][a]["axisIndex"]).setValue(a);

        if(linFixedA || springLength == 0.0f)
        {
            hkReflect::IntVar(obj["axisMode"][a]).setValue(2); //FIXED
        }
        else if(springLength == HK_REAL_MAX)
        {
            hkReflect::IntVar(obj["axisMode"][a]).setValue(0); //UNLIMITED
        }
        else
        {
            hkReflect::IntVar(obj["axisMode"][a]).setValue(1); //LIMITED
        }

        hkReflect::IntVar(obj["linearFriction"][a]["frictionAxis"]).setValue(a);
        hkReflect::IntVar(obj["linearFriction"][a]["isEnabled"]).setValue(1);
        hkReflect::FloatVar(obj["linearFriction"][a]["maxFrictionForce"]).setValue(0.0f);
    }

    {
        double swing0 = hkReflect::FloatVar(obj["ellipticalLimit"]["angle0"]).getValue();
        double swing1 = hkReflect::FloatVar(obj["ellipticalLimit"]["angle1"]).getValue();
        hkReflect::FloatVar(obj["ellipticalMinMax"][0]).setValue(-swing0);
        hkReflect::FloatVar(obj["ellipticalMinMax"][1]).setValue(swing0);
        hkReflect::FloatVar(obj["ellipticalMinMax"][2]).setValue(-swing1);
        hkReflect::FloatVar(obj["ellipticalMinMax"][3]).setValue(swing1);

        if(swing0 == 0.0f)
        {
            hkReflect::IntVar(obj["axisMode"][4]).setValue(2);
        }
        else if(swing0 == HK_REAL_PI)
        {
            hkReflect::IntVar(obj["axisMode"][4]).setValue(0);
        }
        else
        {
            hkReflect::IntVar(obj["axisMode"][4]).setValue(1);
        }

        if(swing1 == 0.0f)
        {
            hkReflect::IntVar(obj["axisMode"][5]).setValue(2);
        }
        else if(swing1 == HK_REAL_PI)
        {
            hkReflect::IntVar(obj["axisMode"][5]).setValue(0);
        }
        else
        {
            hkReflect::IntVar(obj["axisMode"][5]).setValue(1);
        }
    }

    {
        double twistMin = hkReflect::FloatVar(obj["twistLimit"]["minAngle"]).getValue();
        double twistMax = hkReflect::FloatVar(obj["twistLimit"]["maxAngle"]).getValue();

        if(twistMin == 0 && twistMax == 0)
        {
            hkReflect::IntVar(obj["axisMode"][3]).setValue(2);
        }
        else if(twistMin == -HK_REAL_PI && twistMax == HK_REAL_PI)
        {
            hkReflect::IntVar(obj["axisMode"][3]).setValue(0);
        }
        else
        {
            hkReflect::IntVar(obj["axisMode"][3]).setValue(1);
        }
    }


    for(int a = 0; a < 3; a++)
    {
        double angularFriction = hkReflect::FloatVar(obj["angFriction"]["maxFrictionTorque"]).getValue();

        hkReflect::FloatVar(obj["angFrictions"][a]["maxFrictionTorque"]).setValue(angularFriction);
        hkReflect::IntVar(obj["angFrictions"][a]["numFrictionAxes"]).setValue(1);
        hkReflect::IntVar(obj["angFrictions"][a]["firstFrictionAxis"]).setValue(a);
        hkReflect::IntVar(obj["angFrictions"][a]["isEnabled"]).setValue(1);
    }
}

void HK_CALL registerPhysicsConstraintPatches_2017_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2017_1/hkpConstraintPatches_2017_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
