// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// NewPhysics specific product patches applied to release 2017_1.
// This file is #included by hknpPatches_2017_1.cpp

BEGIN("hknpBodyCinfo", 6, "hknpBodyCinfo", 7)
    ADD("activationPriority", "hkInt8")
END()

BEGIN("hknpBody", 9, "hknpBody", 10)
    REMOVE("indexIntoActiveList", "hkInt32")
    ADD("activationPriority", "hkInt8")
END()

BEGIN( "hknpMotion", 4, "hknpMotion", 5 )
    RENAME( "linearVelocity", "linearVelocityAndSpeedLimit" )
    RENAME( "angularVelocity", "angularVelocityLocalAndSpeedLimit" )
    RENAME( "previousStepAngularVelocity", "previousStepAngularVelocityLocal" )
    FUNCTION( hknpMotion_4_to_5 )
END()

BEGIN("hknpPhysicsSystemData", 2, "hknpPhysicsSystemData", 3)
    REMOVE("referencedObjects", "hkArray< hkReferencedObject* >")
    DEPENDS("hkReferencedObject", 3)
END()

BEGIN("hknpParticleShapeProperties", 0, "hknpParticleShapeProperties", 1)
    REMOVE("relativePenetrationRecoveryVelocity", "hkReal")
    REMOVE("maxPenetrationRecoveryVelocity", "hkReal")
    FUNCTION( hknpParticleShapeProperties_0_to_1 )
END()

BEGIN( "hknpParticleFaceVerticesWithEffMass", 0, "hknpParticleFaceVerticesWithEffMass", 1 )
    REMOVE( "shapeCanSettleOnFace", "hkBool" )
    REMOVE( "frictionEffMass", "hkBool" )
END()

BEGIN("hknpStorageParticleSystem", 0, "hknpStorageParticleSystem", 1)
    ADD("radiusBasedLookahead", "hkReal")
    ADD("velocityBasedLookahead", "hkReal")
    ADD("linearAccelerationRestingThreshold", "hkReal")
    ADD("angularVelocityRestingThreshold", "hkReal")
    ADD("relativeTimeForPenetrationRecovery", "hkReal")
    ADD("maxPenetrationRecoveryImpulse", "hkReal")
    ADD("enableQueries", "bool")
END()

BEGIN( "hknpStepCollideTrace", 0, "hknpStepCollideTrace", 1 )
    REMOVE( "deltaTime", "hkReal" )
    REMOVE( "numThreads", "hkInt32" )
    ADD( "stepInput", "hknpStepInput" )
    DEPENDS( "hknpStepInput", 0 )
END()

BEGIN( "hknpApiCommand", 0, "hknpApiCommand", 1 )
    REMOVE( "bodyId", "hknpBodyId" )
    DEPENDS( "hknpBodyId", 0 )
END()

BEGIN( "hknpBodyAllocatedTrace", 0, "hknpBodyAllocatedTrace", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpBodyAllocatedAttachedTrace", 0, "hknpBodyAllocatedAttachedTrace", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpApplyHardKeyFrameCommand", 0, "hknpApplyHardKeyFrameCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpActivateBodiesInAabbCommand", 0, "hknpActivateBodiesInAabbCommand", 1 )
    ADD("intAabb", "hkAabb24_16_24")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS("hkAabb24_16_24", 0)
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyCollisionLookAheadDistanceCommand", 0, "hknpSetBodyCollisionLookAheadDistanceCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyActivationControlCommand", 0, "hknpSetBodyActivationControlCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpUpdateBodyCollisionCachesCommand", 0, "hknpUpdateBodyCollisionCachesCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpRebuildBodyCollisionCachesCommand", 0, "hknpRebuildBodyCollisionCachesCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpUpdateBodyFlagsCommand", 0, "hknpUpdateBodyFlagsCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyCollisionFilterInfoCommand", 0, "hknpSetBodyCollisionFilterInfoCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyActivationStateCommand", 0, "hknpSetBodyActivationStateCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyQualityCommand", 0, "hknpSetBodyQualityCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMaterialCommand", 0, "hknpSetBodyMaterialCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMotionPropertiesCommand", 0, "hknpSetBodyMotionPropertiesCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyShapeCommand", 0, "hknpSetBodyShapeCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpClearBodyMassDistributionCommand", 0, "hknpClearBodyMassDistributionCommand", 1 )
    ADD("updateMotionMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMassDistributionCommand", 0, "hknpSetBodyMassDistributionCommand", 1 )
    ADD("updateMotionMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMotionCommand", 0, "hknpSetBodyMotionCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMotionTypeCommand", 0, "hknpSetBodyMotionTypeCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyMassCommand", 0, "hknpSetBodyMassCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetPointVelocityCommand", 0, "hknpSetPointVelocityCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpApplyPointImpulseCommand", 0, "hknpApplyPointImpulseCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpApplyAngularImpulseCommand", 0, "hknpApplyAngularImpulseCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpApplyLinearImpulseCommand", 0, "hknpApplyLinearImpulseCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyAngularVelocityCommand", 0, "hknpSetBodyAngularVelocityCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyLinearVelocityCommand", 0, "hknpSetBodyLinearVelocityCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyVelocityCommand", 0, "hknpSetBodyVelocityCommand", 1 )
    ADD("activationMode", "hkUint8")
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyOrientationCommand", 0, "hknpSetBodyOrientationCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyPositionCommand", 0, "hknpSetBodyPositionCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpSetBodyTransformCommand", 0, "hknpSetBodyTransformCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpAttachBodyCommand", 0, "hknpAttachBodyCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpDetachBodyCommand", 0, "hknpDetachBodyCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpRemoveBodyCommand", 0, "hknpRemoveBodyCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpAddBodyCommand", 0, "hknpAddBodyCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN( "hknpDestroyBodyCommand", 0, "hknpDestroyBodyCommand", 1 )
    SET_PARENT( "hknpApiCommand", "hknpUnaryBodyApiCommand" )
    DEPENDS( "hknpApiCommand", 1 )
    DEPENDS( "hknpUnaryBodyApiCommand", 0 )
END()

BEGIN("hknpDisableConstraintCommand", 0, "hknpDisableConstraintCommand", 1)
        ADD("activationMode", "hkUint8")
END()

BEGIN("hknpManifoldViewerBase::hknpVdbManifold", 0, "hknpManifoldViewerBase::hknpVdbManifold", 1)
    ADD("manifold", "hkcdManifold4")
    DEPENDS("hkcdManifold4", 0)
END()

BEGIN( "hknpDefaultHeightFieldGeometry", 0, "hknpDefaultHeightFieldGeometry", 1 )
    ADD( "fold", "hkInt32" )
    FUNCTION( hknpDefaultHeightFieldGeometry_0_to_1 )
    REMOVE( "triangleFlip", "hkUint8" )
END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
