// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

namespace
{
    void hknpMotion_4_to_5( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        // These W components now store a copy of the max speeds from the related hknpMotionProperties.
        // The values will be copied in the next simulation step.
        // Set them to large values to prevent bad behavior before the next step.
        hkReflect::FloatVar( obj["linearVelocityAndSpeedLimit"][3] ).setValue( HK_REAL_MAX );
        hkReflect::FloatVar( obj["angularVelocityLocalAndSpeedLimit"][3] ).setValue( HK_REAL_MAX );
    }

    void hknpParticleShapeProperties_0_to_1( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        hkReal radiiDifference = (hkReal)(hkReflect::FloatVar( obj["outerRadius"][0] ).getValue() - hkReflect::FloatVar( obj["innerRadius"][0] ).getValue());
        for ( int i = 0; i < 4; i++ )
        {
            hkReflect::FloatVar( obj["radiiDifference"][i] ).setValue( radiiDifference );
        }
    }

    void hknpDefaultHeightFieldGeometry_0_to_1( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        // Refactored "hkBool m_triangleFlip" to "Enum m_fold"
        bool flip = !hkReflect::IntVar( obj["triangleFlip"] ).getValue().isZero();
        hkReflect::IntVar( obj["fold"] ).setValue( flip ? 1 : 0 );
    }
}

void HK_CALL registerNewPhysicsPatches_2017_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2017_1/hknpPatches_2017_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
