// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

static void hkaiNavMeshInstance_9_10(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    const hkReflect::Type* instanceDataPtrType = obj["instanceData"]["ptr"].getType().get();
    const hkReflect::Type* instanceDataType = instanceDataPtrType->getTemplate()->getParam(0)->getAsType();

    // Copy the fields from the old hkaiNavMeshInstance to the hkaiNavMeshInstanceData.
    hkReflect::Var instanceData = helper.newObject(instanceDataType);
    instanceData["originalMesh"].assign(obj["originalMesh"]);
    instanceData["edgeOrigToInstancedMap"].assign(obj["edgeOrigToInstancedMap"]);
    instanceData["edgeInstancedToOrigMap"].assign(obj["edgeInstancedToOrigMap"]);
    instanceData["faceOrigToInstancedMap"].assign(obj["faceOrigToInstancedMap"]);
    instanceData["faceInstancedToOrigMap"].assign(obj["faceInstancedToOrigMap"]);
    instanceData["instancedFaces"].assign(obj["instancedFaces"]);
    instanceData["instancedEdges"].assign(obj["instancedEdges"]);
    instanceData["ownedFaces"].assign(obj["ownedFaces"]);
    instanceData["ownedEdges"].assign(obj["ownedEdges"]);
    instanceData["ownedVertices"].assign(obj["ownedVertices"]);
    instanceData["faceFlags"].assign(obj["faceFlags"]);
    instanceData["origEdgeOffsets"].assign(obj["origEdgeOffsets"]);
    instanceData["instancedFaceData"].assign(obj["instancedFaceData"]);
    instanceData["instancedEdgeData"].assign(obj["instancedEdgeData"]);
    instanceData["ownedFaceData"].assign(obj["ownedFaceData"]);
    instanceData["ownedEdgeData"].assign(obj["ownedEdgeData"]);
    instanceData["numGarbageEdges"].assign(obj["numGarbageEdges"]);
    instanceData["numGarbageFaces"].assign(obj["numGarbageFaces"]);
    instanceData["faceMapping"].assign(obj["faceMapping"]);
    instanceData["sectionUid"].assign(obj["sectionUid"]);
    instanceData["runtimeId"].assign(obj["runtimeId"]);
    instanceData["layerIndex"].assign(obj["layerIndex"]);
    instanceData["clearanceCaches"].assign(obj["clearanceCaches"]);
    instanceData["dynUserEdgeBases"].assign(obj["dynUserEdgeBases"]);

    hkReflect::Var instanceDataCOWPtr = obj["instanceData"];
    hkReflect::PointerVar(instanceDataCOWPtr["ptr"]).setValue(instanceData);

    hkReflect::IntVar ptrState(instanceDataCOWPtr["ptrState"]["val"]);
    ptrState.setValue(hkReflect::IntValue(2));
}

static void hkaiDirectedGraphInstance_1_2(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    const hkReflect::Type* instanceDataPtrType = obj["instanceData"]["ptr"].getType().get();
    const hkReflect::Type* instanceDataType = instanceDataPtrType->getTemplate()->getParam(0)->getAsType();

    // Copy the fields from the old hkaiNavMeshInstance to the hkaiNavMeshInstanceData.
    hkReflect::Var instanceData = helper.newObject(instanceDataType);
    instanceData["freeEdgeBlocks"].assign(obj["freeEdgeBlocks"]);
    instanceData["userEdgeCount"].assign(obj["userEdgeCount"]);
    instanceData["ownedEdges"].assign(obj["ownedEdges"]);
    instanceData["ownedEdgeData"].assign(obj["ownedEdgeData"]);
    instanceData["instancedNodes"].assign(obj["instancedNodes"]);
    instanceData["nodeMap"].assign(obj["nodeMap"]);
    instanceData["originalGraph"].assign(obj["originalGraph"]);
    instanceData["runtimeId"].assign(obj["runtimeId"]);
    instanceData["sectionUid"].assign(obj["sectionUid"]);

    hkReflect::Var instanceDataCOWPtr = obj["instanceData"];
    hkReflect::PointerVar(instanceDataCOWPtr["ptr"]).setValue(instanceData);

    hkReflect::IntVar ptrState(instanceDataCOWPtr["ptrState"]["val"]);
    ptrState.setValue(hkReflect::IntValue(2));
}

static void hkaiNavVolumeInstance_2_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    const hkReflect::Type* instanceDataPtrType = obj["instanceData"]["ptr"].getType().get();
    const hkReflect::Type* instanceDataType = instanceDataPtrType->getTemplate()->getParam(0)->getAsType();

    // Copy the fields from the old hkaiNavMeshInstance to the hkaiNavMeshInstanceData.
    hkReflect::Var instanceData = helper.newObject(instanceDataType);
    instanceData["ownedUserEdgeInfos"].assign(obj["ownedUserEdgeInfos"]);
    instanceData["ownedUserEdgeData"].assign(obj["ownedUserEdgeData"]);
    instanceData["layerIndex"].assign(obj["layerIndex"]);
    instanceData["runtimeId"].assign(obj["runtimeId"]);
    instanceData["sectionUid"].assign(obj["sectionUid"]);
    instanceData["ownedEdges"].assign(obj["ownedEdges"]);
    instanceData["instancedCells"].assign(obj["instancedCells"]);
    instanceData["cellMap"].assign(obj["cellMap"]);
    instanceData["originalVolume"].assign(obj["originalVolume"]);

    hkReflect::Var instanceDataCOWPtr = obj["instanceData"];
    hkReflect::PointerVar(instanceDataCOWPtr["ptr"]).setValue(instanceData);

    hkReflect::IntVar ptrState(instanceDataCOWPtr["ptrState"]["val"]);
    ptrState.setValue(hkReflect::IntValue(2));
}

static void hkaiStreamingCollectionInstanceInfo_5_6(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::Var meshInstance = obj["instance"];
    hkReflect::Var graphInstance = obj["clusterGraphInstance"];
    hkReflect::Var volumeInstance = obj["volumeInstance"];
    if(meshInstance.isValid())
    {
        obj["sectionReferenceFrame"].assign(meshInstance["referenceFrame"]);
    }
    else if(graphInstance.isValid())
    {
        obj["sectionReferenceFrame"]["transform"].assign(graphInstance["transform"]);
    }
    else if(volumeInstance)
    {
        obj["volumeTransform"].assign(volumeInstance["transform"]);
    }
    else
    {
        HK_ERROR(0x5c968f30, "At least one of m_instance, m_clusterGraphInstance and "
            "m_volumeInstance must be non-null in version 5 or earlier.");
    }
}

static void hkaiStreamingCollection_4_5(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
#if 0
    // Copy the tree into the copy-on-write pointer.
    hkReflect::Var aabbTree = obj["tree"];
    hkReflect::Var aabbTreeCOWPtr = obj["tree_tmp"];

    aabbTreeCOWPtr["ptr"].assign(aabbTree);
    
    hkReflect::IntVar ptrState(aabbTreeCOWPtr["ptrState"]["val"]);
    ptrState.setValue(hkReflect::IntValue(2));

    // Create the array of streaming set instances.
    hkReflect::ArrayVar instances = obj["instances"];
    for(int i = 0; i < instances.getCount(); i++)
    {
        hkReflect::Var instanceInfo = instances[i];
        hkReflect::ArrayVar streamingSets = instanceInfo["streamingSets"];
    }

    for(int i = 0; i < instances.getCount(); i++)
    {
        hkReflect::Var instanceInfo = instances[i];
        hkReflect::ArrayVar streamingSets = instanceInfo["streamingSets"];
        for(int j = 0; j < streamingSets.getCount(); j++)
        {
            hkReflect::Var pair = streamingSets[j];
            hkReflect::Var streamingSet = pair["1"];

            int index = 
        }
    }

    hkReflect::ArrayVar streamingSetsArr = helper.newArray(
#endif

    HK_ASSERT_NOT_IMPLEMENTED(0x1864e08);
}

static void hkaiOverlapManager_Section_3_4(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x13e1445c, "hkaiOverlapManager::Section cannot be patched from version 3 to 4. Re-export your data instead.");
}

static void hkaiOverlapManager_2_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x650bec38, "hkaiOverlapManager cannot be patched from version 2 to 3. Re-export your data instead.");
}

static void hkaiWorld_40_41(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x4a047116, "hkaiWorld cannot be patched from version 40 to 41. Re-export your data instead.");
}

static void hkaiNavMeshCutter_20_21(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x65b67b3b, "hkaiNavMeshCutter cannot be patched from version 20 to 21. Re-export your data instead."); 
}

static void hkaiNavMeshPathRequestInfo_0_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x46dd62c0, "hkaiNavMeshPathRequestInfo cannot be patched from version 0 to 1. Re-export your data instead.");
}

static void hkaiNavVolumePathRequestInfo_0_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x7795f21e, "hkaiNavVolumePathRequestInfo cannot be patched from version 0 to 1. Re-export your data instead.");
}

static void hkaiNavMeshInstanceCutter_1_2(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x59e4470d, "hkaiNavMeshInstanceCutter cannot be patched from version 1 to 2. Re-export your data instead.");
}

void HK_CALL registerAiPatches_2017_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2017_1/hkaiPatches_2017_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
