// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// NewPhysics specific product patches applied to release 2016_2.
// This file is #included by hknpPatches_2016_2.cpp

// This patch will take care of the merging of hknpCompoundShapeBase into hknpCompoundShape.
// All native members of hknpCompoundShapeBase will be moved into hknpCompoundShape by copying their values to
// intermediate objects which will get renamed to their final names after the call to SET_PARENT.
// All members of hknpCompositeShape and its base classes need to also be manually copied over using temp objects
// (which will be removed again however) as SET_PARENT will clear their values.
BEGIN("hknpCompoundShape", 4, "hknpCompoundShape", 5)
    DEPENDS("hknpCompoundShapeBase", 4)
    DEPENDS("hknpCompositeShape", 2)
    DEPENDS("hkFreeListArray< hknpShapeInstance, 8 >", 1)
    DEPENDS("hknpCompoundShape::VelocityInfo", 0)
    DEPENDS("hkAabb", 0)
    DEPENDS("hkPropertyBag", 0)
    DEPENDS("hkRefCountedProperties", 2)
    DEPENDS("hkReferencedObject", 3)

    ADD("propertyBag_tmp", "hkPropertyBag")
    ADD("memSizeAndFlags_tmp", "hkUint16")
    ADD("refCount_tmp", "hkUint16")

    ADD("flags_tmp", "hkUint16")
    ADD("type_tmp", "hkUint8")
    ADD("numShapeKeyBits_tmp", "hkUint8")
    ADD("dispatchType_tmp", "hkUint8")
    ADD("convexRadius_tmp", "hkReal")
    ADD("userData_tmp", "hkUint64")
    ADD("properties_tmp", "hkRefCountedProperties*")

    ADD("shapeTagCodecInfo_tmp", "hkUint32")
    ADD("materialTable_tmp", "hkReferencedObject*")

    ADD("instances_tmp", "hkFreeListArray< hknpShapeInstance, 8 >")
    ADD("instanceVelocities_tmp", "hkArray< hknpCompoundShape::VelocityInfo >")
    ADD("aabb_tmp", "hkAabb")
    ADD("isMutable_tmp", "hkBool")
    ADD("estimatedNumShapeKeys_tmp", "int")

    FUNCTION(hknpCompoundShape_4_5_baseRemoval_backupMembers)
    SET_PARENT("hknpCompoundShapeBase", "hknpCompositeShape")

    RENAME("instances_tmp", "instances")
    RENAME("instanceVelocities_tmp", "instanceVelocities")
    RENAME("aabb_tmp", "aabb")
    RENAME("isMutable_tmp", "isMutable")
    RENAME("estimatedNumShapeKeys_tmp", "estimatedNumShapeKeys")

    FUNCTION(hknpCompoundShape_4_5_baseRemoval_restoreUntouchedMembers)

    REMOVE("propertyBag_tmp", "hkPropertyBag")
    REMOVE("memSizeAndFlags_tmp", "hkUint16")
    REMOVE("refCount_tmp", "hkUint16")

    REMOVE("flags_tmp", "hkUint16")
    REMOVE("type_tmp", "hkUint8")
    REMOVE("numShapeKeyBits_tmp", "hkUint8")
    REMOVE("dispatchType_tmp", "hkUint8")
    REMOVE("convexRadius_tmp", "hkReal")
    REMOVE("userData_tmp", "hkUint64")
    REMOVE("properties_tmp", "hkRefCountedProperties*")

    REMOVE("shapeTagCodecInfo_tmp", "hkUint32")
    REMOVE("materialTable_tmp", "hkReferencedObject*")

    SET_VALUE("boundingVolumeData", hkReferencedObject* , 0) // Remove tree, as we've changed to use the hkSimdTree
END()

BEGIN("hknpCompoundShapeBase", 4, HK_NULL, HK_CLASS_REMOVED)
    DEPENDS("hkFreeListArray< hknpShapeInstance, 8 >", 1)
    DEPENDS("hknpCompoundShape::VelocityInfo", 0)
    DEPENDS("hkAabb", 0)
    DEPENDS("hknpCompositeShape", 2)
    SET_PARENT("hknpCompositeShape", HK_NULL)
    REMOVE("instances", "hkFreeListArray< hknpShapeInstance, 8 >")
    REMOVE("instanceVelocities", "hkArray< hknpCompoundShape::VelocityInfo >")
    REMOVE("aabb", "hkAabb")
    REMOVE("isMutable", "hkBool")
    REMOVE("estimatedNumShapeKeys", "int")
END()

BEGIN_EMPTY("hknpCompoundShapeBase::VelocityInfo", 0, "hknpCompoundShapeBase::VelocityInfo", 1)
END_EMPTY()

BEGIN_EMPTY("hknpCompoundShapeBase::VelocityInfo", 1, "hknpCompoundShape::VelocityInfo", 0)
END_EMPTY()

BEGIN_EMPTY("hknpDynamicCompoundShapeData", 0, "hknpCompoundShapeData", 0)
END_EMPTY()

BEGIN_EMPTY("hknpDynamicCompoundShapeTree", 0, "hknpCompoundShapeTree", 0)
END_EMPTY()

BEGIN_COMBINE("hknpDynamicCompoundShapeKeyMask", 0, "hknpCompoundShapeInternalsKeyMask", 2)
    DEPENDS("hknpCompoundShapeInternalsKeyMask", 1)
END()

// An empty version that allows us to move hknpDynamicCompoundShapeKeyMask into it's parent class
BEGIN_EMPTY( "hknpCompoundShapeInternalsKeyMask", 1, "hknpCompoundShapeInternalsKeyMask", 2 )
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDefragmentInactiveCacheStreamsCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionAllocatedTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("motionInfo", "hknpMotionCinfo")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
        DEPENDS("hknpMotionCinfo", 2)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRebuildMotionMassPropertiesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDestroyMotionsCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("isLastInBatch", "hkBool")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpApplyHardKeyFrameCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("targetPosition", "hkVector4")
        ADD("targetOrientation", "hkQuaternion")
        ADD("deltaTime", "hkReal")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShiftBroadphaseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("requestedCenterPos", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShiftWorldCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("offset", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDeleteAllCachesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpAddCollisionCachesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("pair", "hknpBodyIdPair")
        ADD("activationMode", "hkUint8")
        ADD("isLastInBatch", "hkBool")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpBodyIdPair", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpActivateBodiesInAabbCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("aabb", "hkAabb24_16_24")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hkAabb24_16_24", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCommitAddBodiesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpOptimizeBroadphaseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUpdateBroadphaseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpEnableConstraintCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("constraintId", "hknpConstraintId")
        ADD("activationMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpConstraintId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDisableConstraintCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("constraintId", "hknpConstraintId")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpConstraintId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDestroyConstraintsCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("constraintId", "hknpConstraintId")
        ADD("activationMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpConstraintId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetConstraintGroupCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("constraintId", "hknpConstraintId")
        ADD("groupId", "hknpConstraintGroupId")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpConstraintId", 1)
        DEPENDS("hknpConstraintGroupId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintAllocatedTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("constraintId", "hknpConstraintId")
        ADD("constraintCinfo", "hknpConstraintCinfo")
        ADD("activationMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpConstraintId", 1)
        DEPENDS("hknpConstraintCinfo", 5)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStepSolveTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStepCollideTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("deltaTime", "hkReal")
        ADD("numThreads", "int")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyCollisionLookAheadDistanceCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("distance", "hkReal")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetWorldGravityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("gravity", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyActivationControlCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("activationControl", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUpdateBodyCollisionCachesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRebuildBodyCollisionCachesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUpdateBodyFlagsCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("enable", "hkBool")
        ADD("flags", "hkUint32")
        ADD("updateCachesMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyCollisionFilterInfoCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("collisionFilterInfo", "hkUint32")
        ADD("cacheBehavior", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyActivationStateCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("state", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyQualityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("qualityId", "hknpBodyQualityId")
        ADD("collisionCacheBehavior", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpBodyQualityId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMaterialCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("material", "hknpMaterialId")
        ADD("collisionCacheBehavior", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMaterialId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMotionPropertiesCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionProperties", "hknpMotionPropertiesId")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionPropertiesId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyShapeCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("shape", "hknpShape*")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpShape", 4)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetMotionInertiaCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("inertia", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetMotionCenterOfMassCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("com", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpClearBodyMassDistributionCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMassDistributionCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("massDistribution", "hknpMassDistribution")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMassDistribution", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMotionCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("cacheBehavior", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMotionTypeCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionType", "hkUint8")
        ADD("cacheBehavior", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyMassCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("mass", "hkReal")
        ADD("updateMotionMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetPointVelocityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("velocity", "hkVector4")
        ADD("position", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpApplyPointImpulseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("impulse", "hkVector4")
        ADD("position", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpApplyAngularImpulseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("impulse", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpApplyLinearImpulseCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("impulse", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpReintegrateMotionCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("motionId", "hknpMotionId")
        ADD("t", "hkReal")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpMotionId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyAngularVelocityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("angularVelocity", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyLinearVelocityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("linearVelocity", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyVelocityCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("linVelocity", "hkVector4")
        ADD("angVelocity", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyOrientationCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("pivot", "hkUint8")
        ADD("activationMode", "hkUint8")
        ADD("orientation", "hkQuaternion")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyPositionCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("activationMode", "hkUint8")
        ADD("position", "hkVector4")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSetBodyTransformCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("activationMode", "hkUint8")
        ADD("transform", "hkTransform")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpAttachBodyCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("compoundBodyId", "hknpBodyId")
        ADD("updateMotionMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpBodyId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDetachBodyCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("updateMotionMode", "hkUint8")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRemoveBodyCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("activationMode", "hkUint8")
        ADD("isLastInBatch", "hkBool")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpAddBodyCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("additionMode", "hkUint8")
        ADD("activationMode", "hkUint8")
        ADD("isLastInBatch", "hkBool")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDestroyBodyCommand", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("activationMode", "hkUint8")
        ADD("isLastInBatch", "hkBool")
        DEPENDS("hknpApiCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyAllocatedAttachedTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("cinfo", "hknpBodyCinfo")
        ADD("targetId", "hknpBodyId")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpBodyCinfo", 6)
        DEPENDS("hknpBodyId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyAllocatedTrace", 0)
        SET_PARENT(HK_NULL, "hknpApiCommand")
        ADD("cinfo", "hknpBodyCinfo")
        DEPENDS("hknpApiCommand", 0)
        DEPENDS("hknpBodyCinfo", 6)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpApiCommand", 0)
        SET_PARENT(HK_NULL, "hkCommand")
        ADD("bodyId", "hknpBodyId")
        DEPENDS("hkCommand", 0)
        DEPENDS("hknpBodyId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBinaryBodyDebugEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        ADD("debugText", "char[N]< 128 >")
        DEPENDS("hknpBinaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUnaryBodyDebugEvent", 0)
        SET_PARENT(HK_NULL, "hknpUnaryBodyEvent")
        ADD("debugText", "char[N]< 128 >")
        DEPENDS("hknpUnaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpReserved3Event", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        DEPENDS("hknpEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpReserved2Event", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        DEPENDS("hknpEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpReserved1Event", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        DEPENDS("hknpEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpReserved0Event", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        DEPENDS("hknpEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyExitedBroadPhaseEvent", 0)
        SET_PARENT(HK_NULL, "hknpUnaryBodyEvent")
        DEPENDS("hknpUnaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBinaryBodyEvent", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        ADD("bodyIds", "hknpBodyId[2]")
        DEPENDS("hknpEvent", 0)
        DEPENDS("hknpBodyId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUnaryBodyEvent", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        ADD("bodyId", "hknpBodyId")
        DEPENDS("hknpEvent", 0)
        DEPENDS("hknpBodyId", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpEmptyEvent", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        DEPENDS("hknpEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpEvent", 0)
        SET_PARENT(HK_NULL, "hkCommand")
        DEPENDS("hkCommand", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpLinearIntegrationClippedEvent", 0)
        SET_PARENT(HK_NULL, "hknpUnaryBodyEvent")
        ADD("stolenVelocity", "hkVector4")
        DEPENDS("hknpUnaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintForceExceededEvent", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        ADD("constraintId", "hknpConstraintId")
        DEPENDS("hknpEvent", 0)
        DEPENDS("hknpConstraintId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintForceEvent", 0)
        SET_PARENT(HK_NULL, "hknpEvent")
        ADD("constraintId", "hknpConstraintId")
        DEPENDS("hknpEvent", 0)
        DEPENDS("hknpConstraintId", 1)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpFullCastCollisionEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        ADD("contactPosition", "hkVector4")
        ADD("contactNormalAndDistance", "hkVector4")
        ADD("motionTransformA", "hkQTransform")
        ADD("linearVelocityA", "hkVector4")
        ADD("angularVelocityA", "hkVector4")
        ADD("time", "hkReal")
        ADD("shapeKeyA", "hkHandle< hkUint32, 4294967295 >")
        ADD("shapeKeyB", "hkHandle< hkUint32, 4294967295 >")
        DEPENDS("hknpBinaryBodyEvent", 0)
        DEPENDS("hkQTransform", 2)
        DEPENDS("hkHandle< hkUint32, 4294967295 >", 0)
        DEPENDS("hkHandle< hkUint32, 4294967295 >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDeflectedLinearCastCollisionEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        ADD("normal", "hkVector4")
        ADD("position", "hkVector4")
        ADD("bodyAPosition", "hkVector4")
        ADD("bodyAInitLinearVelocity", "hkVector4")
        DEPENDS("hknpBinaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpContactImpulseClippedEvent", 0)
        SET_PARENT(HK_NULL, "hknpContactSolverEvent")
        ADD("sumContactImpulseUnclipped", "hkReal")
        DEPENDS("hknpContactSolverEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpContactImpulseEvent", 0)
        SET_PARENT(HK_NULL, "hknpContactSolverEvent")
        ADD("status", "hkUint8")
        ADD("frictionFactor", "hkReal")
        ADD("contactImpulses", "hkReal[4]")
        DEPENDS("hknpContactSolverEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpContactSolverEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        DEPENDS("hknpBinaryBodyEvent", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpTriggerEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        ADD("type", "hknpMaterial::TriggerType")
        ADD("status", "hkUint8")
        ADD("shapeKeys", "hkHandle< hkUint32, 4294967295 >[2]")
        DEPENDS("hknpBinaryBodyEvent", 0)
        DEPENDS("hkHandle< hkUint32, 4294967295 >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpManifoldEvent", 0)
        SET_PARENT(HK_NULL, "hknpBinaryBodyEvent")
        ADD("status", "hkUint8")
        ADD("isFullCast", "hkUint8")
        ADD("shapeKeys", "hkHandle< hkUint32, 4294967295 >[2]")
        ADD("manifold", "hkcdManifold4")
        DEPENDS("hknpBinaryBodyEvent", 0)
        DEPENDS("hkHandle< hkUint32, 4294967295 >", 0)
        DEPENDS("hkcdManifold4", 0)
END()

BEGIN_EMPTY(HK_NULL, HK_CLASS_ADDED, "hknpVdbEvents", 0)
END_EMPTY()

BEGIN_EMPTY(HK_NULL, HK_CLASS_ADDED, "hknpVdbApiCommands", 0)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionPropertiesId", 0)
        SET_PARENT(HK_NULL, "hknpMotionPropertiesIdBase")
        DEPENDS("hknpMotionPropertiesIdBase", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionPropertiesIdBase", 0)
        SET_PARENT(HK_NULL, "hkHandle< hkUint16, 65535 >")
        DEPENDS("hkHandle< hkUint16, 65535 >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionId", 0)
        SET_PARENT(HK_NULL, "hknpMotionIdBase")
        DEPENDS("hknpMotionIdBase", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionIdBase", 0)
        SET_PARENT(HK_NULL, "hkHandle< hkUint32, 2147483647 >")
        DEPENDS("hkHandle< hkUint32, 2147483647 >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterialId", 0)
        SET_PARENT(HK_NULL, "hknpMaterialIdBase")
        DEPENDS("hknpMaterialIdBase", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterialIdBase", 0)
        SET_PARENT(HK_NULL, "hkHandle< hkUint16, 65535 >")
        DEPENDS("hkHandle< hkUint16, 65535 >", 0)
END()

BEGIN( HK_NULL, HK_CLASS_ADDED, "hknpBodyIdPair", 0 )
        ADD( "bodyA", "hknpBodyId" )
        ADD("bodyB", "hknpBodyId")
        DEPENDS("hknpBodyId", 0)
END()

BEGIN( "hknpDebrisShape", 0, "hknpDebrisShape", 1 )
        ADD( "innerSphere", "hkVector4" )
        FUNCTION( hknpDebrisShape_0_1_addUniqueVertices_addInnerSphere )
END()

BEGIN( "hknpBody", 8, "hknpBody", 9 )
        ADD( "maxContactDistanceFromRotation", "hkUint16" )
        FUNCTION( hknpBody_8_to_9 )
END()

BEGIN( "hknpWorldCinfo", 11, "hknpWorldCinfo", 12 )
        ADD( "useBodyBacklinkBuffer", "hkBool" )
        ADD( "particlesLandscapeQuadCacheSize", "hkInt32" )
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExtendedExternMeshShapeGeometry::Quad", 0)
        ADD("vertices", "hkVector4[4]")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExtendedExternMeshShapeGeometry::Triangle", 0)
        ADD("vertices", "hkVector4[3]")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExtendedExternMeshShapeGeometry", 0)
        SET_PARENT(HK_NULL, "hknpExternMeshShapeGeometry")
        ADD("triangles", "hkArray< hknpExtendedExternMeshShapeGeometry::Triangle >")
        ADD("quads", "hkArray< hknpExtendedExternMeshShapeGeometry::Quad >")
        DEPENDS("hknpExternMeshShapeGeometry", 0)
        DEPENDS("hknpExtendedExternMeshShapeGeometry::Triangle", 0)
        DEPENDS("hknpExtendedExternMeshShapeGeometry::Quad", 0)
END()

BEGIN( "hknpMotionProperties", 4, "hknpMotionProperties", 5 )
    ADD( "deactivationSettings", "hknpMotionProperties::DeactivationSettings" )
    ADD( "fullCastSettings", "hknpMotionProperties::FullCastSettings" )
    FUNCTION( hknpMotionProperties_4_to_hknpMotionProperties_5 )
    REMOVE( "minimumSpikingVelocityScaleSquared", "unsigned char" )
    REMOVE( "spikingVelocityScaleThresholdSquared", "unsigned char" )
    REMOVE( "minimumPathingVelocityScaleSquare", "unsigned char" )
    REMOVE( "deactivationVelocityScaleSquare", "unsigned char" )
    REMOVE( "numDeactivationFrequencyPasses", "unsigned char" )
    REMOVE( "pathingLowerThreshold", "int" )
    REMOVE( "pathingUpperThreshold", "int" )
    REMOVE( "invBlockSize", "float" )
    REMOVE( "maxRotSqrd", "float" )
    REMOVE( "maxDistSqrd", "float" )
    DEPENDS( "hknpMotionProperties::DeactivationSettings", 0 )
    DEPENDS( "hknpMotionProperties::FullCastSettings", 0 )
END()

BEGIN( "hkFreeListArrayElement< hknpMotionProperties >", 4, "hkFreeListArrayElement< hknpMotionProperties >", 5 )
    DEPENDS( "hknpMotionProperties", 5 )
END()

BEGIN( "hknpBridgeConstraintAtom", 0, "hknpBridgeConstraintAtom", 1 )
    SET_PARENT( "hkpConstraintAtom", "hkpBridgeConstraintAtom" )
    REMOVE( "constraintData", "hkpConstraintData*" )
    DEPENDS( "hkpConstraintAtom", 0 )
    DEPENDS( "hkpBridgeConstraintAtom", 0 )
    DEPENDS( "hkpConstraintData", 0 )
END()

BEGIN( "hknpMalleableConstraintData", 0, "hknpMalleableConstraintData", 1 )
    DEPENDS( "hknpBridgeConstraintAtom", 1 )
    FUNCTION( hknpMalleableConstraintData_0_1 )
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpParticleShapeLibrary", 0)
        SET_PARENT(HK_NULL, "hkReferencedObject")
        ADD("properties", "hkArray< hknpParticleShapeProperties* >")
        ADD("maxOuterRadius", "hkReal")
        DEPENDS("hkReferencedObject", 3)
        DEPENDS("hknpParticleShapeProperties", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpParticleShapeProperties", 0)
        ADD("particleFaces", "hkArray< hknpParticle4Faces >")
        ADD("faceVertices", "hkArray< hknpParticleFaceVerticesWithEffMass >")
        ADD("shape", "hknpConvexShape*")
        ADD("relativePenetrationRecoveryVelocity", "hkReal")
        ADD("maxPenetrationRecoveryVelocity", "hkReal")
        ADD("convexRadii", "hkVector4")
        DEPENDS("hknpParticle4Faces", 0)
        DEPENDS("hknpParticleFaceVerticesWithEffMass", 0)
        DEPENDS("hknpConvexShape", 1)
END()


BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpParticleFaceVerticesWithEffMass", 0)
        ADD("faceVertices", "hkFourTransposedPointsf")
        ADD("effectiveMasses", "hkVector4")
        ADD("distance", "hkReal")
        ADD("contactRadius", "hkReal")
        ADD("frictionEffMass", "hkReal")
        ADD("shapeCanSettleOnFace", "hkBool")
        DEPENDS("hkFourTransposedPointsf", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpParticle4Faces", 0)
        ADD("directions", "hkFourTransposedPointsf")
        DEPENDS("hkFourTransposedPointsf", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStorageParticleSystem", 0)
        ADD("originalId", "hkHandle< hkUint32, 2147483647 >")
        ADD("id", "hkHandle< hkUint32, 2147483647 >")
        ADD("friction", "hkReal")
        ADD("restitution", "hkReal")
        ADD("shape", "hknpConvexShape*")
        ADD("collisionFilterInfo", "hkUint32")
        ADD("rigidBodyCollisionLod", "int")
        ADD("enableDynamicBodyCollisions", "bool")
        ADD("enableParticleParticleCollisions", "bool")
        ADD("enableDeterministicParticleParticleCollisions", "bool")
        ADD("refitBoundingVolumeAfterStep", "bool")
        ADD("raiseParticleBodyCollisionEvents", "bool")
        ADD("raiseParticleParticleCollisionEvents", "bool")
        ADD("callbackImpulseThreshold", "hkReal")
        ADD("supportDisabledParticles", "bool")
        ADD("maxBatchSize", "hkInt32")
        ADD("numParticles", "int")
        ADD("capacity", "int")
        ADD("userData", "hkUint64")
        ADD("doAngular", "bool")
        ADD("particleParticleFriction", "hkReal")
        ADD("particleShapeIndex", "int")
        ADD("positions", "hkArray< hkVector4 >")
        ADD("orientations", "hkArray< hkVector4 >")
        ADD("linearVelocities", "hkArray< hkVector4 >")
        ADD("angularVelocities", "hkArray< hkVector4 >")
        ADD("frictions", "hkArray< hkReal >")
        ADD("restitutions", "hkArray< hkReal >")
        ADD("shapes", "hkArray< hknpConvexShape* >")
        ADD("shapeIndices", "hkArray< int >")
        ADD( "enabledParticles", "hkArray< hkBool >" )
        DEPENDS("hkHandle< hkUint32, 2147483647 >", 0)
        DEPENDS("hkHandle< hkUint32, 2147483647 >", 0)
        DEPENDS("hknpConvexShape", 1)
END()

BEGIN_EMPTY("hknpCompoundShapeTree", 0, "hknpCompoundShapeCdDynamicTree", 0)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompoundShapeSimdTree", 0)
        SET_PARENT(HK_NULL, "hkcdSimdTree")
        ADD("points", "hkArray< hkVector4 >")
        DEPENDS("hkcdSimdTree", 2)
END()

BEGIN("hknpCompoundShapeData", 0, "hknpCompoundShapeData", 1)
        ADD("simdTree", "hknpCompoundShapeSimdTree")
        ADD("type", "hkUint8")
        DEPENDS("hknpCompoundShapeCdDynamicTree", 0)
        DEPENDS("hknpCompoundShapeSimdTree", 0)
END()

BEGIN_EMPTY("hknpCompoundShapeInternalsKeyMask", 2, "hknpCompoundShapeInternalsCdDynamicTreeKeyMask", 0)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompoundShapeInternalsSimdTreeKeyMask", 0)
        SET_PARENT(HK_NULL, "hknpCompoundShapeKeyMask")
        ADD("shape", "hknpCompoundShape*")
        ADD("instanceMasks", "hkArray< hknpShapeKeyMask* >")
        ADD("enableInstances", "hkBitField")
        DEPENDS("hknpCompoundShapeKeyMask", 0)
        DEPENDS("hknpCompoundShape", 5)
        DEPENDS("hknpShapeKeyMask", 0)
        DEPENDS("hkBitField", 2)
END()

BEGIN( "hknpMaterial", 4, "hknpMaterial", 5 )
        REMOVE( "isShared", "unsigned char" )
END()

BEGIN_EMPTY("hkFreeListArrayElement< hknpMaterial >", 4, "hkFreeListArrayElement< hknpMaterial >", 5)
END_EMPTY();


BEGIN( "hknpExternMeshShape", 2, "hknpExternMeshShape", 3 )
        FUNCTION( hknpExternMeshShape_2_3_numShapeKeyBits_Patch )
END()

BEGIN("hknpCompressedMeshShape", 6, "hknpCompressedMeshShape", 7)
        ADD("externShapes", "hkArray< hknpShapeInstance >")
        DEPENDS("hknpShapeInstance", 3)
        DEPENDS("hkcdStaticMeshTreeBase", 3)
END()

BEGIN("hknpWorldSnapshot", 1, "hknpWorldSnapshot", 2)
        ADD("particleSystems", "hkArray< hknpStorageParticleSystem >")
        DEPENDS("hknpStorageParticleSystem", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbWorld", 0)
        SET_PARENT(HK_NULL, "hknpWorldCinfo")
        ADD("name", "hkStringPtr")
        DEPENDS("hknpWorldCinfo", 12)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbShapeDisplayMarker", 0)
        SET_PARENT(HK_NULL, "hkDebugDisplayMarker")
        DEPENDS("hkDebugDisplayMarker", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbParticlesShapeDisplay", 0)
        SET_PARENT(HK_NULL, "hkDebugDisplayMarker")
        DEPENDS("hkDebugDisplayMarker", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbMassProperties", 0)
        ADD("mass", "hkReal")
        ADD("inertiaLocal", "hkFloat3")
        ADD("centerOfMassLocal", "hkFloat3")
        DEPENDS("hkFloat3", 0)
        DEPENDS("hkFloat3", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbManifoldDisplay", 0)
        SET_PARENT(HK_NULL, "hkDebugDisplayMarker")
        DEPENDS("hkDebugDisplayMarker", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpManifoldViewerBase::hknpVdbManifold", 0)
        ADD("bodyIds", "hknpBodyId[2]")
        ADD("shapeKeys", "hkHandle< hkUint32, 4294967295 >[2]")
        ADD("lodInfo", "unsigned char")
        ADD("status", "hkFlags< hknpManifoldViewerBase::hknpVdbManifold::StatusEnum, hkUint8 >")
        DEPENDS("hknpBodyId", 0)
        DEPENDS("hkHandle< hkUint32, 4294967295 >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbCharacterDisplayMarker", 0)
        SET_PARENT(HK_NULL, "hkDebugDisplayMarker")
        DEPENDS("hkDebugDisplayMarker", 0)
END()

BEGIN_EMPTY(HK_NULL, HK_CLASS_ADDED, "hknpVdbCharacterProxies", 0)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCharacterProxy", 0)
        SET_PARENT(HK_NULL, "hkReferencedObject")
        ADD("shape", "hknpShape*")
        ADD("userData", "hkUint64")
        ADD("bodyId", "hknpBodyId")
        ADD("collisionFilterInfo", "hkUint32")
        ADD("transform", "hkTransform")
        ADD("aabb", "hkAabb")
        ADD("velocity", "hkVector4")
        ADD("lastDisplacement", "hkVector4")
        ADD("lastVelocity", "hkVector4")
        ADD("lastInvDeltaTime", "hkReal")
        ADD("maxSlopeCosine", "hkReal")
        ADD("dynamicFriction", "hkReal")
        ADD("staticFriction", "hkReal")
        ADD("up", "hkVector4")
        ADD("keepDistance", "hkReal")
        ADD("keepContactTolerance", "hkReal")
        ADD("contactAngleSensitivity", "hkReal")
        ADD("userPlanes", "int")
        ADD("maxCharacterSpeedForSolver", "hkReal")
        ADD("characterStrength", "hkReal")
        ADD("characterMass", "hkReal")
        ADD("penetrationRecoverySpeed", "hkReal")
        ADD("maxCastIterations", "int")
        ADD("refreshManifoldInCheckSupport", "hkBool")
        DEPENDS("hkReferencedObject", 3)
        DEPENDS("hknpShape", 4)
        DEPENDS("hknpBodyId", 0)
        DEPENDS("hkAabb", 0)
END()

BEGIN( "hknpReserved3Event", 0, HK_NULL, HK_CLASS_REMOVED )
    SET_PARENT( "hknpEvent", HK_NULL )
    DEPENDS( "hknpEvent", 0 )
END()

BEGIN( "hknpReserved2Event", 0, HK_NULL, HK_CLASS_REMOVED )
    SET_PARENT( "hknpEvent", HK_NULL )
    DEPENDS( "hknpEvent", 0 )
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpParticlesColliderId", 0)
        ADD("serialAndIndex", "hkUint32")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVdbBody", 0)
        ADD("id", "hknpBodyId")
        ADD("index", "int")
        ADD("name", "hkStringPtr")
        DEPENDS("hknpBodyId", 0)
END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
