// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

namespace
{
    void hknpCompoundShape_4_5_baseRemoval_backupMembers(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        // Backup all(!) members of hknpCompoundShapeBase and all of its base classes.

        // hkReferencedObject members
        obj["propertyBag_tmp"].assign(obj["propertyBag"]);
        obj["memSizeAndFlags_tmp"].assign(obj["memSizeAndFlags"]);
        obj["refCount_tmp"].assign(obj["refCount"]);

        // hknpShape members
        obj["flags_tmp"].assign(obj["flags"]);
        obj["type_tmp"].assign(obj["type"]);
        obj["numShapeKeyBits_tmp"].assign(obj["numShapeKeyBits"]);
        obj["dispatchType_tmp"].assign(obj["dispatchType"]);
        obj["convexRadius_tmp"].assign(obj["convexRadius"]);
        obj["userData_tmp"].assign(obj["userData"]);
        obj["properties_tmp"].assign(obj["properties"]);

        // hknpCompositeShape members
        obj["shapeTagCodecInfo_tmp"].assign(obj["shapeTagCodecInfo"]);
        obj["materialTable_tmp"].assign(obj["materialTable"]);

        // hknpCompoundShapeBase members
        obj["instances_tmp"].assign(obj["instances"]);
        obj["instanceVelocities_tmp"].assign(obj["instanceVelocities"]);
        obj["aabb_tmp"].assign(obj["aabb"]);
        obj["isMutable_tmp"].assign(obj["isMutable"]);
        obj["estimatedNumShapeKeys_tmp"].assign(obj["estimatedNumShapeKeys"]);
    }

    void hknpCompoundShape_4_5_baseRemoval_restoreUntouchedMembers(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        // After we have now reset the parent class of hknpCompoundShape to hknpCompositeShape in the patch itself, we
        // now need to restore all members of hknpCompositeShape and its base classes (as their values have been reset
        // by the re-parenting).

        // hkReferencedObject members
        obj["propertyBag"].assign(obj["propertyBag_tmp"]);
        obj["memSizeAndFlags"].assign(obj["memSizeAndFlags_tmp"]);
        obj["refCount"].assign(obj["refCount_tmp"]);

        // hknpShape members
        obj["flags"].assign(obj["flags_tmp"]);
        obj["type"].assign(obj["type_tmp"]);
        obj["numShapeKeyBits"].assign(obj["numShapeKeyBits_tmp"]);
        obj["dispatchType"].assign(obj["dispatchType_tmp"]);
        obj["convexRadius"].assign(obj["convexRadius_tmp"]);
        obj["userData"].assign(obj["userData_tmp"]);
        obj["properties"].assign(obj["properties_tmp"]);

        // hknpCompoundShapeBase members
        obj["shapeTagCodecInfo"].assign(obj["shapeTagCodecInfo_tmp"]);
        obj["materialTable"].assign(obj["materialTable_tmp"]);

        // The former members of hknpCompoundShapeBase are already/still available (unchanged) via the 'tmp' members
        // and we can simply rename them back to their actual names in the patch itself.
    }

    void hknpDebrisShape_0_1_addUniqueVertices_addInnerSphere( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        hkReflect::Var verticesArray( obj["vertices"] );
        hkReflect::ArrayValue array = hkReflect::ArrayVar( verticesArray ).getValue();
        hkVector4* rArray = reinterpret_cast<hkVector4*>(array.getAddress());

        hkVector4 vertex; vertex.set( rArray[array.getCount() - 1] );
        for( int i = array.getCount() - 2; i >= 0; i-- )
        {
            if( vertex.equal( rArray[i] ).allAreSet() )
            {
                vertex = rArray[i];
            }
            else
            {
                int numVertices = i + 2;
                obj["numOfUniqueVertices"].assign( &numVertices );
                break;
            }
        }

        hkVector4 innerSphere = hkVec4_0;
        obj["innerSphere"].assign( &innerSphere );
    }

    void hknpMalleableConstraintData_0_1( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        void* addr = obj.getAddress();
        hkReflect::Var atom = obj["atom"];
        atom["constraintData"].assign( &addr );
    }

    void hknpExternMeshShape_2_3_numShapeKeyBits_Patch( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        hkReflect::Var numShapeKeyBitsVar = obj["numShapeKeyBits"];
        hkUint8 numShapeKeyBits = *(hkUint8*)numShapeKeyBitsVar.getData();
        numShapeKeyBits++;
        numShapeKeyBitsVar.assign( &numShapeKeyBits );
    }

    void hknpBody_8_to_9( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        // Make sure IS_PARTICLES_COLLIDER flag is not set (RAISE_MANIFOLD_STATUS_EVENTS used the same value in earlier versions)
        hkReflect::IntVar flagsVar = obj["flags"];
        int flags; flagsVar.getValue().get( &flags );
        flags &= ~(1<<5);
        flagsVar.assign( &flags );
    }

    void hknpMotionProperties_4_to_hknpMotionProperties_5( hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper )
    {
        hkReflect::Var ds = obj["deactivationSettings"];
        ds["maxDistSqrd"].assign( obj["maxDistSqrd"] );
        ds["maxRotSqrd"].assign( obj["maxRotSqrd"] );
        ds["invBlockSize"].assign( obj["invBlockSize"] );
        ds["pathingUpperThreshold"].assign( obj["pathingUpperThreshold"] );
        ds["pathingLowerThreshold"].assign( obj["pathingLowerThreshold"] );
        ds["numDeactivationFrequencyPasses"].assign( obj["numDeactivationFrequencyPasses"] );
        ds["deactivationVelocityScaleSquare"].assign( obj["deactivationVelocityScaleSquare"] );
        ds["minimumPathingVelocityScaleSquare"].assign( obj["minimumPathingVelocityScaleSquare"] );
        ds["spikingVelocityScaleThresholdSquared"].assign( obj["spikingVelocityScaleThresholdSquared"] );
        ds["minimumSpikingVelocityScaleSquared"].assign( obj["minimumSpikingVelocityScaleSquared"] );
    }
}

void HK_CALL registerNewPhysicsPatches_2016_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_2/hknpPatches_2016_2.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
