// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

namespace
{

    hkUint32 extractIndexFromHknpBodyId(hkUint32 indexAndSerial)
    {
        hkUint32 INDEX_MASK = 0x00ffffff;

        // use only the index part of the hknpBodyId for our new rigidBodyIndex
        hkInt32 indexOnlyValue = hkInt32(indexAndSerial & INDEX_MASK);

        // check whether the id is invalid
        if ((indexAndSerial & INDEX_MASK) == INDEX_MASK) // if invalid
        {
            indexOnlyValue = -1; // -1 means invalid index
        }

        return indexOnlyValue;
    }


    void hkndDestructionSystemData_BodyClone_2_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var src(obj["rigidBodyId"]); // override type was hkUint32
        hkReflect::IntVar intSrc = src;
        hkUint32 indexAndSerial = intSrc.getValue().convertTo<hkUint32>();

        hkUint32 indexOnlyValue = extractIndexFromHknpBodyId(indexAndSerial);

        hkReflect::Var dst(obj["rigidBodyIndex"]);
        dst.assign(&indexOnlyValue);
    }

    void hkndBodyCinfo_2_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var src(obj["rigidBodyId"]["serialAndIndex"]);
        hkReflect::IntVar intSrc = src;
        hkUint32 indexAndSerial = intSrc.getValue().convertTo<hkUint32>();

        hkUint32 indexOnlyValue = extractIndexFromHknpBodyId(indexAndSerial);

        hkReflect::Var dst(obj["rigidBodyIndex"]);
        dst.assign(&indexOnlyValue);
    }
}

void HK_CALL registerNewDestructionPatches_2016_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_2/hkndPatches_2016_2.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
