// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file
namespace
{
void hkcdStaticMeshTreeBase_2_to_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::Var primitivesArray( obj["primitives"] );
    hkReflect::ArrayValue primitives = hkReflect::ArrayVar( primitivesArray ).getValue();
    for( int i = 0; i < primitives.getCount(); i++ )
    {
        hkReflect::Var indices = primitives[i]["indices"];

        if(indices[1].equals(indices[3]))
        {
            hkReflect::IntVar indices1(indices[1]);
            hkReflect::IntVar indices2(indices[2]);
            hkReflect::IntVar indices3(indices[3]);

            if(!(indices1.getValue() == 0xad && indices2.getValue() == 0xde && indices3.getValue() == 0xad))
            {
                // CUSTOM is currently the only primitive extension.
                // See hkcdStaticMeshTreeBase::Primitive::getType
                hkReflect::IntVar(indices[2]).setValue(3);
            }
        }
    }
}
}

void HK_CALL registerCollidePatches_2016_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_2/hkcdPatches_2016_2.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
