// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file
namespace
{
void hkResult_0_to_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::IntValue val;
    hkReflect::IntVar(obj["enum"]).getValue(&val);
    if(!val.equals(0))
    {
        int failureVal = 0x80040200; //HK_FAILURE
        obj["code"].assign(&failureVal);
    }
}

void hkFloat16_0_to_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    // The difference between version 0 and version 1 is that the new version
    // encodes +-INF and NAN numbers when the float-16 5-bit exponent is full,
    // i.e equal to the mask 0x7C00. In the old version, those were regular numbers.
    // Obviously, they are too high to be represented in the new version, and 
    // letting them load as non-numbers causes all kinds of problems because that 
    // is not their intended meaning.
    //
    // The fix is to clamp hkFloat16_v0 high numbers to hkFloat16_v1 high numbers, 
    // preventing them from turning into hkFloat16_v1 non-numbers (+-INF or NAN).

    hkUint16 v0_hex;
    {
        hkReflect::IntValue val;
        hkReflect::IntVar(obj["value"]).getValue(&val);
        v0_hex = val.convertTo<hkUint16>();
    }

    const hkUint16 f16_exp_mask = 0x7C00;
    const hkUint16 f16_sgn_mask = 0x8000;
    const hkUint16 v1_neg_max = 0xFBFF;
    const hkUint16 v1_pos_max = 0x7BFF;

    hkUint16 v1_hex;
    if ((v0_hex & f16_exp_mask) == f16_exp_mask)
    {
        // clamp case: use the sign to assign the correct clamping hex pattern
        v1_hex = (v0_hex&f16_sgn_mask) ? v1_neg_max : v1_pos_max;
    }
    else
    {
        // regular case: just copy the hex pattern
        v1_hex = v0_hex; 
    }
    obj["value"].assign(&v1_hex);
}

}

void HK_CALL registerCommonPatches_2016_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_2/hkPatches_2016_2.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
